/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.experimental;

import java.net.Socket;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.experimental.SocketStreamIterator;
import org.junit.Assert;
import org.junit.Test;

public class SocketStreamIteratorTest {
    @Test
    public void testIterator() throws Exception {
        final AtomicReference error = new AtomicReference();
        final long seed = new Random().nextLong();
        int numElements = 1000;
        final SocketStreamIterator iterator = new SocketStreamIterator((TypeSerializer)LongSerializer.INSTANCE);
        Thread writer = new Thread(){

            @Override
            public void run() {
                try (Socket sock = new Socket(iterator.getBindAddress(), iterator.getPort());
                     DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(sock.getOutputStream());){
                    LongSerializer serializer = LongSerializer.INSTANCE;
                    Random rnd = new Random(seed);
                    for (int i = 0; i < 1000; ++i) {
                        serializer.serialize((Object)rnd.nextLong(), (DataOutputView)out);
                    }
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        writer.start();
        Random validator = new Random(seed);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((long)validator.nextLong(), (long)((Long)iterator.next()));
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        writer.join();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorWithException() throws Exception {
        final SocketStreamIterator iterator = new SocketStreamIterator((TypeSerializer)LongSerializer.INSTANCE);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                iterator.notifyOfError((Throwable)new Exception("test"));
            }
        }.start();
        try {
            iterator.hasNext();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("test"));
        }
    }
}

