/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.BatchGlobalCommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BatchGlobalCommitterOperatorTest
extends TestLogger {
    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutCommitter() throws Exception {
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(null);
        testHarness.initializeEmptyState();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void doNotSupportRetry() throws Exception {
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(new TestSink.AlwaysRetryGlobalCommitter());
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElement((StreamRecord<String>)new StreamRecord((Object)"hotel"));
        testHarness.endInput();
        testHarness.close();
    }

    @Test
    public void endOfInput() throws Exception {
        TestSink.DefaultGlobalCommitter globalCommitter = new TestSink.DefaultGlobalCommitter();
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(globalCommitter);
        List<String> inputs = Arrays.asList("compete", "swear", "shallow");
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElements(inputs.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.endInput();
        List<String> expectedCommittedData = Arrays.asList(globalCommitter.combine((List)inputs), "end of input");
        MatcherAssert.assertThat(globalCommitter.getCommittedData(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedCommittedData.toArray()));
        testHarness.close();
    }

    @Test
    public void close() throws Exception {
        TestSink.DefaultGlobalCommitter globalCommitter = new TestSink.DefaultGlobalCommitter();
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(globalCommitter);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.close();
        MatcherAssert.assertThat((Object)globalCommitter.isClosed(), (Matcher)Matchers.is((Object)true));
    }

    private OneInputStreamOperatorTestHarness<String, String> createTestHarness(GlobalCommitter<String, String> globalCommitter) throws Exception {
        return new OneInputStreamOperatorTestHarness<String, String>((OneInputStreamOperatorFactory<String, String>)new BatchGlobalCommitterOperatorFactory((Sink)TestSink.newBuilder().setGlobalCommitter(globalCommitter).setGlobalCommittableSerializer(TestSink.StringCommittableSerializer.INSTANCE).build()), (TypeSerializer<String>)StringSerializer.INSTANCE);
    }
}

