/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamstatus;

import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.junit.Assert;
import org.junit.Test;

public class StreamStatusTest {
    @Test(expected=IllegalArgumentException.class)
    public void testIllegalCreationThrowsException() {
        new StreamStatus(32);
    }

    @Test
    public void testEquals() {
        StreamStatus idleStatus = new StreamStatus(-1);
        StreamStatus activeStatus = new StreamStatus(0);
        Assert.assertEquals((Object)StreamStatus.IDLE, (Object)idleStatus);
        Assert.assertTrue((boolean)idleStatus.isIdle());
        Assert.assertFalse((boolean)idleStatus.isActive());
        Assert.assertEquals((Object)StreamStatus.ACTIVE, (Object)activeStatus);
        Assert.assertTrue((boolean)activeStatus.isActive());
        Assert.assertFalse((boolean)activeStatus.isIdle());
    }

    @Test
    public void testTypeCasting() {
        StreamStatus status = StreamStatus.ACTIVE;
        Assert.assertTrue((boolean)status.isStreamStatus());
        Assert.assertFalse((boolean)status.isRecord());
        Assert.assertFalse((boolean)status.isWatermark());
        Assert.assertFalse((boolean)status.isLatencyMarker());
        try {
            status.asWatermark();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            status.asRecord();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            status.asLatencyMarker();
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

