/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.io.StreamTwoInputProcessorFactory;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.checkpointing.InputProcessorUtil;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.AbstractTwoInputStreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class TwoInputStreamTask<IN1, IN2, OUT>
extends AbstractTwoInputStreamTask<IN1, IN2, OUT> {
    public TwoInputStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    protected void createInputProcessor(List<IndexedInputGate> inputGates1, List<IndexedInputGate> inputGates2, Function<Integer, StreamPartitioner<?>> gatePartitioners) {
        CheckpointedInputGate[] checkpointedInputGates = InputProcessorUtil.createCheckpointedMultipleInputGate(this, this.getConfiguration(), this.getCheckpointCoordinator(), this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.getTaskNameWithSubtaskAndId(), this.mainMailboxExecutor, new List[]{inputGates1, inputGates2}, Collections.emptyList(), this.systemTimerService);
        Preconditions.checkState((checkpointedInputGates.length == 2 ? 1 : 0) != 0);
        this.inputProcessor = StreamTwoInputProcessorFactory.create(this, checkpointedInputGates, this.getEnvironment().getIOManager(), this.getEnvironment().getMemoryManager(), this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.getStreamStatusMaintainer(), (TwoInputStreamOperator)this.mainOperator, this.input1WatermarkGauge, this.input2WatermarkGauge, this.operatorChain, this.getConfiguration(), this.getTaskConfiguration(), this.getJobConfiguration(), this.getExecutionConfig(), this.getUserCodeClassLoader(), this.setupNumRecordsInCounter(this.mainOperator), this.getEnvironment().getTaskStateManager().getInputRescalingDescriptor(), gatePartitioners, this.getEnvironment().getTaskInfo());
    }
}

