/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

@PublicEvolving
public class FromIteratorFunction<T>
implements SourceFunction<T> {
    private static final long serialVersionUID = 1L;
    private final Iterator<T> iterator;
    private volatile boolean isRunning = true;

    public FromIteratorFunction(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        while (this.isRunning && this.iterator.hasNext()) {
            ctx.collect(this.iterator.next());
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }
}

