/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.operators.sink.BatchGlobalCommitterOperator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public final class BatchGlobalCommitterOperatorFactory<CommT, GlobalCommT>
extends AbstractStreamOperatorFactory<GlobalCommT>
implements OneInputStreamOperatorFactory<CommT, GlobalCommT> {
    private final Sink<?, CommT, ?, GlobalCommT> sink;

    public BatchGlobalCommitterOperatorFactory(Sink<?, CommT, ?, GlobalCommT> sink) {
        this.sink = (Sink)Preconditions.checkNotNull(sink);
    }

    @Override
    public <T extends StreamOperator<GlobalCommT>> T createStreamOperator(StreamOperatorParameters<GlobalCommT> parameters) {
        BatchGlobalCommitterOperator batchGlobalCommitterOperator;
        try {
            batchGlobalCommitterOperator = new BatchGlobalCommitterOperator((GlobalCommitter)this.sink.createGlobalCommitter().orElseThrow(() -> new IllegalStateException("Could not create global committer from the sink")));
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not create the GlobalCommitter.", (Throwable)e);
        }
        batchGlobalCommitterOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        return (T)batchGlobalCommitterOperator;
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return BatchGlobalCommitterOperator.class;
    }
}

