/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.datagen.table.types.RowDataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.DataGeneratorSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;

@Internal
public class DataGenTableSource
implements ScanTableSource {
    private final DataGenerator<?>[] fieldGenerators;
    private final String tableName;
    private final TableSchema schema;
    private final long rowsPerSecond;
    private final Long numberOfRows;

    public DataGenTableSource(DataGenerator<?>[] fieldGenerators, String tableName, TableSchema schema, long rowsPerSecond, Long numberOfRows) {
        this.fieldGenerators = fieldGenerators;
        this.tableName = tableName;
        this.schema = schema;
        this.rowsPerSecond = rowsPerSecond;
        this.numberOfRows = numberOfRows;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        boolean isBounded = this.numberOfRows != null;
        return SourceFunctionProvider.of(this.createSource(), isBounded);
    }

    @VisibleForTesting
    public DataGeneratorSource<RowData> createSource() {
        return new DataGeneratorSource((DataGenerator)new RowDataGenerator(this.fieldGenerators, this.schema.getFieldNames()), this.rowsPerSecond, this.numberOfRows);
    }

    public DynamicTableSource copy() {
        return new DataGenTableSource(this.fieldGenerators, this.tableName, this.schema, this.rowsPerSecond, this.numberOfRows);
    }

    public String asSummaryString() {
        return "DataGenTableSource";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }
}

