/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TableReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final QueryOperation queryOperation;

    TableReferenceExpression(String name, QueryOperation queryOperation) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.queryOperation = (QueryOperation)Preconditions.checkNotNull((Object)queryOperation);
    }

    public String getName() {
        return this.name;
    }

    public QueryOperation getQueryOperation() {
        return this.queryOperation;
    }

    public DataType getOutputDataType() {
        return this.queryOperation.getTableSchema().toRowDataType();
    }

    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    public String asSummaryString() {
        return this.name;
    }

    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public <R> R accept(ExpressionVisitor<R> visitor) {
        return (R)visitor.visit((Expression)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReferenceExpression that = (TableReferenceExpression)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.queryOperation, that.queryOperation);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.queryOperation);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

