/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class CatalogFunctionImpl
implements CatalogFunction {
    private final String className;
    private final Map<String, String> properties;

    public CatalogFunctionImpl(String className, Map<String, String> properties) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)className) ? 1 : 0) != 0, (Object)"className cannot be null or empty");
        this.className = className;
        this.properties = (Map)Preconditions.checkNotNull(properties, (String)"properties cannot be null");
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public CatalogFunction copy() {
        return new CatalogFunctionImpl(this.getClassName(), new HashMap<String, String>(this.getProperties()));
    }

    public Optional<String> getDescription() {
        return Optional.of("This is a user-defined function");
    }

    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a user-defined function");
    }

    public String toString() {
        return "CatalogFunctionImpl{, className='" + this.getClassName() + '\'' + ", properties=" + this.getProperties() + '}';
    }
}

