/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
final class ResolveCallByArgumentsRule
implements ResolverRule {
    ResolveCallByArgumentsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().flatMap(expr -> ((List)expr.accept((ExpressionVisitor)new ResolvingCallVisitor(context))).stream()).collect(Collectors.toList());
    }

    private class TableApiCallContext
    implements CallContext {
        private final String name;
        private final FunctionDefinition definition;
        private final List<ResolvedExpression> resolvedArgs;

        public TableApiCallContext(String name, FunctionDefinition definition, List<ResolvedExpression> resolvedArgs) {
            this.name = name;
            this.definition = definition;
            this.resolvedArgs = resolvedArgs;
        }

        public List<DataType> getArgumentDataTypes() {
            return this.resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.definition;
        }

        public boolean isArgumentLiteral(int pos) {
            return this.getArgument(pos) instanceof ValueLiteralExpression;
        }

        public boolean isArgumentNull(int pos) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.isNull();
        }

        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.getValueAs(clazz);
        }

        public String getName() {
            return this.name;
        }

        private ResolvedExpression getArgument(int pos) {
            if (pos >= this.resolvedArgs.size()) {
                throw new IndexOutOfBoundsException(String.format("Not enough arguments to access literal at position %d for function '%s'.", pos, this.name));
            }
            return this.resolvedArgs.get(pos);
        }
    }

    private class ResolvingCallVisitor
    extends RuleExpressionVisitor<List<ResolvedExpression>> {
        ResolvingCallVisitor(ResolverRule.ResolutionContext context) {
            super(context);
        }

        @Override
        public List<ResolvedExpression> visit(UnresolvedCallExpression unresolvedCall) {
            BuiltInFunctionDefinition definition;
            List<ResolvedExpression> resolvedArgs = unresolvedCall.getChildren().stream().flatMap(c -> ((List)c.accept((ExpressionVisitor)this)).stream()).collect(Collectors.toList());
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.FLATTEN) {
                return this.executeFlatten(resolvedArgs);
            }
            if (unresolvedCall.getFunctionDefinition() instanceof BuiltInFunctionDefinition && (definition = (BuiltInFunctionDefinition)unresolvedCall.getFunctionDefinition()).getTypeInference().getOutputTypeStrategy() != TypeStrategies.MISSING) {
                return Collections.singletonList(this.runTypeInference(unresolvedCall, definition.getTypeInference(), resolvedArgs));
            }
            return Collections.singletonList(this.runLegacyTypeInference(unresolvedCall, resolvedArgs));
        }

        @Override
        protected List<ResolvedExpression> defaultMethod(Expression expression) {
            if (expression instanceof ResolvedExpression) {
                return Collections.singletonList((ResolvedExpression)expression);
            }
            throw new TableException("Unexpected unresolved expression: " + expression);
        }

        private List<ResolvedExpression> executeFlatten(List<ResolvedExpression> args) {
            if (args.size() != 1) {
                throw new ValidationException("Invalid number of arguments for flattening.");
            }
            ResolvedExpression composite = args.get(0);
            TypeInformation resultType = TypeConversions.fromDataTypeToLegacyInfo((DataType)composite.getOutputDataType());
            if (resultType instanceof CompositeType) {
                return this.flattenCompositeType(composite, (CompositeType)resultType);
            }
            return Collections.singletonList(composite);
        }

        private List<ResolvedExpression> flattenCompositeType(ResolvedExpression composite, CompositeType<?> resultType) {
            return IntStream.range(0, resultType.getArity()).mapToObj(idx -> this.resolutionContext.postResolutionFactory().get(composite, ApiExpressionUtils.valueLiteral(resultType.getFieldNames()[idx]), TypeConversions.fromLegacyInfoToDataType((TypeInformation)resultType.getTypeAt(idx)))).collect(Collectors.toList());
        }

        private ResolvedExpression runTypeInference(UnresolvedCallExpression unresolvedCall, TypeInference inference, List<ResolvedExpression> resolvedArgs) {
            String name = unresolvedCall.getObjectIdentifier().map(ObjectIdentifier::toString).orElseGet(() -> unresolvedCall.getFunctionDefinition().toString());
            TypeInferenceUtil.Result inferenceResult = TypeInferenceUtil.runTypeInference((TypeInference)inference, (CallContext)new TableApiCallContext(name, unresolvedCall.getFunctionDefinition(), resolvedArgs));
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private ResolvedExpression runLegacyTypeInference(UnresolvedCallExpression unresolvedCall, List<ResolvedExpression> resolvedArgs) {
            PlannerTypeInferenceUtil util = this.resolutionContext.functionLookup().getPlannerTypeInferenceUtil();
            TypeInferenceUtil.Result inferenceResult = util.runTypeInference(unresolvedCall, resolvedArgs);
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private List<ResolvedExpression> adaptArguments(TypeInferenceUtil.Result inferenceResult, List<ResolvedExpression> resolvedArgs) {
            return IntStream.range(0, resolvedArgs.size()).mapToObj(pos -> {
                DataType expectedType;
                ResolvedExpression argument = (ResolvedExpression)resolvedArgs.get(pos);
                DataType argumentType = argument.getOutputDataType();
                if (!argumentType.equals((Object)(expectedType = (DataType)inferenceResult.getExpectedArgumentTypes().get(pos)))) {
                    return this.resolutionContext.postResolutionFactory().cast(argument, expectedType);
                }
                return argument;
            }).collect(Collectors.toList());
        }
    }
}

