/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.calcite.shaded.com.google.common.base.Supplier;
import org.apache.flink.calcite.shaded.com.google.common.base.Suppliers;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcCatalogSchema
extends AbstractSchema {
    final DataSource dataSource;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    final String catalog;
    final Supplier<SubSchemaMap> subSchemaMapSupplier = Suppliers.memoize(() -> this.computeSubSchemaMap());

    public JdbcCatalogSchema(DataSource dataSource, SqlDialect dialect, JdbcConvention convention, String catalog) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.dialect = Objects.requireNonNull(dialect, "dialect");
        this.convention = Objects.requireNonNull(convention, "convention");
        this.catalog = catalog;
    }

    public static JdbcCatalogSchema create(@Nullable SchemaPlus parentSchema, String name, DataSource dataSource, String catalog) {
        return JdbcCatalogSchema.create(parentSchema, name, dataSource, SqlDialectFactoryImpl.INSTANCE, catalog);
    }

    public static JdbcCatalogSchema create(@Nullable SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialectFactory dialectFactory, String catalog) {
        Expression expression = parentSchema != null ? Schemas.subSchemaExpression(parentSchema, name, JdbcCatalogSchema.class) : Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, new Expression[0]);
        SqlDialect dialect = JdbcSchema.createDialect(dialectFactory, dataSource);
        JdbcConvention convention = JdbcConvention.of(dialect, expression, name);
        return new JdbcCatalogSchema(dataSource, dialect, convention, catalog);
    }

    private SubSchemaMap computeSubSchemaMap() {
        String defaultSchemaName;
        ImmutableMap.Builder<String, JdbcSchema> builder = ImmutableMap.builder();
        try (Connection connection = this.dataSource.getConnection();
             ResultSet resultSet = connection.getMetaData().getSchemas(this.catalog, null);){
            defaultSchemaName = connection.getSchema();
            while (resultSet.next()) {
                String schemaName = Objects.requireNonNull(resultSet.getString(1), () -> "got null schemaName from the database");
                builder.put(schemaName, new JdbcSchema(this.dataSource, this.dialect, this.convention, this.catalog, schemaName));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new SubSchemaMap(defaultSchemaName, builder.build());
    }

    @Override
    protected Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMapSupplier.get().map;
    }

    public String getDefaultSubSchemaName() {
        return this.subSchemaMapSupplier.get().defaultSchemaName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private static class SubSchemaMap {
        final String defaultSchemaName;
        final ImmutableMap<String, Schema> map;

        private SubSchemaMap(String defaultSchemaName, ImmutableMap<String, Schema> map) {
            this.defaultSchemaName = defaultSchemaName;
            this.map = map;
        }
    }
}

