/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public final class LogicalFilter
extends Filter {
    private final ImmutableSet<CorrelationId> variablesSet;

    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode child, RexNode condition, ImmutableSet<CorrelationId> variablesSet) {
        super(cluster, traitSet, hints, child, condition);
        this.variablesSet = Objects.requireNonNull(variablesSet, "variablesSet");
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition, ImmutableSet<CorrelationId> variablesSet) {
        this(cluster, traitSet, ImmutableList.of(), child, condition, variablesSet);
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        this(cluster, traitSet, child, condition, ImmutableSet.of());
    }

    @Deprecated
    public LogicalFilter(RelOptCluster cluster, RelNode child, RexNode condition) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), child, condition, ImmutableSet.of());
    }

    public LogicalFilter(RelInput input) {
        super(input);
        this.variablesSet = ImmutableSet.of();
    }

    public static LogicalFilter create(RelNode input, RexNode condition) {
        return LogicalFilter.create(input, condition, ImmutableSet.of());
    }

    public static LogicalFilter create(RelNode input, RexNode condition, ImmutableSet<CorrelationId> variablesSet) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.filter(mq, input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.filter(mq, input));
        return new LogicalFilter(cluster, traitSet, input, condition, variablesSet);
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return this.variablesSet;
    }

    @Override
    public LogicalFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalFilter(this.getCluster(), traitSet, this.hints, input, condition, this.variablesSet);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("variablesSet", this.variablesSet, !this.variablesSet.isEmpty());
    }

    @Override
    public boolean deepEquals(@Nullable Object obj) {
        return this.deepEquals0(obj) && this.variablesSet.equals(((LogicalFilter)obj).variablesSet);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(this.deepHashCode0(), this.variablesSet);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalFilter(this.getCluster(), this.traitSet, hintList, this.input, this.condition, this.variablesSet);
    }
}

