/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.calcite.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.calcite.shaded.com.google.common.primitives.Booleans;
import org.apache.flink.calcite.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProjectFilterTransposeRule", generator="Immutables")
final class ImmutableProjectFilterTransposeRule {
    private ImmutableProjectFilterTransposeRule() {
    }

    @CheckReturnValue
    @Generated(from="ProjectFilterTransposeRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements ProjectFilterTransposeRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @javax.annotation.Nullable
        private final @Nullable String description;
        private final PushProjector.ExprCondition preserveExprCondition;
        private final boolean wholeProject;
        private final boolean wholeFilter;
        private final RelRule.OperandTransform operandSupplier;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.preserveExprCondition = this.initShim.preserveExprCondition();
            this.wholeProject = this.initShim.isWholeProject();
            this.wholeFilter = this.initShim.isWholeFilter();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.preserveExprCondition != null) {
                this.initShim.withPreserveExprCondition(builder.preserveExprCondition);
            }
            if (builder.wholeProjectIsSet()) {
                this.initShim.withWholeProject(builder.wholeProject);
            }
            if (builder.wholeFilterIsSet()) {
                this.initShim.withWholeFilter(builder.wholeFilter);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.preserveExprCondition = this.initShim.preserveExprCondition();
            this.wholeProject = this.initShim.isWholeProject();
            this.wholeFilter = this.initShim.isWholeFilter();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @javax.annotation.Nullable @Nullable String description, PushProjector.ExprCondition preserveExprCondition, boolean wholeProject, boolean wholeFilter, RelRule.OperandTransform operandSupplier) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.preserveExprCondition = preserveExprCondition;
            this.wholeProject = wholeProject;
            this.wholeFilter = wholeFilter;
            this.operandSupplier = operandSupplier;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return ProjectFilterTransposeRule.Config.super.relBuilderFactory();
        }

        private PushProjector.ExprCondition preserveExprConditionInitialize() {
            return ProjectFilterTransposeRule.Config.super.preserveExprCondition();
        }

        private boolean isWholeProjectInitialize() {
            return ProjectFilterTransposeRule.Config.super.isWholeProject();
        }

        private boolean isWholeFilterInitialize() {
            return ProjectFilterTransposeRule.Config.super.isWholeFilter();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return ProjectFilterTransposeRule.Config.super.operandSupplier();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @javax.annotation.Nullable
        public @Nullable String description() {
            return this.description;
        }

        @Override
        public PushProjector.ExprCondition preserveExprCondition() {
            InitShim shim = this.initShim;
            return shim != null ? shim.preserveExprCondition() : this.preserveExprCondition;
        }

        @Override
        public boolean isWholeProject() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isWholeProject() : this.wholeProject;
        }

        @Override
        public boolean isWholeFilter() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isWholeFilter() : this.wholeFilter;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.preserveExprCondition, this.wholeProject, this.wholeFilter, this.operandSupplier));
        }

        @Override
        public final Config withDescription(@javax.annotation.Nullable @Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.preserveExprCondition, this.wholeProject, this.wholeFilter, this.operandSupplier));
        }

        @Override
        public final Config withPreserveExprCondition(PushProjector.ExprCondition value) {
            if (this.preserveExprCondition == value) {
                return this;
            }
            PushProjector.ExprCondition newValue = Objects.requireNonNull(value, "preserveExprCondition");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.wholeProject, this.wholeFilter, this.operandSupplier));
        }

        @Override
        public final Config withWholeProject(boolean value) {
            if (this.wholeProject == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.preserveExprCondition, value, this.wholeFilter, this.operandSupplier));
        }

        @Override
        public final Config withWholeFilter(boolean value) {
            if (this.wholeFilter == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.preserveExprCondition, this.wholeProject, value, this.operandSupplier));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.preserveExprCondition, this.wholeProject, this.wholeFilter, newValue));
        }

        public boolean equals(@javax.annotation.Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.preserveExprCondition.equals(another.preserveExprCondition) && this.wholeProject == another.wholeProject && this.wholeFilter == another.wholeFilter && this.operandSupplier.equals(another.operandSupplier);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.preserveExprCondition.hashCode();
            h2 += (h2 << 5) + Booleans.hashCode(this.wholeProject);
            h2 += (h2 << 5) + Booleans.hashCode(this.wholeFilter);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("preserveExprCondition", this.preserveExprCondition).add("wholeProject", this.wholeProject).add("wholeFilter", this.wholeFilter).add("operandSupplier", this.operandSupplier).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(ProjectFilterTransposeRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="ProjectFilterTransposeRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_WHOLE_PROJECT = 1L;
            private static final long OPT_BIT_WHOLE_FILTER = 2L;
            private long optBits;
            @javax.annotation.Nullable
            private RelBuilderFactory relBuilderFactory;
            @javax.annotation.Nullable
            private @Nullable String description;
            @javax.annotation.Nullable
            private PushProjector.ExprCondition preserveExprCondition;
            private boolean wholeProject;
            private boolean wholeFilter;
            @javax.annotation.Nullable
            private RelRule.OperandTransform operandSupplier;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ProjectFilterTransposeRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                long bits = 0L;
                if (object instanceof RelRule.Config) {
                    String descriptionValue;
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    if ((bits & 1L) == 0L) {
                        this.withOperandSupplier(instance.operandSupplier());
                        bits |= 1L;
                    }
                    if ((descriptionValue = instance.description()) != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof ProjectFilterTransposeRule.Config) {
                    instance = (ProjectFilterTransposeRule.Config)object;
                    this.withWholeProject(instance.isWholeProject());
                    this.withWholeFilter(instance.isWholeFilter());
                    this.withPreserveExprCondition(instance.preserveExprCondition());
                    if ((bits & 1L) == 0L) {
                        this.withOperandSupplier(instance.operandSupplier());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@javax.annotation.Nullable @Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withPreserveExprCondition(PushProjector.ExprCondition preserveExprCondition) {
                this.preserveExprCondition = Objects.requireNonNull(preserveExprCondition, "preserveExprCondition");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withWholeProject(boolean wholeProject) {
                this.wholeProject = wholeProject;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withWholeFilter(boolean wholeFilter) {
                this.wholeFilter = wholeFilter;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean wholeProjectIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean wholeFilterIsSet() {
                return (this.optBits & 2L) != 0L;
            }
        }

        @Generated(from="ProjectFilterTransposeRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte preserveExprConditionBuildStage = 0;
            private PushProjector.ExprCondition preserveExprCondition;
            private byte wholeProjectBuildStage = 0;
            private boolean wholeProject;
            private byte wholeFilterBuildStage = 0;
            private boolean wholeFilter;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            PushProjector.ExprCondition preserveExprCondition() {
                if (this.preserveExprConditionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.preserveExprConditionBuildStage == 0) {
                    this.preserveExprConditionBuildStage = (byte)-1;
                    this.preserveExprCondition = Objects.requireNonNull(Config.this.preserveExprConditionInitialize(), "preserveExprCondition");
                    this.preserveExprConditionBuildStage = 1;
                }
                return this.preserveExprCondition;
            }

            void withPreserveExprCondition(PushProjector.ExprCondition preserveExprCondition) {
                this.preserveExprCondition = preserveExprCondition;
                this.preserveExprConditionBuildStage = 1;
            }

            boolean isWholeProject() {
                if (this.wholeProjectBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.wholeProjectBuildStage == 0) {
                    this.wholeProjectBuildStage = (byte)-1;
                    this.wholeProject = Config.this.isWholeProjectInitialize();
                    this.wholeProjectBuildStage = 1;
                }
                return this.wholeProject;
            }

            void withWholeProject(boolean wholeProject) {
                this.wholeProject = wholeProject;
                this.wholeProjectBuildStage = 1;
            }

            boolean isWholeFilter() {
                if (this.wholeFilterBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.wholeFilterBuildStage == 0) {
                    this.wholeFilterBuildStage = (byte)-1;
                    this.wholeFilter = Config.this.isWholeFilterInitialize();
                    this.wholeFilterBuildStage = 1;
                }
                return this.wholeFilter;
            }

            void withWholeFilter(boolean wholeFilter) {
                this.wholeFilter = wholeFilter;
                this.wholeFilterBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.preserveExprConditionBuildStage == -1) {
                    attributes.add("preserveExprCondition");
                }
                if (this.wholeProjectBuildStage == -1) {
                    attributes.add("wholeProject");
                }
                if (this.wholeFilterBuildStage == -1) {
                    attributes.add("wholeFilter");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

