/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.Symbolizable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlHint
extends SqlCall {
    private final SqlIdentifier name;
    private final SqlNodeList options;
    private final HintOptionFormat optionFormat;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("HINT", SqlKind.HINT){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlHint(pos, (SqlIdentifier)Objects.requireNonNull(operands[0], "name"), (SqlNodeList)Objects.requireNonNull(operands[1], "options"), ((SqlLiteral)Objects.requireNonNull(operands[2], "optionFormat")).getValueAs(HintOptionFormat.class));
        }
    };

    public SqlHint(SqlParserPos pos, SqlIdentifier name, SqlNodeList options, HintOptionFormat optionFormat) {
        super(pos);
        this.name = name;
        this.optionFormat = optionFormat;
        this.options = options;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.options, this.optionFormat.symbol(SqlParserPos.ZERO));
    }

    public String getName() {
        return this.name.getSimple();
    }

    public HintOptionFormat getOptionFormat() {
        return this.optionFormat;
    }

    public List<String> getOptionList() {
        if (this.optionFormat == HintOptionFormat.ID_LIST) {
            return ImmutableList.copyOf(SqlIdentifier.simpleNames(this.options));
        }
        if (this.optionFormat == HintOptionFormat.LITERAL_LIST) {
            return this.options.stream().map(node -> {
                SqlLiteral literal = (SqlLiteral)node;
                return Objects.requireNonNull(literal.toValue(), () -> "null hint literal in " + this.options);
            }).collect(Util.toImmutableList());
        }
        return ImmutableList.of();
    }

    public Map<String, String> getOptionKVPairs() {
        if (this.optionFormat == HintOptionFormat.KV_LIST) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            for (int i = 0; i < this.options.size() - 1; i += 2) {
                SqlNode k = this.options.get(i);
                SqlNode v = this.options.get(i + 1);
                attrs.put(SqlHint.getOptionKeyAsString(k), ((SqlLiteral)v).getValueAs(String.class));
            }
            return ImmutableMap.copyOf(attrs);
        }
        return ImmutableMap.of();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            for (int i = 0; i < this.options.size(); ++i) {
                SqlNode option = this.options.get(i);
                SqlNode nextOption = i < this.options.size() - 1 ? this.options.get(i + 1) : null;
                writer.sep(",", false);
                option.unparse(writer, leftPrec, rightPrec);
                if (this.optionFormat != HintOptionFormat.KV_LIST || nextOption == null) continue;
                writer.keyword("=");
                nextOption.unparse(writer, leftPrec, rightPrec);
                ++i;
            }
            writer.endList(frame);
        }
    }

    private static String getOptionKeyAsString(SqlNode node) {
        assert (node instanceof SqlIdentifier || SqlUtil.isLiteral(node));
        if (node instanceof SqlIdentifier) {
            return ((SqlIdentifier)node).getSimple();
        }
        return ((SqlLiteral)node).getValueAs(String.class);
    }

    public static enum HintOptionFormat implements Symbolizable
    {
        EMPTY,
        LITERAL_LIST,
        ID_LIST,
        KV_LIST;

    }
}

