/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeMappingRules;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.NumberUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apiguardian.api.API;

public abstract class SqlTypeUtil {
    public static boolean isCharTypeComparable(List<RelDataType> argTypes) {
        assert (argTypes != null);
        assert (argTypes.size() >= 2);
        ArrayList<RelDataType> argTypes2 = new ArrayList<RelDataType>();
        for (RelDataType relDataType : argTypes) {
            if (SqlTypeUtil.isAny(relDataType) || SqlTypeUtil.isNull(relDataType)) continue;
            argTypes2.add(relDataType);
        }
        for (Pair pair : Pair.adjacents(argTypes2)) {
            RelDataType t0 = (RelDataType)pair.left;
            RelDataType t1 = (RelDataType)pair.right;
            if (!SqlTypeUtil.inCharFamily(t0) || !SqlTypeUtil.inCharFamily(t1)) {
                return false;
            }
            if (!NonNullableAccessors.getCharset(t0).equals(NonNullableAccessors.getCharset(t1))) {
                return false;
            }
            if (NonNullableAccessors.getCollation(t0).getCharset().equals(NonNullableAccessors.getCollation(t1).getCharset())) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharTypeComparable(SqlCallBinding binding, List<SqlNode> operands, boolean throwOnFailure) {
        Objects.requireNonNull(operands, "operands");
        assert (operands.size() >= 2) : "operands.size() should be 2 or greater, actual: " + operands.size();
        if (!SqlTypeUtil.isCharTypeComparable(SqlTypeUtil.deriveType(binding, operands))) {
            if (throwOnFailure) {
                String msg = String.join((CharSequence)", ", Util.transform(operands, String::valueOf));
                throw binding.newError(Static.RESOURCE.operandNotComparable(msg));
            }
            return false;
        }
        return true;
    }

    public static List<RelDataType> deriveAndCollectTypes(SqlValidator validator, SqlValidatorScope scope, List<? extends SqlNode> operands) {
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (SqlNode sqlNode : operands) {
            types.add(validator.deriveType(scope, sqlNode));
        }
        return types;
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static RelDataType deriveType(SqlCallBinding binding) {
        return SqlTypeUtil.deriveType(binding, binding.getCall());
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static RelDataType deriveType(SqlCallBinding binding, SqlNode node) {
        return binding.getValidator().deriveType(Objects.requireNonNull(binding.getScope(), () -> "scope of " + binding), node);
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    public static List<RelDataType> deriveType(SqlCallBinding binding, List<? extends SqlNode> nodes) {
        return SqlTypeUtil.deriveAndCollectTypes(binding.getValidator(), Objects.requireNonNull(binding.getScope(), () -> "scope of " + binding), nodes);
    }

    public static RelDataType promoteToRowType(RelDataTypeFactory typeFactory, RelDataType type, @Nullable String fieldName) {
        if (!type.isStruct()) {
            if (fieldName == null) {
                fieldName = "ROW_VALUE";
            }
            type = typeFactory.builder().add(fieldName, type).build();
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(SqlValidator validator, SqlValidatorScope scope, SqlCall call, RelDataType type) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType operandType = validator.deriveType(scope, operand);
            if (!SqlTypeUtil.containsNullable(operandType)) continue;
            RelDataTypeFactory typeFactory = validator.getTypeFactory();
            type = typeFactory.createTypeWithNullability(type, true);
            break;
        }
        return type;
    }

    public static RelDataType makeNullableIfOperandsAre(RelDataTypeFactory typeFactory, List<RelDataType> argTypes, RelDataType type) {
        Objects.requireNonNull(type, "type");
        if (SqlTypeUtil.containsNullable(argTypes)) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public static boolean allNullable(List<RelDataType> types) {
        for (RelDataType type : types) {
            if (SqlTypeUtil.containsNullable(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNullable(List<RelDataType> types) {
        for (RelDataType type : types) {
            if (!SqlTypeUtil.containsNullable(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNullable(RelDataType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.isStruct()) {
            return false;
        }
        for (RelDataTypeField field : type.getFieldList()) {
            if (!SqlTypeUtil.containsNullable(field.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOfSameTypeName(SqlTypeName typeName, RelDataType type) {
        return SqlTypeName.ANY == typeName || typeName == type.getSqlTypeName();
    }

    public static boolean isOfSameTypeName(Collection<SqlTypeName> typeNames, RelDataType type) {
        for (SqlTypeName typeName : typeNames) {
            if (!SqlTypeUtil.isOfSameTypeName(typeName, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatetime(RelDataType type) {
        return SqlTypeFamily.DATETIME.contains(type);
    }

    public static boolean isDate(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.DATE;
    }

    public static boolean isTimestamp(RelDataType type) {
        return SqlTypeFamily.TIMESTAMP.contains(type);
    }

    @EnsuresNonNullIf(expression={"#1.getIntervalQualifier()"}, result=true)
    public static boolean isInterval(RelDataType type) {
        return SqlTypeFamily.DATETIME_INTERVAL.contains(type);
    }

    @EnsuresNonNullIf.List(value={@EnsuresNonNullIf(expression={"#1.getCharset()"}, result=true), @EnsuresNonNullIf(expression={"#1.getCollation()"}, result=true)})
    public static boolean inCharFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inCharFamily(SqlTypeName typeName) {
        return typeName.getFamily() == SqlTypeFamily.CHARACTER;
    }

    public static boolean inBooleanFamily(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.BOOLEAN;
    }

    public static boolean inSameFamily(RelDataType t1, RelDataType t2) {
        return t1.getFamily() == t2.getFamily();
    }

    public static boolean inSameFamilyOrNull(RelDataType t1, RelDataType t2) {
        return t1.getSqlTypeName() == SqlTypeName.NULL || t2.getSqlTypeName() == SqlTypeName.NULL || t1.getFamily() == t2.getFamily();
    }

    public static boolean inCharOrBinaryFamilies(RelDataType type) {
        return type.getFamily() == SqlTypeFamily.CHARACTER || type.getFamily() == SqlTypeFamily.BINARY;
    }

    public static boolean isLob(RelDataType type) {
        return false;
    }

    public static boolean isBoundedVariableWidth(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case VARCHAR: 
            case VARBINARY: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntType(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimal(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.DECIMAL;
    }

    public static boolean isDouble(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.DOUBLE;
    }

    public static boolean isBigint(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.BIGINT;
    }

    public static boolean isExactNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasScale(RelDataType type) {
        return type.getScale() != Integer.MIN_VALUE;
    }

    public static long maxValue(RelDataType type) {
        assert (SqlTypeUtil.isIntType(type));
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                return 127L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: {
                return Long.MAX_VALUE;
            }
        }
        throw Util.unexpected(type.getSqlTypeName());
    }

    public static boolean isApproximateNumeric(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(RelDataType type) {
        return SqlTypeUtil.isExactNumeric(type) || SqlTypeUtil.isApproximateNumeric(type);
    }

    public static boolean isNull(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return typeName == SqlTypeName.NULL;
    }

    public static boolean sameNamedType(RelDataType t1, RelDataType t2) {
        if (t1.isStruct() || t2.isStruct()) {
            if (!t1.isStruct() || !t2.isStruct()) {
                return false;
            }
            if (t1.getFieldCount() != t2.getFieldCount()) {
                return false;
            }
            List<RelDataTypeField> fields1 = t1.getFieldList();
            List<RelDataTypeField> fields2 = t2.getFieldList();
            for (int i = 0; i < fields1.size(); ++i) {
                if (SqlTypeUtil.sameNamedType(fields1.get(i).getType(), fields2.get(i).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataType comp1 = t1.getComponentType();
        RelDataType comp2 = t2.getComponentType();
        if (comp1 != null || comp2 != null) {
            if (comp1 == null || comp2 == null) {
                return false;
            }
            if (!SqlTypeUtil.sameNamedType(comp1, comp2)) {
                return false;
            }
        }
        return t1.getSqlTypeName() == t2.getSqlTypeName();
    }

    public static int getMaxByteSize(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return 0;
        }
        switch (typeName) {
            case VARCHAR: 
            case CHAR: {
                return (int)Math.ceil((double)type.getPrecision() * (double)NonNullableAccessors.getCharset(type).newEncoder().maxBytesPerChar());
            }
            case VARBINARY: 
            case BINARY: {
                return type.getPrecision();
            }
            case MULTISET: {
                return 4096;
            }
        }
        return 0;
    }

    public static long getMinValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case TINYINT: {
                return -128L;
            }
            case SMALLINT: {
                return -32768L;
            }
            case INTEGER: {
                return Integer.MIN_VALUE;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMinUnscaled(type.getPrecision()).longValue();
            }
        }
        throw new AssertionError((Object)("getMinValue(" + (Object)((Object)typeName) + ")"));
    }

    public static long getMaxValue(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        switch (typeName) {
            case TINYINT: {
                return 127L;
            }
            case SMALLINT: {
                return 32767L;
            }
            case INTEGER: {
                return Integer.MAX_VALUE;
            }
            case BIGINT: 
            case DECIMAL: {
                return NumberUtil.getMaxUnscaled(type.getPrecision()).longValue();
            }
        }
        throw new AssertionError((Object)("getMaxValue(" + (Object)((Object)typeName) + ")"));
    }

    @Deprecated
    public static boolean isJavaPrimitive(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case BOOLEAN: 
            case SYMBOL: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static @Nullable String getPrimitiveWrapperJavaClassName(@Nullable RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case BOOLEAN: {
                return "Boolean";
            }
        }
        return SqlTypeUtil.getNumericJavaClassName(type);
    }

    @Deprecated
    public static @Nullable String getNumericJavaClassName(@Nullable RelDataType type) {
        if (type == null) {
            return null;
        }
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return null;
        }
        switch (typeName) {
            case TINYINT: {
                return "Byte";
            }
            case SMALLINT: {
                return "Short";
            }
            case INTEGER: {
                return "Integer";
            }
            case BIGINT: {
                return "Long";
            }
            case REAL: {
                return "Float";
            }
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                return "Double";
            }
        }
        return null;
    }

    private static boolean isAny(RelDataType t) {
        return t.getFamily() == SqlTypeFamily.ANY;
    }

    public static boolean canAssignFrom(RelDataType toType, RelDataType fromType) {
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType)) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.NULL) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.ARRAY) {
            if (toType.getSqlTypeName() != SqlTypeName.ARRAY) {
                return false;
            }
            return SqlTypeUtil.canAssignFrom(NonNullableAccessors.getComponentTypeOrThrow(toType), NonNullableAccessors.getComponentTypeOrThrow(fromType));
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(toType, fromType)) {
            return false;
        }
        return toType.getFamily() == fromType.getFamily();
    }

    public static boolean areCharacterSetsMismatched(RelDataType t1, RelDataType t2) {
        if (SqlTypeUtil.isAny(t1) || SqlTypeUtil.isAny(t2)) {
            return false;
        }
        Charset cs1 = t1.getCharset();
        Charset cs2 = t2.getCharset();
        return cs1 != null && cs2 != null && !cs1.equals(cs2);
    }

    public static boolean canCastFrom(RelDataType toType, RelDataType fromType, boolean coerce) {
        IntervalSqlType intervalType;
        if (toType.equals(fromType)) {
            return true;
        }
        if (SqlTypeUtil.isAny(toType) || SqlTypeUtil.isAny(fromType)) {
            return true;
        }
        SqlTypeName fromTypeName = fromType.getSqlTypeName();
        SqlTypeName toTypeName = toType.getSqlTypeName();
        if (toType.isStruct() || fromType.isStruct()) {
            if (toTypeName == SqlTypeName.DISTINCT) {
                if (fromTypeName == SqlTypeName.DISTINCT) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(toType.getFieldList().get(0).getType(), fromType, coerce);
            }
            if (fromTypeName == SqlTypeName.DISTINCT) {
                return SqlTypeUtil.canCastFrom(toType, fromType.getFieldList().get(0).getType(), coerce);
            }
            if (toTypeName == SqlTypeName.ROW) {
                if (fromTypeName != SqlTypeName.ROW) {
                    return fromTypeName == SqlTypeName.NULL;
                }
                int n = toType.getFieldCount();
                if (fromType.getFieldCount() != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    RelDataTypeField toField = toType.getFieldList().get(i);
                    RelDataTypeField fromField = fromType.getFieldList().get(i);
                    if (SqlTypeUtil.canCastFrom(toField.getType(), fromField.getType(), coerce)) continue;
                    return false;
                }
                return true;
            }
            if (toTypeName == SqlTypeName.MULTISET) {
                if (!fromType.isStruct()) {
                    return false;
                }
                if (fromTypeName != SqlTypeName.MULTISET) {
                    return false;
                }
                return SqlTypeUtil.canCastFrom(NonNullableAccessors.getComponentTypeOrThrow(toType), NonNullableAccessors.getComponentTypeOrThrow(fromType), coerce);
            }
            if (fromTypeName == SqlTypeName.MULTISET) {
                return false;
            }
            return toType.getFamily() == fromType.getFamily();
        }
        RelDataType c1 = toType.getComponentType();
        if (c1 != null) {
            RelDataType c2 = fromType.getComponentType();
            if (c2 == null) {
                return false;
            }
            return SqlTypeUtil.canCastFrom(c1, c2, coerce);
        }
        if ((SqlTypeUtil.isInterval(fromType) && SqlTypeUtil.isExactNumeric(toType) || SqlTypeUtil.isInterval(toType) && SqlTypeUtil.isExactNumeric(fromType)) && !(intervalType = (IntervalSqlType)(SqlTypeUtil.isInterval(fromType) ? fromType : toType)).getIntervalQualifier().isSingleDatetimeField()) {
            return false;
        }
        if (toTypeName == null || fromTypeName == null) {
            return false;
        }
        SqlTypeMappingRule rules = SqlTypeMappingRules.instance(coerce);
        return rules.canApplyFrom(toTypeName, fromTypeName);
    }

    public static RelDataType flattenRecordType(RelDataTypeFactory typeFactory, RelDataType recordType, int @Nullable [] flatteningMap) {
        if (!recordType.isStruct()) {
            return recordType;
        }
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        boolean nested = SqlTypeUtil.flattenFields(typeFactory, recordType, fieldList, flatteningMap);
        if (!nested) {
            return recordType;
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        Map fieldCnt = fieldList.stream().map(RelDataTypeField::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        int i = -1;
        for (RelDataTypeField field : fieldList) {
            types.add(field.getType());
            String oriFieldName = field.getName();
            Long fieldCount = fieldCnt.get(oriFieldName);
            String fieldName = fieldCount != null && fieldCount > 1L ? oriFieldName + "_" + ++i : oriFieldName;
            fieldNames.add(fieldName);
        }
        return typeFactory.createStructType(types, fieldNames);
    }

    public static boolean needsNullIndicator(RelDataType recordType) {
        return recordType.getSqlTypeName() == SqlTypeName.STRUCTURED;
    }

    private static boolean flattenFields(RelDataTypeFactory typeFactory, RelDataType type, List<RelDataTypeField> list, int @Nullable [] flatteningMap) {
        boolean nested = false;
        for (RelDataTypeField field : type.getFieldList()) {
            if (flatteningMap != null) {
                flatteningMap[field.getIndex()] = list.size();
            }
            if (field.getType().isStruct()) {
                nested = true;
                SqlTypeUtil.flattenFields(typeFactory, field.getType(), list, null);
                continue;
            }
            if (field.getType().getComponentType() != null) {
                nested = true;
                RelDataType flattenedCollectionType = typeFactory.createMultisetType(SqlTypeUtil.flattenRecordType(typeFactory, NonNullableAccessors.getComponentTypeOrThrow(field.getType()), null), -1L);
                if (field.getType() instanceof ArraySqlType) {
                    flattenedCollectionType = typeFactory.createArrayType(SqlTypeUtil.flattenRecordType(typeFactory, NonNullableAccessors.getComponentTypeOrThrow(field.getType()), null), -1L);
                }
                field = new RelDataTypeFieldImpl(field.getName(), field.getIndex(), flattenedCollectionType);
                list.add(field);
                continue;
            }
            list.add(field);
        }
        return nested;
    }

    public static SqlDataTypeSpec convertTypeToSpec(RelDataType type, @Nullable String charSetName, int maxPrecision, int maxScale) {
        SqlTypeNameSpec typeNameSpec;
        SqlTypeName typeName = type.getSqlTypeName();
        assert (typeName != null);
        if (SqlTypeUtil.isAtomic(type) || SqlTypeUtil.isNull(type)) {
            int scale;
            int precision;
            int n = precision = typeName.allowsPrec() ? type.getPrecision() : -1;
            if (maxPrecision > 0 && precision > maxPrecision) {
                precision = maxPrecision;
            }
            int n2 = scale = typeName.allowsScale() ? type.getScale() : -1;
            if (maxScale > 0 && scale > maxScale) {
                scale = maxScale;
            }
            typeNameSpec = new SqlBasicTypeNameSpec(typeName, precision, scale, charSetName, SqlParserPos.ZERO);
        } else if (SqlTypeUtil.isCollection(type)) {
            typeNameSpec = new SqlCollectionTypeNameSpec(SqlTypeUtil.convertTypeToSpec(NonNullableAccessors.getComponentTypeOrThrow(type)).getTypeNameSpec(), typeName, SqlParserPos.ZERO);
        } else if (SqlTypeUtil.isRow(type)) {
            RelRecordType recordType = (RelRecordType)type;
            List<RelDataTypeField> fields = recordType.getFieldList();
            List<SqlIdentifier> fieldNames = fields.stream().map(f -> new SqlIdentifier(f.getName(), SqlParserPos.ZERO)).collect(Collectors.toList());
            List<SqlDataTypeSpec> fieldTypes = fields.stream().map(f -> SqlTypeUtil.convertTypeToSpec(f.getType())).collect(Collectors.toList());
            typeNameSpec = new SqlRowTypeNameSpec(SqlParserPos.ZERO, fieldNames, fieldTypes);
        } else {
            throw new UnsupportedOperationException("Unsupported type when convertTypeToSpec: " + (Object)((Object)typeName));
        }
        return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
    }

    public static SqlDataTypeSpec convertTypeToSpec(RelDataType type) {
        String charSetName = SqlTypeUtil.inCharFamily(type) ? type.getCharset().name() : null;
        return SqlTypeUtil.convertTypeToSpec(type, charSetName, -1, -1);
    }

    public static RelDataType createMultisetType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createMultisetType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createArrayType(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        RelDataType ret = typeFactory.createArrayType(type, -1L);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createMapType(RelDataTypeFactory typeFactory, RelDataType keyType, RelDataType valueType, boolean nullable) {
        RelDataType ret = typeFactory.createMapType(keyType, valueType);
        return typeFactory.createTypeWithNullability(ret, nullable);
    }

    public static RelDataType createMapTypeFromRecord(RelDataTypeFactory typeFactory, RelDataType type) {
        Preconditions.checkArgument(type.getFieldCount() == 2, "MAP requires exactly two fields, got %s; row type %s", type.getFieldCount(), (Object)type);
        return SqlTypeUtil.createMapType(typeFactory, type.getFieldList().get(0).getType(), type.getFieldList().get(1).getType(), false);
    }

    public static RelDataType addCharsetAndCollation(RelDataType type, RelDataTypeFactory typeFactory) {
        SqlCollation collation;
        if (!SqlTypeUtil.inCharFamily(type)) {
            return type;
        }
        Charset charset = type.getCharset();
        if (charset == null) {
            charset = typeFactory.getDefaultCharset();
        }
        if ((collation = type.getCollation()) == null) {
            collation = SqlCollation.IMPLICIT;
        }
        type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    public static boolean equalSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        if (type1.isNullable() == type2.isNullable()) {
            return type1.equals(type2);
        }
        return type1.equals(factory.createTypeWithNullability(type2, type1.isNullable()));
    }

    public static boolean equalSansNullability(RelDataType type1, RelDataType type2) {
        if (type1 == type2) {
            return true;
        }
        String x = type1.getFullTypeString();
        String y = type2.getFullTypeString();
        if (x.length() < y.length()) {
            String c = x;
            x = y;
            y = c;
        }
        return (x.length() == y.length() || x.length() == y.length() + " NOT NULL".length() && x.endsWith(" NOT NULL")) && x.startsWith(y);
    }

    public static boolean equalAsCollectionSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        Preconditions.checkArgument(SqlTypeUtil.isCollection(type1), "Input type1 must be collection type");
        Preconditions.checkArgument(SqlTypeUtil.isCollection(type2), "Input type2 must be collection type");
        return type1 == type2 || type1.getSqlTypeName() == type2.getSqlTypeName() && SqlTypeUtil.equalSansNullability(factory, NonNullableAccessors.getComponentTypeOrThrow(type1), NonNullableAccessors.getComponentTypeOrThrow(type2));
    }

    public static boolean equalAsMapSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2) {
        Preconditions.checkArgument(SqlTypeUtil.isMap(type1), "Input type1 must be map type");
        Preconditions.checkArgument(SqlTypeUtil.isMap(type2), "Input type2 must be map type");
        MapSqlType mType1 = (MapSqlType)type1;
        MapSqlType mType2 = (MapSqlType)type2;
        return type1 == type2 || SqlTypeUtil.equalSansNullability(factory, mType1.getKeyType(), mType2.getKeyType()) && SqlTypeUtil.equalSansNullability(factory, mType1.getValueType(), mType2.getValueType());
    }

    public static boolean equalAsStructSansNullability(RelDataTypeFactory factory, RelDataType type1, RelDataType type2, @Nullable SqlNameMatcher nameMatcher) {
        Preconditions.checkArgument(type1.isStruct(), "Input type1 must be struct type");
        Preconditions.checkArgument(type2.isStruct(), "Input type2 must be struct type");
        if (type1 == type2) {
            return true;
        }
        if (type1.getFieldCount() != type2.getFieldCount()) {
            return false;
        }
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
            if (nameMatcher != null && !nameMatcher.matches(((RelDataTypeField)pair.left).getName(), ((RelDataTypeField)pair.right).getName())) {
                return false;
            }
            if (SqlTypeUtil.equalSansNullability(factory, ((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
            return false;
        }
        return true;
    }

    public static int findField(RelDataType type, String fieldName) {
        List<RelDataTypeField> fields = type.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            RelDataTypeField field = fields.get(i);
            if (field.getName().equals(fieldName)) {
                return i;
            }
            RelDataType fieldType = field.getType();
            if (!fieldType.isStruct() || SqlTypeUtil.findField(fieldType, fieldName) == -1) continue;
            return i;
        }
        return -1;
    }

    public static List<RelDataType> projectTypes(RelDataType rowType, final List<? extends Number> requiredFields) {
        final List<RelDataTypeField> fields = rowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RelDataTypeField)fields.get(((Number)requiredFields.get(index)).intValue())).getType();
            }

            @Override
            public int size() {
                return requiredFields.size();
            }
        };
    }

    public static RelDataType createEmptyStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType(ImmutableList.of(), ImmutableList.of());
    }

    public static boolean isFlat(RelDataType type) {
        if (type.isStruct()) {
            for (RelDataTypeField field : type.getFieldList()) {
                if (!field.getType().isStruct()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isComparable(RelDataType type1, RelDataType type2) {
        RelDataTypeFamily family2;
        if (type1.isStruct() != type2.isStruct()) {
            return false;
        }
        if (type1.isStruct()) {
            int n = type1.getFieldCount();
            if (n != type2.getFieldCount()) {
                return false;
            }
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                if (SqlTypeUtil.isComparable(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        if (family1 == (family2 = SqlTypeUtil.family(type2))) {
            return true;
        }
        if (family1 == SqlTypeFamily.ANY || family2 == SqlTypeFamily.ANY) {
            return true;
        }
        if (family1 == SqlTypeFamily.NULL || family2 == SqlTypeFamily.NULL) {
            return true;
        }
        return family1 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family2) || family2 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family1);
    }

    public static @Nullable RelDataType leastRestrictiveForComparison(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        RelDataType type = typeFactory.leastRestrictive(ImmutableList.of(type1, type2));
        if (type != null) {
            return type;
        }
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        RelDataTypeFamily family2 = SqlTypeUtil.family(type2);
        if (family1 == SqlTypeFamily.ANY) {
            return type2;
        }
        if (family2 == SqlTypeFamily.ANY) {
            return type1;
        }
        if (family1 == SqlTypeFamily.NULL) {
            return type2;
        }
        if (family2 == SqlTypeFamily.NULL) {
            return type1;
        }
        if (family1 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family2)) {
            return type2;
        }
        if (family2 == SqlTypeFamily.CHARACTER && SqlTypeUtil.canConvertStringInCompare(family1)) {
            return type1;
        }
        return null;
    }

    protected static RelDataTypeFamily family(RelDataType type) {
        RelDataTypeFamily family = null;
        if (type.getSqlTypeName() != null) {
            family = type.getSqlTypeName().getFamily();
        }
        if (family == null) {
            family = type.getFamily();
        }
        return family;
    }

    public static boolean areSameFamily(Iterable<RelDataType> types) {
        ImmutableList<RelDataType> typeList = ImmutableList.copyOf(types);
        if (Sets.newHashSet(RexUtil.families(typeList)).size() < 2) {
            return true;
        }
        for (Pair<RelDataType, RelDataType> adjacent : Pair.adjacents(typeList)) {
            if (SqlTypeUtil.isSameFamily((RelDataType)adjacent.left, (RelDataType)adjacent.right)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameFamily(RelDataType type1, RelDataType type2) {
        RelDataTypeFamily family2;
        if (type1.isStruct() != type2.isStruct()) {
            return false;
        }
        if (type1.isStruct()) {
            int n = type1.getFieldCount();
            if (n != type2.getFieldCount()) {
                return false;
            }
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                if (SqlTypeUtil.isSameFamily(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                return false;
            }
            return true;
        }
        RelDataTypeFamily family1 = SqlTypeUtil.family(type1);
        return family1 == (family2 = SqlTypeUtil.family(type2));
    }

    private static boolean canConvertStringInCompare(RelDataTypeFamily family) {
        if (family instanceof SqlTypeFamily) {
            SqlTypeFamily sqlTypeFamily = (SqlTypeFamily)family;
            switch (sqlTypeFamily) {
                case DATE: 
                case TIME: 
                case TIMESTAMP: 
                case INTERVAL_DAY_TIME: 
                case INTERVAL_YEAR_MONTH: 
                case NUMERIC: 
                case APPROXIMATE_NUMERIC: 
                case EXACT_NUMERIC: 
                case INTEGER: 
                case BOOLEAN: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isUnicode(RelDataType type) {
        Charset charset = type.getCharset();
        if (charset == null) {
            return false;
        }
        return charset.name().startsWith("UTF");
    }

    public static int maxPrecision(int p0, int p1) {
        return p0 == -1 || p0 >= p1 && p1 != -1 ? p0 : p1;
    }

    public static int comparePrecision(int p0, int p1) {
        if (p0 == p1) {
            return 0;
        }
        if (p0 == -1) {
            return 1;
        }
        if (p1 == -1) {
            return -1;
        }
        return Integer.compare(p0, p1);
    }

    public static boolean isArray(RelDataType type) {
        return type.getSqlTypeName() == SqlTypeName.ARRAY;
    }

    public static boolean isRow(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.ROW;
    }

    public static boolean isMap(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.MAP;
    }

    public static boolean isMultiset(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static boolean isCollection(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return type.getSqlTypeName() == SqlTypeName.ARRAY || type.getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static boolean isCharacter(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.CHARACTER.contains(type);
    }

    @Deprecated
    public static boolean hasCharactor(RelDataType type) {
        return SqlTypeUtil.hasCharacter(type);
    }

    public static boolean hasCharacter(RelDataType type) {
        if (SqlTypeUtil.isCharacter(type)) {
            return true;
        }
        if (SqlTypeUtil.isArray(type)) {
            return SqlTypeUtil.hasCharacter(NonNullableAccessors.getComponentTypeOrThrow(type));
        }
        return false;
    }

    public static boolean isString(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.STRING.contains(type);
    }

    public static boolean isBoolean(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.BOOLEAN.contains(type);
    }

    public static boolean isBinary(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeFamily.BINARY.contains(type);
    }

    public static boolean isAtomic(RelDataType type) {
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName == null) {
            return false;
        }
        return SqlTypeUtil.isDatetime(type) || SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isString(type) || SqlTypeUtil.isBoolean(type);
    }

    public static RelDataType getMaxPrecisionScaleDecimal(RelDataTypeFactory factory) {
        int maxPrecision = factory.getTypeSystem().getMaxNumericPrecision();
        int scale = maxPrecision / 2;
        return factory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, scale);
    }

    public static RelDataType extractLastNFields(RelDataTypeFactory typeFactory, RelDataType type, int numToKeep) {
        assert (type.isStruct());
        assert (type.getFieldCount() >= numToKeep);
        int fieldsCnt = type.getFieldCount();
        return typeFactory.createStructType(type.getFieldList().subList(fieldsCnt - numToKeep, fieldsCnt));
    }

    public static boolean isValidDecimalValue(@Nullable BigDecimal value, RelDataType toType) {
        if (value == null) {
            return true;
        }
        switch (toType.getSqlTypeName()) {
            case DECIMAL: {
                int intDigits = value.precision() - value.scale();
                int maxIntDigits = toType.getPrecision() - toType.getScale();
                return intDigits <= maxIntDigits;
            }
        }
        return true;
    }
}

