/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class TimestampToNumericCastRule
extends AbstractExpressionCodeGeneratorCastRule<TimestampData, Number> {
    static final TimestampToNumericCastRule INSTANCE = new TimestampToNumericCastRule();

    private TimestampToNumericCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(LogicalTypeFamily.NUMERIC).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            throw new ValidationException("The cast from TIMESTAMP type to NUMERIC type is not allowed. It's recommended to use UNIX_TIMESTAMP(CAST(timestamp_col AS STRING)) instead.");
        }
        if (inputLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            throw new ValidationException("The cast from TIMESTAMP_LTZ type to NUMERIC type is not allowed.");
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

