/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyFilterConditionRule;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Option;
import scala.Tuple2;

public class DeletePushDownUtils {
    public static Optional<DynamicTableSink> getDynamicTableSink(ContextResolvedTable contextResolvedTable, LogicalTableModify tableModify, CatalogManager catalogManager) {
        FlinkContext context = ShortcutUtils.unwrapContext(tableModify.getCluster());
        CatalogBaseTable catalogBaseTable = contextResolvedTable.getTable();
        if (catalogBaseTable instanceof CatalogTable) {
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)contextResolvedTable.getResolvedTable();
            Optional optionalCatalog = contextResolvedTable.getCatalog();
            ObjectIdentifier objectIdentifier = contextResolvedTable.getIdentifier();
            boolean isTemporary = contextResolvedTable.isTemporary();
            if (!contextResolvedTable.isAnonymous() && !TableFactoryUtil.isLegacyConnectorOptions((Catalog)catalogManager.getCatalog(objectIdentifier.getCatalogName()).orElse(null), (ReadableConfig)context.getTableConfig(), (!context.isBatchMode() ? 1 : 0) != 0, (ObjectIdentifier)objectIdentifier, (CatalogTable)resolvedTable, (boolean)isTemporary)) {
                DynamicTableSinkFactory dynamicTableSinkFactory = null;
                if (optionalCatalog.isPresent() && ((Catalog)optionalCatalog.get()).getFactory().isPresent() && ((Catalog)optionalCatalog.get()).getFactory().get() instanceof DynamicTableSinkFactory) {
                    dynamicTableSinkFactory = (DynamicTableSinkFactory)((Catalog)optionalCatalog.get()).getFactory().get();
                }
                if (dynamicTableSinkFactory == null) {
                    Optional factoryFromModule = context.getModuleManager().getFactory(Module::getTableSinkFactory);
                    dynamicTableSinkFactory = factoryFromModule.orElse(null);
                }
                DynamicTableSink tableSink = FactoryUtil.createDynamicTableSink((DynamicTableSinkFactory)dynamicTableSinkFactory, (ObjectIdentifier)objectIdentifier, (ResolvedCatalogTable)resolvedTable, Collections.emptyMap(), (ReadableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), (boolean)contextResolvedTable.isTemporary());
                return Optional.of(tableSink);
            }
        }
        return Optional.empty();
    }

    public static Optional<List<ResolvedExpression>> getResolvedFilterExpressions(LogicalTableModify tableModify) {
        FlinkContext context = ShortcutUtils.unwrapContext(tableModify.getCluster());
        RelNode input = tableModify.getInput().getInput(0);
        if (input instanceof LogicalTableScan) {
            return Optional.of(Collections.emptyList());
        }
        if (!(input instanceof LogicalFilter)) {
            return Optional.empty();
        }
        Filter filter = (Filter)input;
        if (RexUtil.SubQueryFinder.containsSubQuery(filter)) {
            return Optional.empty();
        }
        filter = DeletePushDownUtils.prepareFilter(filter);
        List<ResolvedExpression> resolveExpression = DeletePushDownUtils.resolveFilter(context, filter);
        return Optional.ofNullable(resolveExpression);
    }

    private static Filter prepareFilter(Filter filter) {
        ReduceExpressionsRuleProxy reduceExpressionsRuleProxy = ReduceExpressionsRuleProxy.INSTANCE;
        SimplifyFilterConditionRule simplifyFilterConditionRule = SimplifyFilterConditionRule.INSTANCE();
        int maxIteration = 5;
        boolean changed = true;
        for (int iteration = 1; changed && iteration <= maxIteration; ++iteration) {
            Option<Filter> changedFilter;
            changed = false;
            RexNode newCondition = filter.getCondition();
            ArrayList<RexNode> expList = new ArrayList<RexNode>();
            expList.add(newCondition);
            if (reduceExpressionsRuleProxy.reduce(filter, expList)) {
                newCondition = (RexNode)expList.get(0);
                changed = true;
            }
            if (!(changedFilter = simplifyFilterConditionRule.simplify(filter = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition), new boolean[]{false})).isDefined()) continue;
            filter = (Filter)changedFilter.get();
            changed = true;
        }
        return filter;
    }

    private static List<ResolvedExpression> resolveFilter(FlinkContext context, Filter filter) {
        Tuple2<RexNode[], RexNode[]> extractedPredicates = FlinkRexUtil.extractPredicates(filter.getInput().getRowType().getFieldNames().toArray(new String[0]), filter.getCondition(), filter, filter.getCluster().getRexBuilder());
        RexNode[] convertiblePredicates = (RexNode[])extractedPredicates._1;
        RexNode[] unconvertedPredicates = (RexNode[])extractedPredicates._2;
        if (unconvertedPredicates.length != 0) {
            return null;
        }
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(filter.getCluster().getRexBuilder(), filter.getInput().getRowType().getFieldNames().toArray(new String[0]), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)context.getTableConfig())));
        List filters = Arrays.stream(convertiblePredicates).map(p -> {
            Option<ResolvedExpression> expr = p.accept(converter);
            if (expr.isDefined()) {
                return (ResolvedExpression)expr.get();
            }
            throw new TableException(String.format("%s can not be converted to Expression", p));
        }).collect(Collectors.toList());
        ExpressionResolver resolver = ExpressionResolver.resolverFor((TableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), name -> Optional.empty(), (FunctionLookup)context.getFunctionCatalog().asLookup(str -> {
            throw new TableException("We should not need to lookup any expressions at this point");
        }), (DataTypeFactory)context.getCatalogManager().getDataTypeFactory(), (sqlExpression, inputRowType, outputType) -> {
            throw new TableException("SQL expression parsing is not supported at this location.");
        }, (QueryOperation[])new QueryOperation[0]).build();
        return resolver.resolve(filters);
    }

    private static class ReduceExpressionsRuleProxy
    extends ReduceExpressionsRule<ReduceExpressionsRule.Config> {
        private static final ReduceExpressionsRule.Config config = ReduceExpressionsRule.FilterReduceExpressionsRule.FilterReduceExpressionsRuleConfig.DEFAULT;
        private static final ReduceExpressionsRuleProxy INSTANCE = new ReduceExpressionsRuleProxy();

        public ReduceExpressionsRuleProxy() {
            super(config);
        }

        @Override
        public void onMatch(RelOptRuleCall relOptRuleCall) {
            throw new UnsupportedOperationException("This shouldn't be called");
        }

        private boolean reduce(RelNode rel, List<RexNode> expList) {
            return ReduceExpressionsRuleProxy.reduceExpressions(rel, expList, RelOptPredicateList.EMPTY, true, config.matchNullability(), config.treatDynamicCallsAsConstant());
        }
    }
}

