/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.time.Duration;
import java.util.Objects;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGeneratorSupplier;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import scala.Option;

@JsonTypeName(value="WatermarkPushDown")
public final class WatermarkPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_WATERMARK_EXPR = "watermarkExpr";
    public static final String FIELD_NAME_IDLE_TIMEOUT_MILLIS = "idleTimeoutMillis";
    @JsonProperty(value="watermarkExpr")
    private final RexNode watermarkExpr;
    @JsonProperty(value="idleTimeoutMillis")
    private final long idleTimeoutMillis;

    @JsonCreator
    public WatermarkPushDownSpec(@JsonProperty(value="watermarkExpr") RexNode watermarkExpr, @JsonProperty(value="idleTimeoutMillis") long idleTimeoutMillis, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.watermarkExpr = (RexNode)Preconditions.checkNotNull((Object)watermarkExpr);
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        WatermarkStrategy watermarkStrategy;
        if (tableSource instanceof SupportsWatermarkPushDown) {
            GeneratedWatermarkGenerator generatedWatermarkGenerator = WatermarkGeneratorCodeGenerator.generateWatermarkGenerator((ReadableConfig)context.getTableConfig(), context.getClassLoader(), context.getSourceRowType(), this.watermarkExpr, (Option<String>)Option.apply((Object)"context"));
            GeneratedWatermarkGeneratorSupplier supplier = new GeneratedWatermarkGeneratorSupplier(generatedWatermarkGenerator);
            watermarkStrategy = WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)supplier);
            if (this.idleTimeoutMillis > 0L) {
                watermarkStrategy = watermarkStrategy.withIdleness(Duration.ofMillis(this.idleTimeoutMillis));
            }
        } else {
            throw new TableException(String.format("%s does not support SupportsWatermarkPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsWatermarkPushDown)tableSource).applyWatermark(watermarkStrategy);
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        String expressionStr = FlinkRexUtil.getExpressionString(this.watermarkExpr, JavaScalaConversionUtil.toScala(context.getSourceRowType().getFieldNames()));
        if (this.idleTimeoutMillis > 0L) {
            return String.format("watermark=[%s], idletimeout=[%d]", expressionStr, this.idleTimeoutMillis);
        }
        return String.format("watermark=[%s]", expressionStr);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WatermarkPushDownSpec that = (WatermarkPushDownSpec)o;
        return this.idleTimeoutMillis == that.idleTimeoutMillis && Objects.equals(this.watermarkExpr, that.watermarkExpr);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.watermarkExpr, this.idleTimeoutMillis);
    }
}

