/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.window.LocalSlicingWindowAggOperator;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.LocalAggCombiner;
import org.apache.flink.table.runtime.operators.window.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-local-window-aggregate", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"local-window-aggregate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecLocalWindowAggregate
extends StreamExecWindowAggregateBase {
    public static final String LOCAL_WINDOW_AGGREGATE_TRANSFORMATION = "local-window-aggregate";
    private static final long WINDOW_AGG_MEMORY_RATIO = 100L;
    public static final String FIELD_NAME_WINDOWING = "windowing";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;

    public StreamExecLocalWindowAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, WindowingStrategy windowing, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecLocalWindowAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecLocalWindowAggregate.class, tableConfig), grouping, aggCalls, windowing, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecLocalWindowAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowing.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        SliceAssigner sliceAssigner = this.createSliceAssigner(this.windowing, shiftTimeZone);
        AggregateInfoList aggInfoList = AggregateUtil.deriveStreamWindowAggregateInfoList(planner.getTypeFactory(), inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.windowing.getWindow(), false);
        GeneratedNamespaceAggsHandleFunction<Long> generatedAggsHandler = this.createAggsHandler(sliceAssigner, aggInfoList, config, planner.getFlinkContext().getClassLoader(), planner.createRelBuilder(), inputRowType.getChildren(), shiftTimeZone);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        PagedTypeSerializer keySer = (PagedTypeSerializer)selector.getProducedType().toSerializer();
        RowDataSerializer valueSer = new RowDataSerializer(inputRowType);
        RecordsWindowBuffer.LocalFactory bufferFactory = new RecordsWindowBuffer.LocalFactory(keySer, (AbstractRowDataSerializer)valueSer, (RecordsCombiner.LocalFactory)new LocalAggCombiner.Factory(generatedAggsHandler));
        LocalSlicingWindowAggOperator localAggOperator = new LocalSlicingWindowAggOperator(selector, sliceAssigner, (WindowBuffer.LocalFactory)bufferFactory, shiftTimeZone);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(LOCAL_WINDOW_AGGREGATE_TRANSFORMATION, config), SimpleOperatorFactory.of((StreamOperator)localAggOperator), InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), 50L, false);
    }

    private GeneratedNamespaceAggsHandleFunction<Long> createAggsHandler(SliceAssigner sliceAssigner, AggregateInfoList aggInfoList, ExecNodeConfig config, ClassLoader classLoader, RelBuilder relBuilder, List<LogicalType> fieldTypes, ZoneId shiftTimeZone) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config, classLoader), relBuilder, JavaScalaConversionUtil.toScala(fieldTypes), true).needAccumulate().needMerge(0, true, null);
        return generator.generateNamespaceAggsHandler("LocalWindowAggsHandler", aggInfoList, JavaScalaConversionUtil.toScala(Collections.emptyList()), sliceAssigner, shiftTimeZone);
    }
}

