/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.filesystem.PartitionLoader;
import org.apache.flink.table.filesystem.PartitionTempFileManager;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;

@Internal
class FileSystemCommitter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FileSystemFactory factory;
    private final TableMetaStoreFactory metaStoreFactory;
    private final boolean overwrite;
    private final Path tmpPath;
    private final int partitionColumnSize;

    FileSystemCommitter(FileSystemFactory factory, TableMetaStoreFactory metaStoreFactory, boolean overwrite, Path tmpPath, int partitionColumnSize) {
        this.factory = factory;
        this.metaStoreFactory = metaStoreFactory;
        this.overwrite = overwrite;
        this.tmpPath = tmpPath;
        this.partitionColumnSize = partitionColumnSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPartitions() throws Exception {
        FileSystem fs = this.factory.create(this.tmpPath.toUri());
        List<Path> taskPaths = PartitionTempFileManager.listTaskTemporaryPaths(fs, this.tmpPath);
        try (PartitionLoader loader = new PartitionLoader(this.overwrite, fs, this.metaStoreFactory);){
            if (this.partitionColumnSize > 0) {
                for (Map.Entry<LinkedHashMap<String, String>, List<Path>> entry : PartitionTempFileManager.collectPartSpecToPaths(fs, taskPaths, this.partitionColumnSize).entrySet()) {
                    loader.loadPartition(entry.getKey(), entry.getValue());
                }
            } else {
                loader.loadNonPartition(taskPaths);
            }
        }
        finally {
            for (Path taskPath : taskPaths) {
                fs.delete(taskPath, true);
            }
        }
    }
}

