/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.source.InputFormatSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.BulkDecodingFormat;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsPartitionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.filesystem.AbstractFileSystemTable;
import org.apache.flink.table.filesystem.DeserializationSchemaAdapter;
import org.apache.flink.table.filesystem.LimitableBulkFormat;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;

public class FileSystemTableSource
extends AbstractFileSystemTable
implements ScanTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown,
SupportsPartitionPushDown,
SupportsFilterPushDown {
    @Nullable
    private final DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat;
    @Nullable
    private final DecodingFormat<DeserializationSchema<RowData>> deserializationFormat;
    @Nullable
    private final FileSystemFormatFactory formatFactory;
    private int[][] projectedFields;
    private List<Map<String, String>> remainingPartitions;
    private List<ResolvedExpression> filters;
    private Long limit;

    public FileSystemTableSource(DynamicTableFactory.Context context, @Nullable DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat, @Nullable DecodingFormat<DeserializationSchema<RowData>> deserializationFormat, @Nullable FileSystemFormatFactory formatFactory) {
        super(context);
        if (Stream.of(bulkReaderFormat, deserializationFormat, formatFactory).allMatch(Objects::isNull)) {
            Configuration options = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
            String identifier = (String)options.get(FactoryUtil.FORMAT);
            throw new ValidationException(String.format("Could not find any format factory for identifier '%s' in the classpath.", identifier));
        }
        this.bulkReaderFormat = bulkReaderFormat;
        this.deserializationFormat = deserializationFormat;
        this.formatFactory = formatFactory;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        if (!this.partitionKeys.isEmpty() && this.getOrFetchPartitions().isEmpty()) {
            return InputFormatProvider.of((InputFormat)new CollectionInputFormat(new ArrayList(), null));
        }
        if (this.bulkReaderFormat != null) {
            if (this.bulkReaderFormat instanceof BulkDecodingFormat && this.filters != null && this.filters.size() > 0) {
                ((BulkDecodingFormat)this.bulkReaderFormat).applyFilters(this.filters);
            }
            BulkFormat bulkFormat = (BulkFormat)this.bulkReaderFormat.createRuntimeDecoder((DynamicTableSource.Context)scanContext, this.getProducedDataType());
            return this.createSourceProvider((BulkFormat<RowData, FileSourceSplit>)bulkFormat);
        }
        if (this.formatFactory != null) {
            return SourceFunctionProvider.of((SourceFunction)new InputFormatSourceFunction(this.getInputFormat(), InternalTypeInfo.of(this.getProducedDataType().getLogicalType())), (boolean)true);
        }
        if (this.deserializationFormat != null) {
            DeserializationSchema decoder = (DeserializationSchema)this.deserializationFormat.createRuntimeDecoder((DynamicTableSource.Context)scanContext, this.getFormatDataType());
            return this.createSourceProvider(new DeserializationSchemaAdapter((DeserializationSchema<RowData>)decoder, this.schema, this.readFields(), this.partitionKeys, this.defaultPartName));
        }
        throw new TableException("Can not find format factory.");
    }

    private SourceProvider createSourceProvider(BulkFormat<RowData, FileSourceSplit> bulkFormat) {
        FileSource.FileSourceBuilder builder = FileSource.forBulkFileFormat(LimitableBulkFormat.create(bulkFormat, this.limit), (Path[])this.paths());
        return SourceProvider.of((Source)builder.build());
    }

    private Path[] paths() {
        if (this.partitionKeys.isEmpty()) {
            return new Path[]{this.path};
        }
        return (Path[])this.getOrFetchPartitions().stream().map(this::toFullLinkedPartSpec).map(PartitionPathUtils::generatePartitionPath).map(n -> new Path(this.path, n)).toArray(Path[]::new);
    }

    private InputFormat<RowData, ?> getInputFormat() {
        return this.formatFactory.createReader(new FileSystemFormatFactory.ReaderContext(){

            public TableSchema getSchema() {
                return FileSystemTableSource.this.schema;
            }

            public ReadableConfig getFormatOptions() {
                return FileSystemTableSource.this.formatOptions(FileSystemTableSource.this.formatFactory.factoryIdentifier());
            }

            public List<String> getPartitionKeys() {
                return FileSystemTableSource.this.partitionKeys;
            }

            public String getDefaultPartName() {
                return FileSystemTableSource.this.defaultPartName;
            }

            public Path[] getPaths() {
                return FileSystemTableSource.this.paths();
            }

            public int[] getProjectFields() {
                return FileSystemTableSource.this.readFields();
            }

            public long getPushedDownLimit() {
                return FileSystemTableSource.this.limit == null ? Long.MAX_VALUE : FileSystemTableSource.this.limit;
            }

            public List<ResolvedExpression> getPushedDownFilters() {
                return FileSystemTableSource.this.filters == null ? Collections.emptyList() : FileSystemTableSource.this.filters;
            }
        });
    }

    public ChangelogMode getChangelogMode() {
        if (this.bulkReaderFormat != null) {
            return this.bulkReaderFormat.getChangelogMode();
        }
        if (this.formatFactory != null) {
            return ChangelogMode.insertOnly();
        }
        if (this.deserializationFormat != null) {
            return this.deserializationFormat.getChangelogMode();
        }
        throw new TableException("Can not find format factory.");
    }

    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        this.filters = new ArrayList<ResolvedExpression>(filters);
        return SupportsFilterPushDown.Result.of(new ArrayList<ResolvedExpression>(filters), new ArrayList<ResolvedExpression>(filters));
    }

    public void applyLimit(long limit) {
        this.limit = limit;
    }

    public Optional<List<Map<String, String>>> listPartitions() {
        try {
            return Optional.of(PartitionPathUtils.searchPartSpecAndPaths((FileSystem)this.path.getFileSystem(), (Path)this.path, (int)this.partitionKeys.size()).stream().map(tuple2 -> (LinkedHashMap)tuple2.f0).map(spec -> {
                LinkedHashMap ret = new LinkedHashMap();
                spec.forEach((k, v) -> ret.put(k, this.defaultPartName.equals(v) ? null : v));
                return ret;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new TableException("Fetch partitions fail.", (Throwable)e);
        }
    }

    public void applyPartitions(List<Map<String, String>> remainingPartitions) {
        this.remainingPartitions = remainingPartitions;
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields) {
        this.projectedFields = projectedFields;
    }

    public FileSystemTableSource copy() {
        FileSystemTableSource source = new FileSystemTableSource(this.context, this.bulkReaderFormat, this.deserializationFormat, this.formatFactory);
        source.projectedFields = this.projectedFields;
        source.remainingPartitions = this.remainingPartitions;
        source.filters = this.filters;
        source.limit = this.limit;
        return source;
    }

    public String asSummaryString() {
        return "Filesystem";
    }

    private List<Map<String, String>> getOrFetchPartitions() {
        if (this.remainingPartitions == null) {
            this.remainingPartitions = this.listPartitions().get();
        }
        return this.remainingPartitions;
    }

    private LinkedHashMap<String, String> toFullLinkedPartSpec(Map<String, String> part) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : this.partitionKeys) {
            if (!part.containsKey(k)) {
                throw new TableException("Partition keys are: " + this.partitionKeys + ", incomplete partition spec: " + part);
            }
            map.put(k, part.get(k));
        }
        return map;
    }

    private int[] readFields() {
        return this.projectedFields == null ? IntStream.range(0, this.schema.getFieldCount()).toArray() : Arrays.stream(this.projectedFields).mapToInt(array -> array[0]).toArray();
    }

    private DataType getProducedDataType() {
        int[] fields = this.readFields();
        String[] schemaFieldNames = this.schema.getFieldNames();
        DataType[] schemaTypes = this.schema.getFieldDataTypes();
        return (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])((DataTypes.Field[])Arrays.stream(fields).mapToObj(i -> DataTypes.FIELD((String)schemaFieldNames[i], (DataType)schemaTypes[i])).toArray(DataTypes.Field[]::new))).bridgedTo(RowData.class)).notNull();
    }
}

