/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.table.filesystem.FileSystemFactory;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class PartitionTempFileManager {
    private static final String TASK_DIR_PREFIX = "task-";
    private final int taskNumber;
    private final Path taskTmpDir;
    private final OutputFileConfig outputFileConfig;
    private transient int nameCounter = 0;

    PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber) throws IOException {
        this(factory, tmpPath, taskNumber, new OutputFileConfig("", ""));
    }

    PartitionTempFileManager(FileSystemFactory factory, Path tmpPath, int taskNumber, OutputFileConfig outputFileConfig) throws IOException {
        this.taskNumber = taskNumber;
        this.outputFileConfig = outputFileConfig;
        this.taskTmpDir = new Path(tmpPath, TASK_DIR_PREFIX + taskNumber);
        factory.create(this.taskTmpDir.toUri()).delete(this.taskTmpDir, true);
    }

    public Path createPartitionDir(String ... partitions) {
        Path parentPath = this.taskTmpDir;
        for (String dir : partitions) {
            parentPath = new Path(parentPath, dir);
        }
        return new Path(parentPath, this.newFileName());
    }

    private String newFileName() {
        return String.format("%s-%s-file-%d%s", this.outputFileConfig.getPartPrefix(), PartitionTempFileManager.taskName(this.taskNumber), this.nameCounter++, this.outputFileConfig.getPartSuffix());
    }

    private static boolean isTaskDir(String fileName) {
        return fileName.startsWith(TASK_DIR_PREFIX);
    }

    private static String taskName(int task) {
        return TASK_DIR_PREFIX + task;
    }

    public static List<Path> listTaskTemporaryPaths(FileSystem fs, Path basePath) throws Exception {
        ArrayList<Path> taskTmpPaths = new ArrayList<Path>();
        for (FileStatus taskStatus : fs.listStatus(basePath)) {
            if (!PartitionTempFileManager.isTaskDir(taskStatus.getPath().getName())) continue;
            taskTmpPaths.add(taskStatus.getPath());
        }
        return taskTmpPaths;
    }

    static Map<LinkedHashMap<String, String>, List<Path>> collectPartSpecToPaths(FileSystem fs, List<Path> taskPaths, int partColSize) {
        HashMap<LinkedHashMap<String, String>, List<Path>> specToPaths = new HashMap<LinkedHashMap<String, String>, List<Path>>();
        for (Path taskPath : taskPaths) {
            PartitionPathUtils.searchPartSpecAndPaths((FileSystem)fs, (Path)taskPath, (int)partColSize).forEach(tuple2 -> specToPaths.compute((LinkedHashMap<String, String>)tuple2.f0, (spec, paths) -> {
                paths = paths == null ? new ArrayList() : paths;
                paths.add(tuple2.f1);
                return paths;
            }));
        }
        return specToPaths;
    }
}

