/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.rules.ExternalResource;

public class TestLoggerResource
extends ExternalResource {
    private static final LoggerContext LOGGER_CONTEXT = (LoggerContext)LogManager.getContext((boolean)false);
    private final String loggerName;
    private final org.slf4j.event.Level level;
    private ConcurrentLinkedQueue<String> loggingEvents;

    public TestLoggerResource(Class<?> clazz, org.slf4j.event.Level level) {
        this.loggerName = clazz.getCanonicalName();
        this.level = level;
    }

    public List<String> getMessages() {
        return new ArrayList<String>(this.loggingEvents);
    }

    protected void before() throws Throwable {
        this.loggingEvents = new ConcurrentLinkedQueue();
        AbstractAppender testAppender = new AbstractAppender("test-appender", null, null, false){

            public void append(LogEvent event) {
                TestLoggerResource.this.loggingEvents.add(event.getMessage().getFormattedMessage());
            }
        };
        testAppender.start();
        AppenderRef appenderRef = AppenderRef.createAppenderRef((String)testAppender.getName(), null, null);
        LoggerConfig logger = LoggerConfig.createLogger((boolean)false, (Level)Level.getLevel((String)this.level.name()), (String)"test", null, (AppenderRef[])new AppenderRef[]{appenderRef}, null, (Configuration)LOGGER_CONTEXT.getConfiguration(), null);
        logger.addAppender((Appender)testAppender, null, null);
        LOGGER_CONTEXT.getConfiguration().addLogger(this.loggerName, logger);
        LOGGER_CONTEXT.updateLoggers();
    }

    protected void after() {
        LOGGER_CONTEXT.getConfiguration().removeLogger(this.loggerName);
        LOGGER_CONTEXT.updateLoggers();
        this.loggingEvents = null;
    }
}

