/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.testutils.org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.socket.nio.AbstractNioBossPool;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.socket.nio.NioClientBoss;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.HashedWheelTimer;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.ThreadNameDeterminer;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioClientBossPool
extends AbstractNioBossPool<NioClientBoss> {
    private final ThreadNameDeterminer determiner;
    private final Timer timer;
    private boolean stopTimer;

    public NioClientBossPool(Executor bossExecutor, int bossCount, Timer timer, ThreadNameDeterminer determiner) {
        super(bossExecutor, bossCount, false);
        this.determiner = determiner;
        this.timer = timer;
        this.init();
    }

    public NioClientBossPool(Executor bossExecutor, int bossCount) {
        this(bossExecutor, bossCount, new HashedWheelTimer(), null);
        this.stopTimer = true;
    }

    @Override
    protected NioClientBoss newBoss(Executor executor) {
        return new NioClientBoss(executor, this.timer, this.determiner);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.stopTimer) {
            this.timer.stop();
        }
    }

    @Override
    public void releaseExternalResources() {
        super.releaseExternalResources();
        this.timer.stop();
    }
}

