/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.CreateCQOp;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;

public class CloseCQOp {
    public static void execute(ExecutablePool pool, String cqName) {
        CloseCQOpImpl op = new CloseCQOpImpl(cqName);
        pool.executeOnAllQueueServers((Op)op);
    }

    private CloseCQOp() {
    }

    private static class CloseCQOpImpl
    extends CreateCQOp.CreateCQOpImpl {
        public CloseCQOpImpl(String cqName) {
            super(45, 1);
            this.getMessage().addStringPart(cqName);
        }

        @Override
        protected String getOpName() {
            return "closeCQ";
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCloseCQ();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCloseCQSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCloseCQ(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

