/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;

public class LuceneResultStructImpl<K, V>
implements LuceneResultStruct<K, V>,
DataSerializableFixedID {
    K key;
    V value;
    float score;

    public LuceneResultStructImpl() {
    }

    public LuceneResultStructImpl(K key, V value, float score) {
        this.key = key;
        this.value = value;
        this.score = score;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + Float.floatToIntBits(this.score);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuceneResultStructImpl other = (LuceneResultStructImpl)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (Float.floatToIntBits(this.score) != Float.floatToIntBits(other.score)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "LuceneResultStructImpl [key=" + this.key + ", value=" + this.value + ", score=" + this.score + "]";
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2180;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.key, (DataOutput)out);
        DataSerializer.writeObject(this.value, (DataOutput)out);
        out.writeFloat(this.score);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readObject((DataInput)in);
        this.value = DataSerializer.readObject((DataInput)in);
        this.score = in.readFloat();
    }
}

