/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.filesystem;

import java.io.EOFException;
import java.io.IOException;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.SeekableInputStream;

class FileInputStream
extends SeekableInputStream {
    private final File file;
    private byte[] chunk = null;
    private int chunkPosition = 0;
    private int chunkId = 0;
    private boolean open = true;

    public FileInputStream(File file) {
        this.file = file;
        this.nextChunk();
    }

    public FileInputStream(FileInputStream other) {
        this.file = other.file;
        this.chunk = other.chunk;
        this.chunkId = other.chunkId;
        this.chunkPosition = other.chunkPosition;
        this.open = other.open;
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        this.checkAndFetchNextChunk();
        if (null == this.chunk) {
            return -1;
        }
        return this.chunk[this.chunkPosition++] & 0xFF;
    }

    @Override
    public void seek(long position) throws IOException {
        if (position > this.file.length) {
            throw new EOFException();
        }
        int targetChunk = (int)(position / (long)this.file.getChunkSize());
        int targetPosition = (int)(position % (long)this.file.getChunkSize());
        if (targetChunk != this.chunkId - 1) {
            this.chunk = this.file.getFileSystem().getChunk(this.file, targetChunk);
            this.chunkId = targetChunk + 1;
            this.chunkPosition = targetPosition;
        } else {
            this.chunkPosition = targetPosition;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int currentPosition = (this.chunkId - 1) * this.file.getChunkSize() + this.chunkPosition;
        this.seek((long)currentPosition + n);
        return n;
    }

    @Override
    public void reset() throws IOException {
        this.seek(0L);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        this.checkAndFetchNextChunk();
        if (null == this.chunk) {
            return -1;
        }
        int read = 0;
        while (len > 0) {
            int min = Math.min(this.remaining(), len);
            System.arraycopy(this.chunk, this.chunkPosition, b, off, min);
            off += min;
            this.chunkPosition += min;
            read += min;
            if ((len -= min) <= 0) continue;
            this.nextChunk();
            if (null != this.chunk) continue;
            break;
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        this.assertOpen();
        return this.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
        }
    }

    private int remaining() {
        return this.chunk.length - this.chunkPosition;
    }

    private void checkAndFetchNextChunk() {
        if (null != this.chunk && this.remaining() <= 0) {
            this.nextChunk();
        }
    }

    private void nextChunk() {
        this.chunk = this.file.getFileSystem().getChunk(this.file, this.chunkId++);
        this.chunkPosition = 0;
    }

    private void assertOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Closed");
        }
    }

    @Override
    public FileInputStream clone() {
        return new FileInputStream(this);
    }
}

