/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;

public class GMSUtil {
    public static List<HostAndPort> parseLocators(String locatorsString, String bindAddress) throws MembershipConfigurationException {
        InetAddress addr = null;
        try {
            addr = bindAddress == null || bindAddress.trim().length() == 0 ? LocalHostUtil.getLocalHost() : InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return GMSUtil.parseLocators(locatorsString, addr);
    }

    public static <ID extends MemberIdentifier> Set<ID> readHashSetOfMemberIDs(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = StaticSerialization.readArrayLength((DataInput)in);
        if (size == -1) {
            return null;
        }
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < size; ++i) {
            result.add(context.getDeserializer().readObject(in));
        }
        return result;
    }

    public static List<HostAndPort> parseLocators(String locatorsString, InetAddress bindAddress) throws MembershipConfigurationException {
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>(2);
        HashSet<InetSocketAddress> inetAddresses = new HashSet<InetSocketAddress>();
        boolean isLoopback = bindAddress != null && bindAddress.isLoopbackAddress();
        StringTokenizer parts = new StringTokenizer(locatorsString, ",");
        while (parts.hasMoreTokens()) {
            int port;
            String start;
            String str = parts.nextToken();
            int portSpecificationStart = str.indexOf(91);
            if (portSpecificationStart == -1) {
                throw GMSUtil.createBadPortException(str);
            }
            String host = str.substring(0, portSpecificationStart);
            int idx = host.lastIndexOf(64);
            if (idx < 0) {
                idx = host.lastIndexOf(58);
            }
            if ((start = host.substring(0, idx > -1 ? idx : host.length())).indexOf(58) >= 0) {
                idx = host.lastIndexOf(64);
            }
            if (idx >= 0) {
                host = host.substring(idx + 1, host.length());
            }
            int startIdx = portSpecificationStart + 1;
            int endIdx = str.indexOf(93);
            if (endIdx == -1) {
                throw GMSUtil.createBadPortException(str);
            }
            try {
                port = Integer.parseInt(str.substring(startIdx, endIdx));
            }
            catch (NumberFormatException e) {
                throw GMSUtil.createBadPortException(str);
            }
            InetSocketAddress isa = new InetSocketAddress(host, port);
            if (isLoopback) {
                InetAddress locatorAddress = isa.getAddress();
                if (locatorAddress == null) {
                    throw new MembershipConfigurationException("This process is attempting to use a locator at an unknown address or FQDN: " + host);
                }
                if (!locatorAddress.isLoopbackAddress()) {
                    throw new MembershipConfigurationException("This process is attempting to join with a loopback address (" + bindAddress + ") using a locator that does not have a local address (" + isa + ").  On Unix this usually means that /etc/hosts is misconfigured.");
                }
            }
            HostAndPort hostAndPort = new HostAndPort(host, port);
            if (inetAddresses.contains(isa)) continue;
            inetAddresses.add(isa);
            result.add(hostAndPort);
        }
        return result;
    }

    private static MembershipConfigurationException createBadPortException(String str) {
        return new MembershipConfigurationException("This process is attempting to use a locator with a malformed port specification: " + str);
    }

    public static String[] parseGroups(String csvRoles, String csvGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        GMSUtil.parseCsv(groups, csvRoles);
        GMSUtil.parseCsv(groups, csvGroups);
        return groups.toArray(new String[groups.size()]);
    }

    private static void parseCsv(List<String> groups, String csv) {
        if (csv == null || csv.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
    }

    public static String replaceStrings(String properties, String property, String value) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int index = properties.indexOf(property);
        while (index != -1) {
            sb.append(properties.substring(start, index));
            sb.append(value);
            start = index + property.length();
            index = properties.indexOf(property, start);
        }
        sb.append(properties.substring(start));
        return sb.toString();
    }

    public static <ID extends MemberIdentifier> List<ID> readArrayOfIDs(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        int size = StaticSerialization.readArrayLength((DataInput)in);
        if (size == -1) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            result.add(context.getDeserializer().readObject(in));
        }
        return result;
    }

    public static <ID extends MemberIdentifier> void writeSetOfMemberIDs(Set<ID> set, DataOutput out, SerializationContext context) throws IOException {
        int size = set == null ? -1 : set.size();
        StaticSerialization.writeArrayLength((int)size, (DataOutput)out);
        if (size > 0) {
            for (MemberIdentifier member : set) {
                context.getSerializer().writeObject((Object)member, out);
            }
        }
    }
}

