/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LocatorHelper {
    public static final Object locatorObject = new Object();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addLocator(int distributedSystemId, DistributionLocatorId locator, LocatorMembershipListener locatorListener, DistributionLocatorId sourceLocator) {
        ConcurrentHashMap allLocatorsInfo = (ConcurrentHashMap)locatorListener.getAllLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator);
        Set existingValue = (Set)allLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null) {
            if (existingValue.contains(locator)) return false;
            existingValue.add(locator);
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
            return true;
        } else {
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
        }
        return true;
    }

    private static void addServerLocator(Integer distributedSystemId, LocatorMembershipListener locatorListener, DistributionLocatorId locator) {
        if (!locator.isServerLocator()) {
            return;
        }
        ConcurrentHashMap allServerLocatorsInfo = (ConcurrentHashMap)locatorListener.getAllServerLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator.toString());
        Set existingValue = (Set)allServerLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null && !existingValue.contains(locator.toString())) {
            existingValue.add(locator.toString());
        }
    }

    public static boolean addExchnagedLocators(Map<Integer, Set<DistributionLocatorId>> locators, LocatorMembershipListener locatorListener) {
        ConcurrentHashMap allLocators = (ConcurrentHashMap)locatorListener.getAllLocatorsInfo();
        if (!allLocators.equals(locators)) {
            for (Map.Entry<Integer, Set<DistributionLocatorId>> entry : locators.entrySet()) {
                Set existingValue = (Set)allLocators.putIfAbsent(entry.getKey(), new CopyOnWriteHashSet(entry.getValue()));
                if (existingValue != null) {
                    Set localLocators = (Set)allLocators.get(entry.getKey());
                    if (localLocators.equals(entry.getValue())) continue;
                    entry.getValue().removeAll(localLocators);
                    for (DistributionLocatorId locator : entry.getValue()) {
                        localLocators.add(locator);
                        LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                        locatorListener.locatorJoined(entry.getKey().intValue(), locator, null);
                    }
                    continue;
                }
                for (DistributionLocatorId locator : entry.getValue()) {
                    LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                    locatorListener.locatorJoined(entry.getKey().intValue(), locator, null);
                }
            }
            return true;
        }
        return false;
    }
}

