/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorDiscovery;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorHelper;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.WanLocatorDiscoverer;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Logger;

public class WanLocatorDiscovererImpl
implements WanLocatorDiscoverer {
    private static final Logger logger = LogService.getLogger();
    private volatile boolean stopped = false;
    private ExecutorService _executor;

    public void discover(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener) {
        final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup((String)"WAN Locator Discovery Logger Group", (Logger)logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread((ThreadGroup)loggingThreadGroup, task, "WAN Locator Discovery Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        this._executor = Executors.newCachedThreadPool(threadFactory);
        this.exchangeLocalLocators(port, config, locatorListener);
        this.exchangeRemoteLocators(port, config, locatorListener);
        this._executor.shutdown();
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void exchangeLocalLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress()) : new DistributionLocatorId(localLocator);
        LocatorHelper.addLocator(config.getDistributedSystemId(), locatorId, locatorListener, null);
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config);
        StringTokenizer locatorsOnThisVM = new StringTokenizer(config.getLocators(), ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            DistributionLocatorId localLocatorId = new DistributionLocatorId(locatorsOnThisVM.nextToken());
            if (locatorId.equals((Object)localLocatorId)) continue;
            LocatorDiscovery localDiscovery = new LocatorDiscovery(this, localLocatorId, request, locatorListener);
            LocatorDiscovery.LocalLocatorDiscovery localLocatorDiscovery = localDiscovery.new LocatorDiscovery.LocalLocatorDiscovery();
            this._executor.execute(localLocatorDiscovery);
        }
    }

    private void exchangeRemoteLocators(int port, DistributionConfigImpl config, LocatorMembershipListener locatorListener) {
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(port, config);
        String remoteDustributedSystems = config.getRemoteLocators();
        if (remoteDustributedSystems.length() > 0) {
            StringTokenizer remoteLocators = new StringTokenizer(remoteDustributedSystems, ",");
            while (remoteLocators.hasMoreTokens()) {
                DistributionLocatorId remoteLocatorId = new DistributionLocatorId(remoteLocators.nextToken());
                LocatorDiscovery localDiscovery = new LocatorDiscovery(this, remoteLocatorId, request, locatorListener);
                LocatorDiscovery.RemoteLocatorDiscovery remoteLocatorDiscovery = localDiscovery.new LocatorDiscovery.RemoteLocatorDiscovery();
                this._executor.execute(remoteLocatorDiscovery);
            }
        }
    }

    private RemoteLocatorJoinRequest buildRemoteDSJoinRequest(int port, DistributionConfigImpl config) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(port, config.getBindAddress()) : new DistributionLocatorId(localLocator);
        RemoteLocatorJoinRequest request = new RemoteLocatorJoinRequest(config.getDistributedSystemId(), locatorId, "");
        return request;
    }
}

