/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverException;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.GatewayReceiverCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GatewayReceiverFactoryImpl
implements GatewayReceiverFactory {
    private int startPort = 5000;
    private int endPort = 5500;
    private int timeBetPings = 60000;
    private int socketBuffSize = 524288;
    private String bindAdd = "";
    private String hostnameForSenders = "";
    private boolean manualStart = false;
    private List<GatewayTransportFilter> filters = new ArrayList<GatewayTransportFilter>();
    private Cache cache;

    public GatewayReceiverFactoryImpl() {
    }

    public GatewayReceiverFactoryImpl(Cache cache) {
        this.cache = cache;
    }

    public GatewayReceiverFactory addGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public GatewayReceiverFactory removeGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.remove(filter);
        return this;
    }

    public GatewayReceiverFactory setMaximumTimeBetweenPings(int time) {
        this.timeBetPings = time;
        return this;
    }

    public GatewayReceiverFactory setStartPort(int port) {
        this.startPort = port;
        return this;
    }

    public GatewayReceiverFactory setEndPort(int port) {
        this.endPort = port;
        return this;
    }

    public GatewayReceiverFactory setSocketBufferSize(int size) {
        this.socketBuffSize = size;
        return this;
    }

    public GatewayReceiverFactory setBindAddress(String address) {
        this.bindAdd = address;
        return this;
    }

    public GatewayReceiverFactory setHostnameForSenders(String address) {
        this.hostnameForSenders = address;
        return this;
    }

    public GatewayReceiverFactory setManualStart(boolean start) {
        this.manualStart = start;
        return this;
    }

    public GatewayReceiver create() {
        if (this.startPort > this.endPort) {
            throw new IllegalStateException("Please specify either start port a value which is less than end port.");
        }
        GatewayReceiverImpl recv = null;
        if (this.cache instanceof GemFireCacheImpl) {
            recv = new GatewayReceiverImpl(this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            ((GemFireCacheImpl)this.cache).addGatewayReceiver((GatewayReceiver)recv);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_CREATE, (Object)recv);
            if (!this.manualStart) {
                try {
                    recv.start();
                }
                catch (IOException ioe) {
                    throw new GatewayReceiverException(LocalizedStrings.GatewayReceiver_EXCEPTION_WHILE_STARTING_GATEWAY_RECEIVER.toLocalizedString(), (Throwable)ioe);
                }
            }
        } else if (this.cache instanceof CacheCreation) {
            recv = new GatewayReceiverCreation(this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            ((CacheCreation)this.cache).addGatewayReceiver((GatewayReceiver)recv);
        }
        return recv;
    }
}

