/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.RemoteParallelGatewaySenderEventProcessor;
import java.util.Set;

public class RemoteConcurrentParallelGatewaySenderEventProcessor
extends ConcurrentParallelGatewaySenderEventProcessor {
    public RemoteConcurrentParallelGatewaySenderEventProcessor(AbstractGatewaySender sender) {
        super(sender);
    }

    protected void createProcessors(int dispatcherThreads, Set<Region> targetRs) {
        this.processors = new RemoteParallelGatewaySenderEventProcessor[this.sender.getDispatcherThreads()];
        if (logger.isDebugEnabled()) {
            logger.debug("Creating GatewaySenderEventProcessor");
        }
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors[i] = new RemoteParallelGatewaySenderEventProcessor(this.sender, targetRs, i, this.sender.getDispatcherThreads());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
                GatewaySenderEventRemoteDispatcher remoteDispatcher = (GatewaySenderEventRemoteDispatcher)parallelProcessor.getDispatcher();
                if (!remoteDispatcher.isConnectedToRemote()) continue;
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }
}

