/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.AbstractRemoteGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.serial.RemoteConcurrentSerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.RemoteSerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SerialGatewaySenderImpl
extends AbstractRemoteGatewaySender {
    private static final Logger logger = LogService.getLogger();
    final ThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup((String)"Remote Site Discovery Logger Group", (Logger)logger);

    public SerialGatewaySenderImpl() {
        this.isParallel = false;
    }

    public SerialGatewaySenderImpl(Cache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting gatewaySender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, (Object)this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.getSenderAdvisor().initDLockService();
            if (!this.isPrimary()) {
                if (this.getSenderAdvisor().volunteerForPrimary()) {
                    this.getSenderAdvisor().makePrimary();
                } else {
                    this.getSenderAdvisor().makeSecondary();
                }
            }
            this.eventProcessor = this.getDispatcherThreads() > 1 ? new RemoteConcurrentSerialGatewaySenderEventProcessor(this) : new RemoteSerialGatewaySenderEventProcessor(this, this.getId());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            this.startTime = System.currentTimeMillis();
            if (!this.isAsyncEventQueue()) {
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewaySenderStarted((GatewaySender)this);
            }
            new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, (Object)this);
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.SerialGatewaySenderImpl_STARTED__0, (Object)((Object)this)));
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Set queues;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping Gateway Sender : {}", (Object)this);
        }
        this.getLifeCycleLock().writeLock().lock();
        try {
            AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
            if (ev != null && !ev.isStopped()) {
                ev.stopProcessing();
            }
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewayImpl_STOPPED__0, (Object)((Object)this)));
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
        if (this.isPrimary()) {
            try {
                DistributedLockService.destroy((String)this.getSenderAdvisor().getDLockServiceName());
            }
            catch (IllegalArgumentException ev) {
                // empty catch block
            }
        }
        if ((queues = this.getQueues()) != null && !queues.isEmpty()) {
            for (RegionQueue q : queues) {
                ((SerialGatewaySenderQueue)q).cleanUp();
            }
        }
        this.setIsPrimary(false);
        new UpdateAttributesProcessor((DistributionAdvisee)this).distribute(false);
        Thread lockObtainingThread = this.getSenderAdvisor().getLockObtainingThread();
        if (lockObtainingThread != null && lockObtainingThread.isAlive()) {
            try {
                lockObtainingThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (lockObtainingThread.isAlive()) {
                logger.info((Message)LocalizedMessage.create((StringId)LocalizedStrings.GatewaySender_COULD_NOT_STOP_LOCK_OBTAINING_THREAD_DURING_GATEWAY_SENDER_STOP));
            }
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, (Object)this);
        this.eventProcessor = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SerialGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append(",isPrimary =" + this.isPrimary());
        sb.append("}");
        return sb.toString();
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.startTime = this.getStartTime();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = false;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        for (GatewayEventFilter filter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(filter.getClass().getName());
        }
        for (GatewayEventFilter filter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(filter.getClass().getName());
        }
        for (AsyncEventListener listener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(listener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        pf.serverLocation = this.getServerLocation();
    }

    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID((long)newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket((int)0, (long)originalThreadId, (int)this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)originalEventId, (Object)originalThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }
}

