/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.mapreduce.v2.app.rm.ResourceCalculatorUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMContainerAllocator
extends RMContainerRequestor
implements ContainerAllocator {
    static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    public static final float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    static final Priority PRIORITY_FAST_FAIL_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
    static final Priority PRIORITY_REDUCE;
    static final Priority PRIORITY_MAP;
    @VisibleForTesting
    public static final String RAMPDOWN_DIAGNOSTIC = "Reducer preempted to make room for pending map attempts";
    private Thread eventHandlingThread;
    private final AtomicBoolean stopped;
    private final LinkedList<RMContainerRequestor.ContainerRequest> pendingReduces = new LinkedList();
    private final AssignedRequests assignedRequests = new AssignedRequests();
    private final ScheduledRequests scheduledRequests = new ScheduledRequests();
    private int containersAllocated = 0;
    private int containersReleased = 0;
    private int hostLocalAssigned = 0;
    private int rackLocalAssigned = 0;
    private int lastCompletedTasks = 0;
    private boolean recalculateReduceSchedule = false;
    private Resource mapResourceRequest = Resources.none();
    private Resource reduceResourceRequest = Resources.none();
    private boolean reduceStarted = false;
    private float maxReduceRampupLimit = 0.0f;
    private float maxReducePreemptionLimit = 0.0f;
    private long allocationDelayThresholdMs = 0L;
    private float reduceSlowStart = 0.0f;
    private int maxRunningMaps = 0;
    private int maxRunningReduces = 0;
    private long retryInterval;
    private long retrystartTime;
    private Clock clock;
    @VisibleForTesting
    protected BlockingQueue<ContainerAllocatorEvent> eventQueue = new LinkedBlockingQueue<ContainerAllocatorEvent>();
    private ScheduleStats scheduleStats = new ScheduleStats();

    public RMContainerAllocator(ClientService clientService, AppContext context) {
        super(clientService, context);
        this.stopped = new AtomicBoolean(false);
        this.clock = context.getClock();
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.reduceSlowStart = conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f);
        this.maxReduceRampupLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.rampup.limit", 0.5f);
        this.maxReducePreemptionLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.preemption.limit", 0.5f);
        this.allocationDelayThresholdMs = conf.getInt("mapreduce.job.reducer.preempt.delay.sec", 0) * 1000;
        this.maxRunningMaps = conf.getInt("mapreduce.job.running.map.limit", 0);
        this.maxRunningReduces = conf.getInt("mapreduce.job.running.reduce.limit", 0);
        RackResolver.init((Configuration)conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    @Override
    protected void serviceStart() throws Exception {
        this.eventHandlingThread = new Thread(){

            @Override
            public void run() {
                while (!RMContainerAllocator.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    ContainerAllocatorEvent event;
                    try {
                        event = RMContainerAllocator.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!RMContainerAllocator.this.stopped.get()) {
                            LOG.error((Object)("Returning, interrupted : " + e));
                        }
                        return;
                    }
                    try {
                        RMContainerAllocator.this.handleEvent(event);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Error in handling event type " + event.getType() + " to the ContainreAllocator"), t);
                        RMContainerAllocator.this.eventHandler.handle((Event)new JobEvent(RMContainerAllocator.this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                        return;
                    }
                }
            }
        };
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    @Override
    protected synchronized void heartbeat() throws Exception {
        int completedMaps;
        int completedTasks;
        this.scheduleStats.updateAndLogIfChanged("Before Scheduling: ");
        List<Container> allocatedContainers = this.getResources();
        if (allocatedContainers != null && allocatedContainers.size() > 0) {
            this.scheduledRequests.assign(allocatedContainers);
        }
        if (this.lastCompletedTasks != (completedTasks = (completedMaps = this.getJob().getCompletedMaps()) + this.getJob().getCompletedReduces()) || this.scheduledRequests.maps.size() > 0) {
            this.lastCompletedTasks = completedTasks;
            this.recalculateReduceSchedule = true;
        }
        if (this.recalculateReduceSchedule) {
            this.preemptReducesIfNeeded();
            this.scheduleReduces(this.getJob().getTotalMaps(), completedMaps, this.scheduledRequests.maps.size(), this.scheduledRequests.reduces.size(), this.assignedRequests.maps.size(), this.assignedRequests.reduces.size(), this.mapResourceRequest, this.reduceResourceRequest, this.pendingReduces.size(), this.maxReduceRampupLimit, this.reduceSlowStart);
            this.recalculateReduceSchedule = false;
        }
        this.scheduleStats.updateAndLogIfChanged("After Scheduling: ");
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        super.serviceStop();
        this.scheduleStats.log("Final Stats: ");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    AssignedRequests getAssignedRequests() {
        return this.assignedRequests;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    ScheduledRequests getScheduledRequests() {
        return this.scheduledRequests;
    }

    public boolean getIsReduceStarted() {
        return this.reduceStarted;
    }

    public void setIsReduceStarted(boolean reduceStarted) {
        this.reduceStarted = reduceStarted;
    }

    public void handle(ContainerAllocatorEvent event) {
        int remCapacity;
        int qSize = this.eventQueue.size();
        if (qSize != 0 && qSize % 1000 == 0) {
            LOG.info((Object)("Size of event-queue in RMContainerAllocator is " + qSize));
        }
        if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
            LOG.warn((Object)("Very low remaining capacity in the event-queue of RMContainerAllocator: " + remCapacity));
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected synchronized void handleEvent(ContainerAllocatorEvent event) {
        this.recalculateReduceSchedule = true;
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            ContainerRequestEvent reqEvent = (ContainerRequestEvent)event;
            JobId jobId = this.getJob().getID();
            Resource supportedMaxContainerCapability = this.getMaxContainerCapability();
            if (reqEvent.getAttemptID().getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                if (this.mapResourceRequest.equals((Object)Resources.none())) {
                    this.mapResourceRequest = reqEvent.getCapability();
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.MAP, this.mapResourceRequest.getMemory())));
                    LOG.info((Object)("mapResourceRequest:" + this.mapResourceRequest));
                    if (this.mapResourceRequest.getMemory() > supportedMaxContainerCapability.getMemory() || this.mapResourceRequest.getVirtualCores() > supportedMaxContainerCapability.getVirtualCores()) {
                        String diagMsg = "MAP capability required is more than the supported max container capability in the cluster. Killing the Job. mapResourceRequest: " + this.mapResourceRequest + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.mapResourceRequest.getMemory());
                reqEvent.getCapability().setVirtualCores(this.mapResourceRequest.getVirtualCores());
                this.scheduledRequests.addMap(reqEvent);
            } else {
                if (this.reduceResourceRequest.equals((Object)Resources.none())) {
                    this.reduceResourceRequest = reqEvent.getCapability();
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.REDUCE, this.reduceResourceRequest.getMemory())));
                    LOG.info((Object)("reduceResourceRequest:" + this.reduceResourceRequest));
                    if (this.reduceResourceRequest.getMemory() > supportedMaxContainerCapability.getMemory() || this.reduceResourceRequest.getVirtualCores() > supportedMaxContainerCapability.getVirtualCores()) {
                        String diagMsg = "REDUCE capability required is more than the supported max container capability in the cluster. Killing the Job. reduceResourceRequest: " + this.reduceResourceRequest + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.reduceResourceRequest.getMemory());
                reqEvent.getCapability().setVirtualCores(this.reduceResourceRequest.getVirtualCores());
                if (reqEvent.getEarlierAttemptFailed()) {
                    this.pendingReduces.addFirst(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                } else {
                    this.pendingReduces.add(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                }
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_DEALLOCATE) {
            ContainerId containerId;
            LOG.info((Object)("Processing the event " + event.toString()));
            TaskAttemptId aId = event.getAttemptID();
            boolean removed = this.scheduledRequests.remove(aId);
            if (!removed && (containerId = this.assignedRequests.get(aId)) != null) {
                removed = true;
                this.assignedRequests.remove(aId);
                ++this.containersReleased;
                this.pendingRelease.add(containerId);
                this.release(containerId);
            }
            if (!removed) {
                LOG.error((Object)("Could not deallocate container for task attemptId " + aId));
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_FAILED) {
            ContainerFailedEvent fEv = (ContainerFailedEvent)event;
            String host = RMContainerAllocator.getHost(fEv.getContMgrAddress());
            this.containerFailedOnHost(host);
        }
    }

    private static String getHost(String contMgrAddress) {
        String host = contMgrAddress;
        String[] hostport = host.split(":");
        if (hostport.length == 2) {
            host = hostport[0];
        }
        return host;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    synchronized void setReduceResourceRequest(Resource res) {
        this.reduceResourceRequest = res;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    synchronized void setMapResourceRequest(Resource res) {
        this.mapResourceRequest = res;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void preemptReducesIfNeeded() {
        Resource resourceLimit;
        Resource availableResourceForMap;
        if (this.reduceResourceRequest.equals((Object)Resources.none())) {
            return;
        }
        if (this.scheduledRequests.maps.size() > 0 && ResourceCalculatorUtils.computeAvailableContainers(availableResourceForMap = Resources.subtract((Resource)(resourceLimit = this.getResourceLimit()), (Resource)Resources.multiply((Resource)this.reduceResourceRequest, (double)(this.assignedRequests.reduces.size() - this.assignedRequests.preemptionWaitingReduces.size()))), this.mapResourceRequest, this.getSchedulerResourceTypes()) <= 0) {
            LOG.info((Object)("Ramping down all scheduled reduces:" + this.scheduledRequests.reduces.size()));
            for (RMContainerRequestor.ContainerRequest req : this.scheduledRequests.reduces.values()) {
                this.pendingReduces.add(req);
            }
            this.scheduledRequests.reduces.clear();
            int hangingMapRequests = this.getNumOfHangingRequests(this.scheduledRequests.maps);
            if (hangingMapRequests > 0) {
                int preemptionReduceNumForOneMap = ResourceCalculatorUtils.divideAndCeilContainers(this.mapResourceRequest, this.reduceResourceRequest, this.getSchedulerResourceTypes());
                int preemptionReduceNumForPreemptionLimit = ResourceCalculatorUtils.divideAndCeilContainers(Resources.multiply((Resource)resourceLimit, (double)this.maxReducePreemptionLimit), this.reduceResourceRequest, this.getSchedulerResourceTypes());
                int preemptionReduceNumForAllMaps = ResourceCalculatorUtils.divideAndCeilContainers(Resources.multiply((Resource)this.mapResourceRequest, (double)hangingMapRequests), this.reduceResourceRequest, this.getSchedulerResourceTypes());
                int toPreempt = Math.min(Math.max(preemptionReduceNumForOneMap, preemptionReduceNumForPreemptionLimit), preemptionReduceNumForAllMaps);
                LOG.info((Object)("Going to preempt " + toPreempt + " due to lack of space for maps"));
                this.assignedRequests.preemptReduce(toPreempt);
            }
        }
    }

    private int getNumOfHangingRequests(Map<TaskAttemptId, RMContainerRequestor.ContainerRequest> requestMap) {
        if (this.allocationDelayThresholdMs <= 0L) {
            return requestMap.size();
        }
        int hangingRequests = 0;
        long currTime = this.clock.getTime();
        for (RMContainerRequestor.ContainerRequest request : requestMap.values()) {
            long delay = currTime - request.requestTimeMs;
            if (delay <= this.allocationDelayThresholdMs) continue;
            ++hangingRequests;
        }
        return hangingRequests;
    }

    @InterfaceAudience.Private
    public void scheduleReduces(int totalMaps, int completedMaps, int scheduledMaps, int scheduledReduces, int assignedMaps, int assignedReduces, Resource mapResourceReqt, Resource reduceResourceReqt, int numPendingReduces, float maxReduceRampupLimit, float reduceSlowStart) {
        Resource finalMapResourceLimit;
        Resource finalReduceResourceLimit;
        Resource idealReduceResourceLimit;
        if (numPendingReduces == 0) {
            return;
        }
        Resource headRoom = this.getAvailableResources();
        if (headRoom == null) {
            headRoom = Resources.none();
        }
        LOG.info((Object)("Recalculating schedule, headroom=" + headRoom));
        if (!this.getIsReduceStarted()) {
            int completedMapsForReduceSlowstart = (int)Math.ceil(reduceSlowStart * (float)totalMaps);
            if (completedMaps < completedMapsForReduceSlowstart) {
                LOG.info((Object)("Reduce slow start threshold not met. completedMapsForReduceSlowstart " + completedMapsForReduceSlowstart));
                return;
            }
            LOG.info((Object)"Reduce slow start threshold reached. Scheduling reduces.");
            this.setIsReduceStarted(true);
        }
        if (scheduledMaps == 0 && numPendingReduces > 0) {
            LOG.info((Object)("All maps assigned. Ramping up all remaining reduces:" + numPendingReduces));
            this.scheduleAllReduces();
            return;
        }
        float completedMapPercent = 0.0f;
        completedMapPercent = totalMaps != 0 ? (float)completedMaps / (float)totalMaps : 1.0f;
        Resource netScheduledMapResource = Resources.multiply((Resource)mapResourceReqt, (double)(scheduledMaps + assignedMaps));
        Resource netScheduledReduceResource = Resources.multiply((Resource)reduceResourceReqt, (double)(scheduledReduces + assignedReduces));
        Resource totalResourceLimit = this.getResourceLimit();
        Resource ideaMapResourceLimit = Resources.subtract((Resource)totalResourceLimit, (Resource)(idealReduceResourceLimit = Resources.multiply((Resource)totalResourceLimit, (double)Math.min(completedMapPercent, maxReduceRampupLimit))));
        if (ResourceCalculatorUtils.computeAvailableContainers(ideaMapResourceLimit, mapResourceReqt, this.getSchedulerResourceTypes()) >= scheduledMaps + assignedMaps) {
            Resource unusedMapResourceLimit = Resources.subtract((Resource)ideaMapResourceLimit, (Resource)netScheduledMapResource);
            finalReduceResourceLimit = Resources.add((Resource)idealReduceResourceLimit, (Resource)unusedMapResourceLimit);
            finalMapResourceLimit = Resources.subtract((Resource)totalResourceLimit, (Resource)finalReduceResourceLimit);
        } else {
            finalMapResourceLimit = ideaMapResourceLimit;
            finalReduceResourceLimit = idealReduceResourceLimit;
        }
        LOG.info((Object)("completedMapPercent " + completedMapPercent + " totalResourceLimit:" + totalResourceLimit + " finalMapResourceLimit:" + finalMapResourceLimit + " finalReduceResourceLimit:" + finalReduceResourceLimit + " netScheduledMapResource:" + netScheduledMapResource + " netScheduledReduceResource:" + netScheduledReduceResource));
        int rampUp = ResourceCalculatorUtils.computeAvailableContainers(Resources.subtract((Resource)finalReduceResourceLimit, (Resource)netScheduledReduceResource), reduceResourceReqt, this.getSchedulerResourceTypes());
        if (rampUp > 0) {
            rampUp = Math.min(rampUp, numPendingReduces);
            LOG.info((Object)("Ramping up " + rampUp));
            this.rampUpReduces(rampUp);
        } else if (rampUp < 0) {
            int rampDown = -1 * rampUp;
            rampDown = Math.min(rampDown, scheduledReduces);
            LOG.info((Object)("Ramping down " + rampDown));
            this.rampDownReduces(rampDown);
        }
    }

    @InterfaceAudience.Private
    public void scheduleAllReduces() {
        for (RMContainerRequestor.ContainerRequest req : this.pendingReduces) {
            this.scheduledRequests.addReduce(req);
        }
        this.pendingReduces.clear();
    }

    @InterfaceAudience.Private
    public void rampUpReduces(int rampUp) {
        for (int i = 0; i < rampUp; ++i) {
            RMContainerRequestor.ContainerRequest request = this.pendingReduces.removeFirst();
            this.scheduledRequests.addReduce(request);
        }
    }

    @InterfaceAudience.Private
    public void rampDownReduces(int rampDown) {
        for (int i = 0; i < rampDown; ++i) {
            RMContainerRequestor.ContainerRequest request = this.scheduledRequests.removeReduce();
            this.pendingReduces.add(request);
        }
    }

    private List<Container> getResources() throws Exception {
        AllocateResponse response;
        this.applyConcurrentTaskLimits();
        Resource headRoom = this.getAvailableResources() == null ? Resources.none() : Resources.clone((Resource)this.getAvailableResources());
        try {
            response = this.makeRemoteRequest();
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
            throw new YarnRuntimeException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationAttemptId(), (Throwable)e);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.info((Object)"ApplicationMaster is out of sync with ResourceManager, hence resync and send outstanding requests.");
            this.lastResponseID = 0;
            this.register();
            this.addOutstandingRequestOnResync();
            return null;
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
                throw new YarnRuntimeException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        Resource newHeadRoom = this.getAvailableResources() == null ? Resources.none() : this.getAvailableResources();
        List newContainers = response.getAllocatedContainers();
        if (response.getNMTokens() != null) {
            for (NMToken nmToken : response.getNMTokens()) {
                NMTokenCache.setNMToken((String)nmToken.getNodeId().toString(), (org.apache.hadoop.yarn.api.records.Token)nmToken.getToken());
            }
        }
        if (response.getAMRMToken() != null) {
            this.updateAMRMToken(response.getAMRMToken());
        }
        List finishedContainers = response.getCompletedContainersStatuses();
        if (newContainers.size() + finishedContainers.size() > 0 || !headRoom.equals((Object)newHeadRoom)) {
            this.recalculateReduceSchedule = true;
            if (LOG.isDebugEnabled() && !headRoom.equals((Object)newHeadRoom)) {
                LOG.debug((Object)("headroom=" + newHeadRoom));
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Container cont : newContainers) {
                LOG.debug((Object)("Received new Container :" + cont));
            }
        }
        this.computeIgnoreBlacklisting();
        this.handleUpdatedNodes(response);
        for (Container cont : finishedContainers) {
            LOG.info((Object)("Received completed container " + cont.getContainerId()));
            TaskAttemptId attemptID = this.assignedRequests.get(cont.getContainerId());
            if (attemptID == null) {
                LOG.error((Object)("Container complete event for unknown container id " + cont.getContainerId()));
                continue;
            }
            this.pendingRelease.remove(cont.getContainerId());
            this.assignedRequests.remove(attemptID);
            this.eventHandler.handle((Event)this.createContainerFinishedEvent((ContainerStatus)cont, attemptID));
            String diagnostics = StringInterner.weakIntern((String)cont.getDiagnostics());
            this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnostics));
        }
        return newContainers;
    }

    private void applyConcurrentTaskLimits() {
        int numScheduledMaps = this.scheduledRequests.maps.size();
        if (this.maxRunningMaps > 0 && numScheduledMaps > 0) {
            int maxRequestedMaps = Math.max(0, this.maxRunningMaps - this.assignedRequests.maps.size());
            int numScheduledFailMaps = this.scheduledRequests.earlierFailedMaps.size();
            int failedMapRequestLimit = Math.min(maxRequestedMaps, numScheduledFailMaps);
            int normalMapRequestLimit = Math.min(maxRequestedMaps - failedMapRequestLimit, numScheduledMaps - numScheduledFailMaps);
            this.setRequestLimit(PRIORITY_FAST_FAIL_MAP, this.mapResourceRequest, failedMapRequestLimit);
            this.setRequestLimit(PRIORITY_MAP, this.mapResourceRequest, normalMapRequestLimit);
        }
        int numScheduledReduces = this.scheduledRequests.reduces.size();
        if (this.maxRunningReduces > 0 && numScheduledReduces > 0) {
            int maxRequestedReduces = Math.max(0, this.maxRunningReduces - this.assignedRequests.reduces.size());
            int reduceRequestLimit = Math.min(maxRequestedReduces, numScheduledReduces);
            this.setRequestLimit(PRIORITY_REDUCE, this.reduceResourceRequest, reduceRequestLimit);
        }
    }

    private boolean canAssignMaps() {
        return this.maxRunningMaps <= 0 || this.assignedRequests.maps.size() < this.maxRunningMaps;
    }

    private boolean canAssignReduces() {
        return this.maxRunningReduces <= 0 || this.assignedRequests.reduces.size() < this.maxRunningReduces;
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService((Configuration)this.getConfig()));
    }

    @VisibleForTesting
    public TaskAttemptEvent createContainerFinishedEvent(ContainerStatus cont, TaskAttemptId attemptID) {
        if (cont.getExitStatus() == -100 || cont.getExitStatus() == -102) {
            return new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_KILL);
        }
        return new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_CONTAINER_COMPLETED);
    }

    private void handleUpdatedNodes(AllocateResponse response) {
        List updatedNodes = response.getUpdatedNodes();
        if (!updatedNodes.isEmpty()) {
            this.eventHandler.handle((Event)new JobUpdatedNodesEvent(this.getJob().getID(), updatedNodes));
            HashSet<NodeId> unusableNodes = new HashSet<NodeId>();
            for (NodeReport nr : updatedNodes) {
                NodeState nodeState = nr.getNodeState();
                if (!nodeState.isUnusable()) continue;
                unusableNodes.add(nr.getNodeId());
            }
            for (int i = 0; i < 2; ++i) {
                LinkedHashMap<TaskAttemptId, Container> taskSet = i == 0 ? this.assignedRequests.maps : this.assignedRequests.reduces;
                for (Map.Entry entry : ((HashMap)taskSet).entrySet()) {
                    TaskAttemptId tid = (TaskAttemptId)entry.getKey();
                    NodeId taskAttemptNodeId = ((Container)entry.getValue()).getNodeId();
                    if (!unusableNodes.contains(taskAttemptNodeId)) continue;
                    LOG.info((Object)("Killing taskAttempt:" + tid + " because it is running on unusable node:" + taskAttemptNodeId));
                    this.eventHandler.handle((Event)new TaskAttemptKillEvent(tid, "TaskAttempt killed because it ran on unusable node" + taskAttemptNodeId));
                }
            }
        }
    }

    @InterfaceAudience.Private
    public Resource getResourceLimit() {
        Resource headRoom = this.getAvailableResources();
        if (headRoom == null) {
            headRoom = Resources.none();
        }
        Resource assignedMapResource = Resources.multiply((Resource)this.mapResourceRequest, (double)this.assignedRequests.maps.size());
        Resource assignedReduceResource = Resources.multiply((Resource)this.reduceResourceRequest, (double)this.assignedRequests.reduces.size());
        return Resources.add((Resource)headRoom, (Resource)Resources.add((Resource)assignedMapResource, (Resource)assignedReduceResource));
    }

    static {
        PRIORITY_FAST_FAIL_MAP.setPriority(5);
        PRIORITY_REDUCE = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_REDUCE.setPriority(10);
        PRIORITY_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_MAP.setPriority(20);
    }

    private class ScheduleStats {
        int numPendingReduces;
        int numScheduledMaps;
        int numScheduledReduces;
        int numAssignedMaps;
        int numAssignedReduces;
        int numCompletedMaps;
        int numCompletedReduces;
        int numContainersAllocated;
        int numContainersReleased;

        private ScheduleStats() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAndLogIfChanged(String msgPrefix) {
            boolean bl;
            boolean changed = false;
            RMContainerAllocator rMContainerAllocator = RMContainerAllocator.this;
            synchronized (rMContainerAllocator) {
                changed |= this.numPendingReduces != RMContainerAllocator.this.pendingReduces.size();
                this.numPendingReduces = RMContainerAllocator.this.pendingReduces.size();
                changed |= this.numScheduledMaps != ((RMContainerAllocator)RMContainerAllocator.this).scheduledRequests.maps.size();
                this.numScheduledMaps = ((RMContainerAllocator)RMContainerAllocator.this).scheduledRequests.maps.size();
                changed |= this.numScheduledReduces != RMContainerAllocator.this.scheduledRequests.reduces.size();
                this.numScheduledReduces = RMContainerAllocator.this.scheduledRequests.reduces.size();
                changed |= this.numAssignedMaps != RMContainerAllocator.this.assignedRequests.maps.size();
                this.numAssignedMaps = RMContainerAllocator.this.assignedRequests.maps.size();
                changed |= this.numAssignedReduces != ((RMContainerAllocator)RMContainerAllocator.this).assignedRequests.reduces.size();
                this.numAssignedReduces = ((RMContainerAllocator)RMContainerAllocator.this).assignedRequests.reduces.size();
                changed |= this.numCompletedMaps != RMContainerAllocator.this.getJob().getCompletedMaps();
                this.numCompletedMaps = RMContainerAllocator.this.getJob().getCompletedMaps();
                changed |= this.numCompletedReduces != RMContainerAllocator.this.getJob().getCompletedReduces();
                this.numCompletedReduces = RMContainerAllocator.this.getJob().getCompletedReduces();
                changed |= this.numContainersAllocated != RMContainerAllocator.this.containersAllocated;
                this.numContainersAllocated = RMContainerAllocator.this.containersAllocated;
                bl = this.numContainersReleased != RMContainerAllocator.this.containersReleased;
                this.numContainersReleased = RMContainerAllocator.this.containersReleased;
            }
            if (changed |= bl) {
                this.log(msgPrefix);
            }
        }

        public void log(String msgPrefix) {
            LOG.info((Object)(msgPrefix + "PendingReds:" + this.numPendingReduces + " ScheduledMaps:" + this.numScheduledMaps + " ScheduledReds:" + this.numScheduledReduces + " AssignedMaps:" + this.numAssignedMaps + " AssignedReds:" + this.numAssignedReduces + " CompletedMaps:" + this.numCompletedMaps + " CompletedReds:" + this.numCompletedReduces + " ContAlloc:" + this.numContainersAllocated + " ContRel:" + this.numContainersReleased + " HostLocal:" + RMContainerAllocator.this.hostLocalAssigned + " RackLocal:" + RMContainerAllocator.this.rackLocalAssigned));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    class AssignedRequests {
        private final Map<ContainerId, TaskAttemptId> containerToAttemptMap = new HashMap<ContainerId, TaskAttemptId>();
        private final LinkedHashMap<TaskAttemptId, Container> maps = new LinkedHashMap();
        @VisibleForTesting
        final LinkedHashMap<TaskAttemptId, Container> reduces = new LinkedHashMap();
        @VisibleForTesting
        final Set<TaskAttemptId> preemptionWaitingReduces = new HashSet<TaskAttemptId>();

        AssignedRequests() {
        }

        void add(Container container, TaskAttemptId tId) {
            LOG.info((Object)("Assigned container " + container.getId().toString() + " to " + tId));
            this.containerToAttemptMap.put(container.getId(), tId);
            if (tId.getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                this.maps.put(tId, container);
            } else {
                this.reduces.put(tId, container);
            }
        }

        void preemptReduce(int toPreempt) {
            ArrayList<TaskAttemptId> reduceList = new ArrayList<TaskAttemptId>(this.reduces.keySet());
            Collections.sort(reduceList, new Comparator<TaskAttemptId>(){

                @Override
                public int compare(TaskAttemptId o1, TaskAttemptId o2) {
                    return Float.compare(RMContainerAllocator.this.getJob().getTask(o1.getTaskId()).getAttempt(o1).getProgress(), RMContainerAllocator.this.getJob().getTask(o2.getTaskId()).getAttempt(o2).getProgress());
                }
            });
            for (int i = 0; i < toPreempt && reduceList.size() > 0; ++i) {
                TaskAttemptId id = (TaskAttemptId)reduceList.remove(0);
                LOG.info((Object)("Preempting " + id));
                this.preemptionWaitingReduces.add(id);
                RMContainerAllocator.this.eventHandler.handle((Event)new TaskAttemptKillEvent(id, RMContainerAllocator.RAMPDOWN_DIAGNOSTIC));
            }
        }

        boolean remove(TaskAttemptId tId) {
            ContainerId containerId = null;
            if (tId.getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                containerId = ((Container)this.maps.remove(tId)).getId();
            } else {
                boolean preempted;
                containerId = ((Container)this.reduces.remove(tId)).getId();
                if (containerId != null && (preempted = this.preemptionWaitingReduces.remove(tId))) {
                    LOG.info((Object)("Reduce preemption successful " + tId));
                }
            }
            if (containerId != null) {
                this.containerToAttemptMap.remove(containerId);
                return true;
            }
            return false;
        }

        TaskAttemptId get(ContainerId cId) {
            return this.containerToAttemptMap.get(cId);
        }

        ContainerId get(TaskAttemptId tId) {
            Container taskContainer = tId.getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP) ? this.maps.get(tId) : this.reduces.get(tId);
            if (taskContainer == null) {
                return null;
            }
            return taskContainer.getId();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    class ScheduledRequests {
        private final LinkedList<TaskAttemptId> earlierFailedMaps = new LinkedList();
        private final Map<String, LinkedList<TaskAttemptId>> mapsHostMapping = new HashMap<String, LinkedList<TaskAttemptId>>();
        private final Map<String, LinkedList<TaskAttemptId>> mapsRackMapping = new HashMap<String, LinkedList<TaskAttemptId>>();
        @VisibleForTesting
        final Map<TaskAttemptId, RMContainerRequestor.ContainerRequest> maps = new LinkedHashMap<TaskAttemptId, RMContainerRequestor.ContainerRequest>();
        private final LinkedHashMap<TaskAttemptId, RMContainerRequestor.ContainerRequest> reduces = new LinkedHashMap();

        ScheduledRequests() {
        }

        boolean remove(TaskAttemptId tId) {
            RMContainerRequestor.ContainerRequest req = null;
            req = tId.getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP) ? this.maps.remove(tId) : (RMContainerRequestor.ContainerRequest)this.reduces.remove(tId);
            if (req == null) {
                return false;
            }
            RMContainerAllocator.this.decContainerReq(req);
            return true;
        }

        RMContainerRequestor.ContainerRequest removeReduce() {
            Iterator<Map.Entry<TaskAttemptId, RMContainerRequestor.ContainerRequest>> it = this.reduces.entrySet().iterator();
            if (it.hasNext()) {
                Map.Entry<TaskAttemptId, RMContainerRequestor.ContainerRequest> entry = it.next();
                it.remove();
                RMContainerAllocator.this.decContainerReq(entry.getValue());
                return entry.getValue();
            }
            return null;
        }

        void addMap(ContainerRequestEvent event) {
            RMContainerRequestor.ContainerRequest request = null;
            if (event.getEarlierAttemptFailed()) {
                this.earlierFailedMaps.add(event.getAttemptID());
                request = new RMContainerRequestor.ContainerRequest(event, PRIORITY_FAST_FAIL_MAP);
                LOG.info((Object)("Added " + event.getAttemptID() + " to list of failed maps"));
            } else {
                LinkedList<Object> list;
                for (String host : event.getHosts()) {
                    list = this.mapsHostMapping.get(host);
                    if (list == null) {
                        list = new LinkedList();
                        this.mapsHostMapping.put(host, list);
                    }
                    list.add(event.getAttemptID());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Added attempt req to host " + host));
                }
                for (String rack : event.getRacks()) {
                    list = this.mapsRackMapping.get(rack);
                    if (list == null) {
                        list = new LinkedList();
                        this.mapsRackMapping.put(rack, list);
                    }
                    list.add(event.getAttemptID());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Added attempt req to rack " + rack));
                }
                request = new RMContainerRequestor.ContainerRequest(event, PRIORITY_MAP);
            }
            this.maps.put(event.getAttemptID(), request);
            RMContainerAllocator.this.addContainerReq(request);
        }

        void addReduce(RMContainerRequestor.ContainerRequest req) {
            this.reduces.put(req.attemptID, req);
            RMContainerAllocator.this.addContainerReq(req);
        }

        private void assign(List<Container> allocatedContainers) {
            Iterator<Container> it = allocatedContainers.iterator();
            LOG.info((Object)("Got allocated containers " + allocatedContainers.size()));
            RMContainerAllocator.this.containersAllocated = RMContainerAllocator.this.containersAllocated + allocatedContainers.size();
            while (it.hasNext()) {
                Container allocated = it.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Assigning container " + allocated.getId() + " with priority " + allocated.getPriority() + " to NM " + allocated.getNodeId()));
                }
                boolean isAssignable = true;
                Priority priority = allocated.getPriority();
                Resource allocatedResource = allocated.getResource();
                if (PRIORITY_FAST_FAIL_MAP.equals((Object)priority) || PRIORITY_MAP.equals((Object)priority)) {
                    if (ResourceCalculatorUtils.computeAvailableContainers(allocatedResource, RMContainerAllocator.this.mapResourceRequest, RMContainerAllocator.this.getSchedulerResourceTypes()) <= 0 || this.maps.isEmpty()) {
                        LOG.info((Object)("Cannot assign container " + allocated + " for a map as either " + " container memory less than required " + RMContainerAllocator.this.mapResourceRequest + " or no pending map tasks - maps.isEmpty=" + this.maps.isEmpty()));
                        isAssignable = false;
                    }
                } else if (PRIORITY_REDUCE.equals((Object)priority)) {
                    if (ResourceCalculatorUtils.computeAvailableContainers(allocatedResource, RMContainerAllocator.this.reduceResourceRequest, RMContainerAllocator.this.getSchedulerResourceTypes()) <= 0 || this.reduces.isEmpty()) {
                        LOG.info((Object)("Cannot assign container " + allocated + " for a reduce as either " + " container memory less than required " + RMContainerAllocator.this.reduceResourceRequest + " or no pending reduce tasks - reduces.isEmpty=" + this.reduces.isEmpty()));
                        isAssignable = false;
                    }
                } else {
                    LOG.warn((Object)("Container allocated at unwanted priority: " + priority + ". Returning to RM..."));
                    isAssignable = false;
                }
                if (!isAssignable) {
                    this.containerNotAssigned(allocated);
                    it.remove();
                    continue;
                }
                String allocatedHost = allocated.getNodeId().getHost();
                if (!RMContainerAllocator.this.isNodeBlacklisted(allocatedHost)) continue;
                LOG.info((Object)("Got allocated container on a blacklisted  host " + allocatedHost + ". Releasing container " + allocated));
                RMContainerRequestor.ContainerRequest toBeReplacedReq = this.getContainerReqToReplace(allocated);
                if (toBeReplacedReq != null) {
                    LOG.info((Object)("Placing a new container request for task attempt " + toBeReplacedReq.attemptID));
                    RMContainerRequestor.ContainerRequest newReq = RMContainerAllocator.this.getFilteredContainerRequest(toBeReplacedReq);
                    RMContainerAllocator.this.decContainerReq(toBeReplacedReq);
                    if (toBeReplacedReq.attemptID.getTaskId().getTaskType() == org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP) {
                        this.maps.put(newReq.attemptID, newReq);
                    } else {
                        this.reduces.put(newReq.attemptID, newReq);
                    }
                    RMContainerAllocator.this.addContainerReq(newReq);
                } else {
                    LOG.info((Object)("Could not map allocated container to a valid request. Releasing allocated container " + allocated));
                }
                this.containerNotAssigned(allocated);
                it.remove();
            }
            this.assignContainers(allocatedContainers);
            for (Container allocated : allocatedContainers) {
                LOG.info((Object)("Releasing unassigned container " + allocated));
                this.containerNotAssigned(allocated);
            }
        }

        private void containerAssigned(Container allocated, RMContainerRequestor.ContainerRequest assigned) {
            RMContainerAllocator.this.decContainerReq(assigned);
            RMContainerAllocator.this.eventHandler.handle((Event)new TaskAttemptContainerAssignedEvent(assigned.attemptID, allocated, RMContainerAllocator.this.applicationACLs));
            RMContainerAllocator.this.assignedRequests.add(allocated, assigned.attemptID);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Assigned container (" + allocated + ") " + " to task " + assigned.attemptID + " on node " + allocated.getNodeId().toString()));
            }
        }

        private void containerNotAssigned(Container allocated) {
            RMContainerAllocator.this.containersReleased++;
            RMContainerAllocator.this.pendingRelease.add(allocated.getId());
            RMContainerAllocator.this.release(allocated.getId());
        }

        private RMContainerRequestor.ContainerRequest assignWithoutLocality(Container allocated) {
            RMContainerRequestor.ContainerRequest assigned = null;
            Priority priority = allocated.getPriority();
            if (PRIORITY_FAST_FAIL_MAP.equals((Object)priority)) {
                LOG.info((Object)("Assigning container " + allocated + " to fast fail map"));
                assigned = this.assignToFailedMap(allocated);
            } else if (PRIORITY_REDUCE.equals((Object)priority)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Assigning container " + allocated + " to reduce"));
                }
                assigned = this.assignToReduce(allocated);
            }
            return assigned;
        }

        private void assignContainers(List<Container> allocatedContainers) {
            Iterator<Container> it = allocatedContainers.iterator();
            while (it.hasNext()) {
                Container allocated = it.next();
                RMContainerRequestor.ContainerRequest assigned = this.assignWithoutLocality(allocated);
                if (assigned == null) continue;
                this.containerAssigned(allocated, assigned);
                it.remove();
            }
            this.assignMapsWithLocality(allocatedContainers);
        }

        private RMContainerRequestor.ContainerRequest getContainerReqToReplace(Container allocated) {
            LOG.info((Object)("Finding containerReq for allocated container: " + allocated));
            Priority priority = allocated.getPriority();
            RMContainerRequestor.ContainerRequest toBeReplaced = null;
            if (PRIORITY_FAST_FAIL_MAP.equals((Object)priority)) {
                LOG.info((Object)("Replacing FAST_FAIL_MAP container " + allocated.getId()));
                Iterator iter = this.earlierFailedMaps.iterator();
                while (toBeReplaced == null && iter.hasNext()) {
                    toBeReplaced = this.maps.get(iter.next());
                }
                LOG.info((Object)("Found replacement: " + toBeReplaced));
                return toBeReplaced;
            }
            if (PRIORITY_MAP.equals((Object)priority)) {
                LOG.info((Object)("Replacing MAP container " + allocated.getId()));
                String host = allocated.getNodeId().getHost();
                LinkedList<TaskAttemptId> list = this.mapsHostMapping.get(host);
                if (list != null && list.size() > 0) {
                    TaskAttemptId tId = list.removeLast();
                    if (this.maps.containsKey(tId)) {
                        toBeReplaced = this.maps.remove(tId);
                    }
                } else {
                    TaskAttemptId tId = this.maps.keySet().iterator().next();
                    toBeReplaced = this.maps.remove(tId);
                }
            } else if (PRIORITY_REDUCE.equals((Object)priority)) {
                TaskAttemptId tId = this.reduces.keySet().iterator().next();
                toBeReplaced = (RMContainerRequestor.ContainerRequest)this.reduces.remove(tId);
            }
            LOG.info((Object)("Found replacement: " + toBeReplaced));
            return toBeReplaced;
        }

        private RMContainerRequestor.ContainerRequest assignToFailedMap(Container allocated) {
            RMContainerRequestor.ContainerRequest assigned = null;
            while (assigned == null && this.earlierFailedMaps.size() > 0 && RMContainerAllocator.this.canAssignMaps()) {
                TaskAttemptId tId = this.earlierFailedMaps.removeFirst();
                if (!this.maps.containsKey(tId)) continue;
                assigned = this.maps.remove(tId);
                JobCounterUpdateEvent jce = new JobCounterUpdateEvent(assigned.attemptID.getTaskId().getJobId());
                jce.addCounterUpdate((Enum<?>)JobCounter.OTHER_LOCAL_MAPS, 1L);
                RMContainerAllocator.this.eventHandler.handle((Event)jce);
                LOG.info((Object)"Assigned from earlierFailedMaps");
                break;
            }
            return assigned;
        }

        private RMContainerRequestor.ContainerRequest assignToReduce(Container allocated) {
            RMContainerRequestor.ContainerRequest assigned = null;
            if (assigned == null && this.reduces.size() > 0 && RMContainerAllocator.this.canAssignReduces()) {
                TaskAttemptId tId = this.reduces.keySet().iterator().next();
                assigned = (RMContainerRequestor.ContainerRequest)this.reduces.remove(tId);
                LOG.info((Object)"Assigned to reduce");
            }
            return assigned;
        }

        private void assignMapsWithLocality(List<Container> allocatedContainers) {
            String host;
            Priority priority;
            Container allocated;
            Iterator<Container> it = allocatedContainers.iterator();
            block0: while (it.hasNext() && this.maps.size() > 0 && RMContainerAllocator.this.canAssignMaps()) {
                allocated = it.next();
                priority = allocated.getPriority();
                assert (PRIORITY_MAP.equals((Object)priority));
                host = allocated.getNodeId().getHost();
                LinkedList<TaskAttemptId> list = this.mapsHostMapping.get(host);
                while (list != null && list.size() > 0) {
                    TaskAttemptId tId;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Host matched to the request list " + host));
                    }
                    if (!this.maps.containsKey(tId = list.removeFirst())) continue;
                    RMContainerRequestor.ContainerRequest assigned = this.maps.remove(tId);
                    this.containerAssigned(allocated, assigned);
                    it.remove();
                    JobCounterUpdateEvent jce = new JobCounterUpdateEvent(assigned.attemptID.getTaskId().getJobId());
                    jce.addCounterUpdate((Enum<?>)JobCounter.DATA_LOCAL_MAPS, 1L);
                    RMContainerAllocator.this.eventHandler.handle((Event)jce);
                    RMContainerAllocator.this.hostLocalAssigned++;
                    if (!LOG.isDebugEnabled()) continue block0;
                    LOG.debug((Object)("Assigned based on host match " + host));
                    continue block0;
                }
            }
            it = allocatedContainers.iterator();
            block2: while (it.hasNext() && this.maps.size() > 0 && RMContainerAllocator.this.canAssignMaps()) {
                allocated = it.next();
                priority = allocated.getPriority();
                assert (PRIORITY_MAP.equals((Object)priority));
                host = allocated.getNodeId().getHost();
                String rack = RackResolver.resolve((String)host).getNetworkLocation();
                LinkedList<TaskAttemptId> list = this.mapsRackMapping.get(rack);
                while (list != null && list.size() > 0) {
                    TaskAttemptId tId = list.removeFirst();
                    if (!this.maps.containsKey(tId)) continue;
                    RMContainerRequestor.ContainerRequest assigned = this.maps.remove(tId);
                    this.containerAssigned(allocated, assigned);
                    it.remove();
                    JobCounterUpdateEvent jce = new JobCounterUpdateEvent(assigned.attemptID.getTaskId().getJobId());
                    jce.addCounterUpdate((Enum<?>)JobCounter.RACK_LOCAL_MAPS, 1L);
                    RMContainerAllocator.this.eventHandler.handle((Event)jce);
                    RMContainerAllocator.this.rackLocalAssigned++;
                    if (!LOG.isDebugEnabled()) continue block2;
                    LOG.debug((Object)("Assigned based on rack match " + rack));
                    continue block2;
                }
            }
            it = allocatedContainers.iterator();
            while (it.hasNext() && this.maps.size() > 0 && RMContainerAllocator.this.canAssignMaps()) {
                allocated = it.next();
                priority = allocated.getPriority();
                assert (PRIORITY_MAP.equals((Object)priority));
                TaskAttemptId tId = this.maps.keySet().iterator().next();
                RMContainerRequestor.ContainerRequest assigned = this.maps.remove(tId);
                this.containerAssigned(allocated, assigned);
                it.remove();
                JobCounterUpdateEvent jce = new JobCounterUpdateEvent(assigned.attemptID.getTaskId().getJobId());
                jce.addCounterUpdate((Enum<?>)JobCounter.OTHER_LOCAL_MAPS, 1L);
                RMContainerAllocator.this.eventHandler.handle((Event)jce);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Assigned based on * match");
            }
        }
    }
}

