/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.util.Records;

public class MockJobs
extends MockApps {
    static final Iterator<JobState> JOB_STATES = Iterators.cycle((Object[])JobState.values());
    static final Iterator<TaskState> TASK_STATES = Iterators.cycle((Object[])TaskState.values());
    static final Iterator<TaskAttemptState> TASK_ATTEMPT_STATES = Iterators.cycle((Object[])TaskAttemptState.values());
    static final Iterator<TaskType> TASK_TYPES = Iterators.cycle((Object[])TaskType.values());
    static final Iterator<JobCounter> JOB_COUNTERS = Iterators.cycle((Object[])JobCounter.values());
    static final Iterator<FileSystemCounter> FS_COUNTERS = Iterators.cycle((Object[])FileSystemCounter.values());
    static final Iterator<TaskCounter> TASK_COUNTERS = Iterators.cycle((Object[])TaskCounter.values());
    static final Iterator<String> FS_SCHEMES = Iterators.cycle((Object[])new String[]{"FILE", "HDFS", "LAFS", "CEPH"});
    static final Iterator<String> USER_COUNTER_GROUPS = Iterators.cycle((Object[])new String[]{"com.company.project.subproject.component.subcomponent.UserDefinedSpecificSpecialTask$Counters", "PigCounters"});
    static final Iterator<String> USER_COUNTERS = Iterators.cycle((Object[])new String[]{"counter1", "counter2", "counter3"});
    static final Iterator<Phase> PHASES = Iterators.cycle((Object[])Phase.values());
    static final Iterator<String> DIAGS = Iterators.cycle((Object[])new String[]{"Error: java.lang.OutOfMemoryError: Java heap space", "Lost task tracker: tasktracker.domain/127.0.0.1:40879"});
    public static final String NM_HOST = "localhost";
    public static final int NM_PORT = 1234;
    public static final int NM_HTTP_PORT = 8042;
    static final int DT = 1000000;

    public static String newJobName() {
        return MockJobs.newAppName();
    }

    public static Map<JobId, Job> newJobs(int numJobs, int numTasksPerJob, int numAttemptsPerTask) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobs; ++j) {
            ApplicationId appID = MockJobs.newAppID((int)j);
            Job job = MockJobs.newJob(appID, j, numTasksPerJob, numAttemptsPerTask);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static Map<JobId, Job> newJobs(ApplicationId appID, int numJobsPerApp, int numTasksPerJob, int numAttemptsPerTask) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobsPerApp; ++j) {
            Job job = MockJobs.newJob(appID, j, numTasksPerJob, numAttemptsPerTask);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static Map<JobId, Job> newJobs(ApplicationId appID, int numJobsPerApp, int numTasksPerJob, int numAttemptsPerTask, boolean hasFailedTasks) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobsPerApp; ++j) {
            Job job = MockJobs.newJob(appID, j, numTasksPerJob, numAttemptsPerTask, null, hasFailedTasks);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static JobId newJobID(ApplicationId appID, int i) {
        JobId id = (JobId)Records.newRecord(JobId.class);
        id.setAppId(appID);
        id.setId(i);
        return id;
    }

    public static JobReport newJobReport(JobId id) {
        JobReport report = (JobReport)Records.newRecord(JobReport.class);
        report.setJobId(id);
        report.setSubmitTime(System.currentTimeMillis() - 1000000L);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        report.setMapProgress((float)Math.random());
        report.setReduceProgress((float)Math.random());
        report.setJobState(JOB_STATES.next());
        return report;
    }

    public static TaskReport newTaskReport(TaskId id) {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        report.setTaskId(id);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        report.setProgress((float)Math.random());
        report.setStatus("Moving average: " + Math.random());
        report.setCounters(TypeConverter.toYarn((Counters)MockJobs.newCounters()));
        report.setTaskState(TASK_STATES.next());
        return report;
    }

    public static TaskAttemptReport newTaskAttemptReport(TaskAttemptId id) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)id.getTaskId().getJobId().getAppId(), (int)0);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        report.setTaskAttemptId(id);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        if (id.getTaskId().getTaskType() == TaskType.REDUCE) {
            report.setShuffleFinishTime((report.getFinishTime() + report.getStartTime()) / 2L);
            report.setSortFinishTime((report.getFinishTime() + report.getShuffleFinishTime()) / 2L);
        }
        report.setPhase(PHASES.next());
        report.setTaskAttemptState(TASK_ATTEMPT_STATES.next());
        report.setProgress((float)Math.random());
        report.setCounters(TypeConverter.toYarn((Counters)MockJobs.newCounters()));
        report.setContainerId(containerId);
        report.setDiagnosticInfo(DIAGS.next());
        report.setStateString("Moving average " + Math.random());
        return report;
    }

    public static Counters newCounters() {
        int i;
        Counters hc = new Counters();
        for (JobCounter jobCounter : JobCounter.values()) {
            hc.findCounter((Enum)jobCounter).setValue((long)(Math.random() * 1000.0));
        }
        for (JobCounter jobCounter : TaskCounter.values()) {
            hc.findCounter((Enum)jobCounter).setValue((long)(Math.random() * 1000.0));
        }
        int nc = FileSystemCounter.values().length * 4;
        for (i = 0; i < nc; ++i) {
            for (FileSystemCounter c : FileSystemCounter.values()) {
                hc.findCounter(FS_SCHEMES.next(), c).setValue((long)(Math.random() * 1000000.0));
            }
        }
        for (i = 0; i < 6; ++i) {
            hc.findCounter(USER_COUNTER_GROUPS.next(), USER_COUNTERS.next()).setValue((long)(Math.random() * 100000.0));
        }
        return hc;
    }

    public static Map<TaskAttemptId, TaskAttempt> newTaskAttempts(TaskId tid, int m) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < m; ++i) {
            TaskAttempt ta = MockJobs.newTaskAttempt(tid, i);
            map.put(ta.getID(), ta);
        }
        return map;
    }

    public static TaskAttempt newTaskAttempt(TaskId tid, int i) {
        final TaskAttemptId taid = (TaskAttemptId)Records.newRecord(TaskAttemptId.class);
        taid.setTaskId(tid);
        taid.setId(i);
        final TaskAttemptReport report = MockJobs.newTaskAttemptReport(taid);
        return new TaskAttempt(){

            public NodeId getNodeId() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public TaskAttemptId getID() {
                return taid;
            }

            public TaskAttemptReport getReport() {
                return report;
            }

            public long getLaunchTime() {
                return report.getStartTime();
            }

            public long getFinishTime() {
                return report.getFinishTime();
            }

            public int getShufflePort() {
                return 13562;
            }

            public Counters getCounters() {
                if (report != null && report.getCounters() != null) {
                    return new Counters((AbstractCounters)TypeConverter.fromYarn((org.apache.hadoop.mapreduce.v2.api.records.Counters)report.getCounters()));
                }
                return null;
            }

            public float getProgress() {
                return report.getProgress();
            }

            public Phase getPhase() {
                return report.getPhase();
            }

            public TaskAttemptState getState() {
                return report.getTaskAttemptState();
            }

            public boolean isFinished() {
                switch (report.getTaskAttemptState()) {
                    case SUCCEEDED: 
                    case FAILED: 
                    case KILLED: {
                        return true;
                    }
                }
                return false;
            }

            public ContainerId getAssignedContainerID() {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)taid.getTaskId().getJobId().getAppId(), (int)0);
                ContainerId id = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
                return id;
            }

            public String getNodeHttpAddress() {
                return "localhost:8042";
            }

            public List<String> getDiagnostics() {
                return Lists.newArrayList((Object[])new String[]{report.getDiagnosticInfo()});
            }

            public String getAssignedContainerMgrAddress() {
                return "localhost:9998";
            }

            public long getShuffleFinishTime() {
                return report.getShuffleFinishTime();
            }

            public long getSortFinishTime() {
                return report.getSortFinishTime();
            }

            public String getNodeRackName() {
                return "/default-rack";
            }
        };
    }

    public static Map<TaskId, Task> newTasks(JobId jid, int n, int m, boolean hasFailedTasks) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < n; ++i) {
            Task task = MockJobs.newTask(jid, i, m, hasFailedTasks);
            map.put(task.getID(), task);
        }
        return map;
    }

    public static Task newTask(JobId jid, int i, int m, final boolean hasFailedTasks) {
        final TaskId tid = (TaskId)Records.newRecord(TaskId.class);
        tid.setJobId(jid);
        tid.setId(i);
        tid.setTaskType(TASK_TYPES.next());
        final TaskReport report = MockJobs.newTaskReport(tid);
        final Map<TaskAttemptId, TaskAttempt> attempts = MockJobs.newTaskAttempts(tid, m);
        return new Task(){

            public TaskId getID() {
                return tid;
            }

            public TaskReport getReport() {
                return report;
            }

            public Counters getCounters() {
                if (hasFailedTasks) {
                    return null;
                }
                return new Counters((AbstractCounters)TypeConverter.fromYarn((org.apache.hadoop.mapreduce.v2.api.records.Counters)report.getCounters()));
            }

            public float getProgress() {
                return report.getProgress();
            }

            public TaskType getType() {
                return tid.getTaskType();
            }

            public Map<TaskAttemptId, TaskAttempt> getAttempts() {
                return attempts;
            }

            public TaskAttempt getAttempt(TaskAttemptId attemptID) {
                return (TaskAttempt)attempts.get(attemptID);
            }

            public boolean isFinished() {
                switch (report.getTaskState()) {
                    case SUCCEEDED: 
                    case KILLED: 
                    case FAILED: {
                        return true;
                    }
                }
                return false;
            }

            public boolean canCommit(TaskAttemptId taskAttemptID) {
                return false;
            }

            public TaskState getState() {
                return report.getTaskState();
            }
        };
    }

    public static Counters getCounters(Collection<Task> tasks) {
        ArrayList<Task> completedTasks = new ArrayList<Task>();
        for (Task task : tasks) {
            if (task.getCounters() == null) continue;
            completedTasks.add(task);
        }
        Counters counters = new Counters();
        return JobImpl.incrTaskCounters((Counters)counters, completedTasks);
    }

    static TaskCount getTaskCount(Collection<Task> tasks) {
        TaskCount tc = new TaskCount();
        for (Task task : tasks) {
            tc.incr(task);
        }
        return tc;
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m) {
        return MockJobs.newJob(appID, i, n, m, null);
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m, Path confFile) {
        return MockJobs.newJob(appID, i, n, m, confFile, false);
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m, Path confFile, boolean hasFailedTasks) {
        final JobId id = MockJobs.newJobID(appID, i);
        final String name = MockJobs.newJobName();
        final JobReport report = MockJobs.newJobReport(id);
        final Map<TaskId, Task> tasks = MockJobs.newTasks(id, n, m, hasFailedTasks);
        final TaskCount taskCount = MockJobs.getTaskCount(tasks.values());
        final Counters counters = MockJobs.getCounters(tasks.values());
        final Path configFile = confFile;
        Map tmpJobACLs = new HashMap();
        final Configuration conf = new Configuration();
        conf.set(JobACL.VIEW_JOB.getAclName(), "testuser");
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        JobACLsManager aclsManager = new JobACLsManager(conf);
        final Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        return new Job(){

            public JobId getID() {
                return id;
            }

            public String getName() {
                return name;
            }

            public JobState getState() {
                return report.getJobState();
            }

            public JobReport getReport() {
                return report;
            }

            public float getProgress() {
                return 0.0f;
            }

            public Counters getAllCounters() {
                return counters;
            }

            public Map<TaskId, Task> getTasks() {
                return tasks;
            }

            public Task getTask(TaskId taskID) {
                return (Task)tasks.get(taskID);
            }

            public int getTotalMaps() {
                return taskCount.maps;
            }

            public int getTotalReduces() {
                return taskCount.reduces;
            }

            public int getCompletedMaps() {
                return taskCount.completedMaps;
            }

            public int getCompletedReduces() {
                return taskCount.completedReduces;
            }

            public boolean isUber() {
                return false;
            }

            public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
                return null;
            }

            public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
                return null;
            }

            public Map<TaskId, Task> getTasks(TaskType taskType) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public List<String> getDiagnostics() {
                return Collections.emptyList();
            }

            public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
                return true;
            }

            public String getUserName() {
                return "mock";
            }

            public String getQueueName() {
                return "mockqueue";
            }

            public Path getConfFile() {
                return configFile;
            }

            public Map<JobACL, AccessControlList> getJobACLs() {
                return jobACLs;
            }

            public List<AMInfo> getAMInfos() {
                LinkedList<AMInfo> amInfoList = new LinkedList<AMInfo>();
                amInfoList.add(MockJobs.createAMInfo(1));
                amInfoList.add(MockJobs.createAMInfo(2));
                return amInfoList;
            }

            public Configuration loadConfFile() throws IOException {
                FileContext fc = FileContext.getFileContext((URI)configFile.toUri(), (Configuration)conf);
                Configuration jobConf = new Configuration(false);
                jobConf.addResource((InputStream)fc.open(configFile), configFile.toString());
                return jobConf;
            }

            public void setQueueName(String queueName) {
            }

            public void setJobPriority(Priority priority) {
            }

            public int getFailedMaps() {
                return 0;
            }

            public int getFailedReduces() {
                return 0;
            }

            public int getKilledMaps() {
                return 0;
            }

            public int getKilledReduces() {
                return 0;
            }
        };
    }

    private static AMInfo createAMInfo(int attempt) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)100L, (int)1), (int)attempt);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        return MRBuilderUtils.newAMInfo((ApplicationAttemptId)appAttemptId, (long)System.currentTimeMillis(), (ContainerId)containerId, (String)NM_HOST, (int)1234, (int)8042);
    }

    static class TaskCount {
        int maps;
        int reduces;
        int completedMaps;
        int completedReduces;

        TaskCount() {
        }

        void incr(Task task) {
            TaskType type = task.getType();
            boolean finished = task.isFinished();
            if (type == TaskType.MAP) {
                if (finished) {
                    ++this.completedMaps;
                }
                ++this.maps;
            } else if (type == TaskType.REDUCE) {
                if (finished) {
                    ++this.completedReduces;
                }
                ++this.reduces;
            }
        }
    }
}

