/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(Table ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
        return protocol;
    }

    public static void grant(Configuration conf, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, tableName, family, qual, actions);
        }
    }

    public static void grant(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void grant(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isAccessControllerRunning(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void revoke(Configuration conf, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), username, tableName, family, qualifier, actions);
        }
    }

    public static void revoke(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void revoke(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static List<UserPermission> getUserPermissions(Configuration conf, String tableRegex) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            List<UserPermission> list = AccessControlClient.getUserPermissions(connection, tableRegex);
            return list;
        }
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex) throws Throwable {
        List<Object> permList = new ArrayList();
        try (Table table = connection.getTable(ACL_TABLE_NAME);
             Admin admin = connection.getAdmin();){
            CoprocessorRpcChannel service = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            HTableDescriptor[] htds = null;
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = ProtobufUtil.getUserPermissions(protocol);
            } else if (tableRegex.charAt(0) == '@') {
                String namespace = tableRegex.substring(1);
                permList = ProtobufUtil.getUserPermissions(protocol, Bytes.toBytes((String)namespace));
            } else {
                for (HTableDescriptor hd : htds = admin.listTables(Pattern.compile(tableRegex), true)) {
                    permList.addAll(ProtobufUtil.getUserPermissions(protocol, hd.getTableName()));
                }
            }
        }
        return permList;
    }
}

