/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncConnectionConfiguration {
    private final long metaOperationTimeoutNs;
    private final long operationTimeoutNs;
    private final long rpcTimeoutNs;
    private final long readRpcTimeoutNs;
    private final long writeRpcTimeoutNs;
    private final long pauseNs;
    private final int maxRetries;
    private final int startLogErrorsCnt;
    private final long scanTimeoutNs;
    private final int scannerCaching;
    private final int metaScannerCaching;
    private final long scannerMaxResultSize;
    private final long writeBufferSize;
    private final long writeBufferPeriodicFlushTimeoutNs;

    AsyncConnectionConfiguration(Configuration conf) {
        this.metaOperationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.meta.operation.timeout", 1200000L));
        this.operationTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.operation.timeout", 1200000L));
        this.rpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.timeout", 60000L));
        this.readRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.read.timeout", this.rpcTimeoutNs));
        this.writeRpcTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.rpc.write.timeout", this.rpcTimeoutNs));
        this.pauseNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.pause", 100L));
        this.maxRetries = conf.getInt("hbase.client.retries.number", 15);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 5);
        this.scanTimeoutNs = TimeUnit.MILLISECONDS.toNanos(HBaseConfiguration.getInt((Configuration)conf, (String)"hbase.client.scanner.timeout.period", (String)"hbase.regionserver.lease.period", (int)60000));
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.metaScannerCaching = conf.getInt("hbase.meta.scanner.caching", 100);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.writeBufferPeriodicFlushTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong("hbase.client.write.buffer.periodicflush.timeout.ms", 0L));
    }

    long getMetaOperationTimeoutNs() {
        return this.metaOperationTimeoutNs;
    }

    long getOperationTimeoutNs() {
        return this.operationTimeoutNs;
    }

    long getRpcTimeoutNs() {
        return this.rpcTimeoutNs;
    }

    long getReadRpcTimeoutNs() {
        return this.readRpcTimeoutNs;
    }

    long getWriteRpcTimeoutNs() {
        return this.writeRpcTimeoutNs;
    }

    long getPauseNs() {
        return this.pauseNs;
    }

    int getMaxRetries() {
        return this.maxRetries;
    }

    int getStartLogErrorsCnt() {
        return this.startLogErrorsCnt;
    }

    long getScanTimeoutNs() {
        return this.scanTimeoutNs;
    }

    int getScannerCaching() {
        return this.scannerCaching;
    }

    int getMetaScannerCaching() {
        return this.metaScannerCaching;
    }

    long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    long getWriteBufferPeriodicFlushTimeoutNs() {
        return this.writeBufferPeriodicFlushTimeoutNs;
    }
}

