/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)VersionInfo.class.getName());
    private static final int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return "2.0.4";
    }

    public static String getRevision() {
        return "205e39c5704bf38568b34926dde9f1ee76e6b5d0";
    }

    public static String getDate() {
        return "Fri Dec 28 22:13:42 PST 2018";
    }

    public static String getUser() {
        return "stack";
    }

    public static String getUrl() {
        return "git://kalashnikov/Users/stack/checkouts/hbase.git";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "e4c8c94ee7e4fea66ab6179e55e073a4";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info(line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        int index;
        if (v1.equals(v2)) {
            return 0;
        }
        Object[] v1Comps = VersionInfo.getVersionComponents(v1);
        Object[] v2Comps = VersionInfo.getVersionComponents(v2);
        for (index = 0; index < v1Comps.length && index < v2Comps.length; ++index) {
            int c;
            int vb;
            int va = v1Comps[index] instanceof Integer ? (Integer)v1Comps[index] : 100000;
            int n = vb = v2Comps[index] instanceof Integer ? (Integer)v2Comps[index] : 100000;
            if (va != vb) {
                return va - vb;
            }
            if (va != 100000 || (c = ((String)v1Comps[index]).compareTo((String)v2Comps[index])) == 0) continue;
            return c;
        }
        if (index < v1Comps.length) {
            return 1;
        }
        return -1;
    }

    static Object[] getVersionComponents(String version) {
        assert (version != null);
        String[] strComps = version.split("[\\.-]");
        assert (strComps.length > 0);
        Object[] comps = new Object[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            try {
                comps[i] = Integer.parseInt(strComps[i]);
                continue;
            }
            catch (NumberFormatException e) {
                comps[i] = strComps[i];
            }
        }
        return comps;
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

