/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.MetricSet;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.metrics.impl.CounterImpl;
import org.apache.hadoop.hbase.metrics.impl.DropwizardMeter;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hadoop.hbase.metrics.impl.TimerImpl;

@InterfaceAudience.Private
public class MetricRegistryImpl
implements MetricRegistry {
    private final MetricRegistryInfo info;
    private final ConcurrentMap<String, Metric> metrics;

    public MetricRegistryImpl(MetricRegistryInfo info) {
        this.info = info;
        this.metrics = new ConcurrentHashMap<String, Metric>();
    }

    public Timer timer(String name) {
        Timer metric = (Timer)this.metrics.get(name);
        if (metric != null) {
            return metric;
        }
        Timer newTimer = this.createTimer();
        metric = (Timer)this.metrics.putIfAbsent(name, (Metric)newTimer);
        if (metric != null) {
            return metric;
        }
        return newTimer;
    }

    protected Timer createTimer() {
        return new TimerImpl();
    }

    public Histogram histogram(String name) {
        Histogram metric = (Histogram)this.metrics.get(name);
        if (metric != null) {
            return metric;
        }
        Histogram newHistogram = this.createHistogram();
        metric = (Histogram)this.metrics.putIfAbsent(name, (Metric)newHistogram);
        if (metric != null) {
            return metric;
        }
        return newHistogram;
    }

    protected Histogram createHistogram() {
        return new HistogramImpl();
    }

    public Meter meter(String name) {
        Meter metric = (Meter)this.metrics.get(name);
        if (metric != null) {
            return metric;
        }
        Meter newmeter = this.createMeter();
        metric = (Meter)this.metrics.putIfAbsent(name, (Metric)newmeter);
        if (metric != null) {
            return metric;
        }
        return newmeter;
    }

    protected Meter createMeter() {
        return new DropwizardMeter();
    }

    public Counter counter(String name) {
        Counter metric = (Counter)this.metrics.get(name);
        if (metric != null) {
            return metric;
        }
        Counter newCounter = this.createCounter();
        metric = (Counter)this.metrics.putIfAbsent(name, (Metric)newCounter);
        if (metric != null) {
            return metric;
        }
        return newCounter;
    }

    protected Counter createCounter() {
        return new CounterImpl();
    }

    public Optional<Metric> get(String name) {
        return Optional.fromNullable(this.metrics.get(name));
    }

    public Metric register(String name, Metric metric) {
        Metric m = (Metric)this.metrics.get(name);
        if (m != null) {
            return m;
        }
        Metric oldMetric = this.metrics.putIfAbsent(name, metric);
        if (oldMetric != null) {
            return oldMetric;
        }
        return metric;
    }

    public <T> Gauge<T> register(String name, Gauge<T> gauge) {
        return (Gauge)this.register(name, (Metric)gauge);
    }

    public void registerAll(MetricSet metricSet) {
        Set entrySet = metricSet.getMetrics().entrySet();
        for (Map.Entry entry : entrySet) {
            this.register((String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public boolean remove(String name) {
        return this.metrics.remove(name) != null;
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }
}

