/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.handler.LogReplayHandler;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ServerShutdownHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(ServerShutdownHandler.class);
    protected final ServerName serverName;
    protected final MasterServices services;
    protected final DeadServer deadServers;
    protected final boolean shouldSplitWal;
    protected final int regionAssignmentWaitTimeout;

    public ServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, boolean shouldSplitWal) {
        this(server, services, deadServers, serverName, EventType.M_SERVER_SHUTDOWN, shouldSplitWal);
    }

    ServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, EventType type, boolean shouldSplitWal) {
        super(server, type);
        this.serverName = serverName;
        this.server = server;
        this.services = services;
        this.deadServers = deadServers;
        if (!this.deadServers.isDeadServer(this.serverName)) {
            LOG.warn((Object)(this.serverName + " is NOT in deadservers; it should be!"));
        }
        this.shouldSplitWal = shouldSplitWal;
        this.regionAssignmentWaitTimeout = server.getConfiguration().getInt("hbase.master.log.replay.wait.region.timeout", 15000);
    }

    @Override
    public String getInformativeName() {
        if (this.serverName != null) {
            return this.getClass().getSimpleName() + " for " + this.serverName;
        }
        return super.getInformativeName();
    }

    boolean isCarryingMeta() {
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.serverName + "-" + this.getSeqid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException {
        boolean hasLogReplayWork = false;
        ServerName serverName = this.serverName;
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            ServerManager serverManager = this.services.getServerManager();
            if (this.isCarryingMeta() || !am.isFailoverCleanupDone()) {
                serverManager.processDeadServer(serverName, this.shouldSplitWal);
                return;
            }
            Set<Object> hris = null;
            while (!this.server.isStopped()) {
                try {
                    this.server.getMetaTableLocator().waitMetaRegionLocation(this.server.getZooKeeper());
                    if (BaseLoadBalancer.tablesOnMaster(this.server.getConfiguration())) {
                        while (!this.server.isStopped() && serverManager.countOfRegionServers() < 2) {
                            Thread.sleep(100L);
                        }
                    }
                    if (this.server.isStopped()) break;
                    if (ConfigUtil.useZKForAssignment(this.server.getConfiguration())) {
                        hris = MetaTableAccessor.getServerUserRegions((Connection)this.server.getConnection(), (ServerName)this.serverName).keySet();
                        break;
                    }
                    hris = am.getRegionStates().getServerRegions(serverName);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Received exception accessing hbase:meta during server shutdown of " + serverName + ", retrying hbase:meta read"), (Throwable)ioe);
                }
            }
            if (this.server.isStopped()) {
                throw new IOException("Server is stopped");
            }
            this.services.getMasterFileSystem().setLogRecoveryMode();
            boolean distributedLogReplay = this.services.getMasterFileSystem().getLogRecoveryMode() == ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY;
            try {
                if (this.shouldSplitWal) {
                    if (distributedLogReplay) {
                        LOG.info((Object)("Mark regions in recovery for crashed server " + serverName + " before assignment; regions=" + hris));
                        MasterFileSystem mfs = this.services.getMasterFileSystem();
                        mfs.prepareLogReplay(serverName, hris);
                    } else {
                        LOG.info((Object)("Splitting logs for " + serverName + " before assignment; region count=" + (hris == null ? 0 : hris.size())));
                        this.services.getMasterFileSystem().splitLog(serverName);
                    }
                    am.getRegionStates().logSplit(serverName);
                } else {
                    LOG.info((Object)("Skipping log splitting for " + serverName));
                }
            }
            catch (IOException ioe) {
                this.resubmit(serverName, ioe);
            }
            List<HRegionInfo> regionsInTransition = am.processServerShutdown(serverName);
            LOG.info((Object)("Reassigning " + (hris == null ? 0 : hris.size()) + " region(s) that " + (serverName == null ? "null" : serverName) + " was carrying (and " + regionsInTransition.size() + " regions(s) that were opening on this server)"));
            ArrayList<HRegionInfo> toAssignRegions = new ArrayList<HRegionInfo>();
            toAssignRegions.addAll(regionsInTransition);
            if (hris != null && !hris.isEmpty()) {
                RegionStates regionStates = am.getRegionStates();
                for (HRegionInfo hRegionInfo : hris) {
                    if (regionsInTransition.contains(hRegionInfo)) continue;
                    String encodedName = hRegionInfo.getEncodedName();
                    Lock lock = am.acquireRegionLock(encodedName);
                    try {
                        RegionState rit = regionStates.getRegionTransitionState(hRegionInfo);
                        if (ServerShutdownHandler.processDeadRegion(hRegionInfo, am)) {
                            ServerName addressFromAM = regionStates.getRegionServerOfRegion(hRegionInfo);
                            if (addressFromAM != null && !addressFromAM.equals((Object)this.serverName)) {
                                LOG.info((Object)("Skip assigning region " + hRegionInfo.getRegionNameAsString() + " because it has been opened in " + addressFromAM.getServerName()));
                                continue;
                            }
                            if (rit != null) {
                                if (rit.getServerName() != null && !rit.isOnServer(serverName)) {
                                    LOG.info((Object)("Skip assigning region in transition on other server" + rit));
                                    continue;
                                }
                                try {
                                    LOG.info((Object)("Reassigning region with rs = " + rit + " and deleting zk node if exists"));
                                    ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)this.services.getZooKeeper(), (HRegionInfo)hRegionInfo);
                                    regionStates.updateRegionState(hRegionInfo, RegionState.State.OFFLINE);
                                }
                                catch (KeeperException ke) {
                                    this.server.abort("Unexpected ZK exception deleting unassigned node " + hRegionInfo, ke);
                                    lock.unlock();
                                    this.deadServers.finish(serverName);
                                    return;
                                }
                            } else if (regionStates.isRegionInState(hRegionInfo, RegionState.State.SPLITTING_NEW, RegionState.State.MERGING_NEW)) {
                                regionStates.updateRegionState(hRegionInfo, RegionState.State.OFFLINE);
                            }
                            toAssignRegions.add(hRegionInfo);
                            continue;
                        }
                        if (rit == null) continue;
                        if ((rit.isPendingCloseOrClosing() || rit.isOffline()) && am.getTableStateManager().isTableState(hRegionInfo.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                            regionStates.updateRegionState(hRegionInfo, RegionState.State.OFFLINE);
                            am.deleteClosingOrClosedNode(hRegionInfo, rit.getServerName());
                            am.offlineDisabledRegion(hRegionInfo);
                            continue;
                        }
                        LOG.warn((Object)("THIS SHOULD NOT HAPPEN: unexpected region in transition " + rit + " not to be assigned by SSH of server " + serverName));
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            try {
                am.assign(toAssignRegions);
            }
            catch (InterruptedException ie) {
                LOG.error((Object)("Caught " + ie + " during round-robin assignment"));
                throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Caught " + ioe + " during region assignment, will retry"));
                serverManager.processDeadServer(serverName, this.shouldSplitWal && distributedLogReplay);
                this.deadServers.finish(serverName);
                return;
            }
            if (this.shouldSplitWal && distributedLogReplay) {
                for (HRegionInfo hri : toAssignRegions) {
                    try {
                        if (am.waitOnRegionToClearRegionsInTransition(hri, this.regionAssignmentWaitTimeout)) continue;
                        LOG.warn((Object)("Region " + hri.getEncodedName() + " didn't complete assignment in time"));
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException("Caught " + interruptedException + " during waitOnRegionToClearRegionsInTransition");
                    }
                }
                this.services.getExecutorService().submit(new LogReplayHandler(this.server, this.services, this.deadServers, this.serverName));
                hasLogReplayWork = true;
            }
        }
        finally {
            this.deadServers.finish(serverName);
        }
        if (!hasLogReplayWork) {
            LOG.info((Object)("Finished processing of shutdown of " + serverName));
        }
    }

    private void resubmit(ServerName serverName, IOException ex) throws IOException {
        this.services.getExecutorService().submit(this);
        this.deadServers.add(serverName);
        throw new IOException("failed log splitting for " + serverName + ", will retry", ex);
    }

    public static boolean processDeadRegion(HRegionInfo hri, AssignmentManager assignmentManager) throws IOException {
        boolean tablePresent = assignmentManager.getTableStateManager().isTablePresent(hri.getTable());
        if (!tablePresent) {
            LOG.info((Object)("The table " + hri.getTable() + " was deleted.  Hence not proceeding."));
            return false;
        }
        boolean disabled = assignmentManager.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED);
        if (disabled) {
            LOG.info((Object)("The table " + hri.getTable() + " was disabled.  Hence not proceeding."));
            return false;
        }
        if (hri.isOffline() && hri.isSplit()) {
            return false;
        }
        boolean disabling = assignmentManager.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLING);
        if (disabling) {
            LOG.info((Object)("The table " + hri.getTable() + " is disabled.  Hence not assigning region" + hri.getEncodedName()));
            return false;
        }
        return true;
    }
}

