// Autogenerated Jamon implementation
// /Volumes/hbase-1.1.1RC0/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.HRegionInfo;
// 29, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 9
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 33, 9
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 34, 9
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 35, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 36, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<HRegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 38, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 38, 60
      jamonWriter.write("\n\n    ");
      // 40, 5
      
        Collections.sort(onlineRegions);
    
      // 44, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_coprocessorStats\" data-toggle=\"tab\">Coprocessor Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 55, 17
      {
        // 55, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 55, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 58, 17
      {
        // 58, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 58, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 61, 17
      {
        // 61, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 61, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 64, 17
      {
        // 64, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 64, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 67, 17
      {
        // 67, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 67, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_coprocessorStats\">\n                ");
      // 70, 17
      {
        // 70, 17
        __jamon_innerUnit__coprocessorStats(jamonWriter, onlineRegions);
      }
      // 70, 71
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 85, 1
    else
    {
      // 85, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 87, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 112, 1
  private void __jamon_innerUnit__requestStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 116, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 123, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 123, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 126, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 129, 13
      jamonWriter.write("<td>");
      // 129, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 129, 48
      jamonWriter.write("</td>\n            ");
      // 130, 13
      if (load != null )
      {
        // 130, 33
        jamonWriter.write("\n            <td>");
        // 131, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 131, 50
        jamonWriter.write("</td>\n            <td>");
        // 132, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 132, 51
        jamonWriter.write("</td>\n            ");
      }
      // 133, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 135, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 212, 1
  private void __jamon_innerUnit__memstoreStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 216, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 222, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 222, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 225, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 228, 13
      jamonWriter.write("<td>");
      // 228, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 228, 48
      jamonWriter.write("</td>\n            ");
      // 229, 13
      if (load != null )
      {
        // 229, 33
        jamonWriter.write("\n            <td>");
        // 230, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getMemstoreSizeMB()), jamonWriter);
        // 230, 47
        jamonWriter.write("m</td>\n            ");
      }
      // 231, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 233, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 178, 1
  private void __jamon_innerUnit__compactStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 182, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n        </tr>\n\n        ");
    // 190, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 190, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 193, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            if  (load != null && load.getTotalCompactingKVs() > 0) {
            percentDone = String.format("%.2f", 100 *
            ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
            }
        
      // 201, 13
      jamonWriter.write("<td>");
      // 201, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 201, 48
      jamonWriter.write("</td>\n            ");
      // 202, 13
      if (load != null )
      {
        // 202, 33
        jamonWriter.write("\n            <td>");
        // 203, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 203, 51
        jamonWriter.write("</td>\n            <td>");
        // 204, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 204, 52
        jamonWriter.write("</td>\n            <td>");
        // 205, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 205, 34
        jamonWriter.write("</td>\n            ");
      }
      // 206, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 208, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 89, 1
  private void __jamon_innerUnit__baseInfo(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 93, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n\n        ");
    // 101, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 101, 46
      jamonWriter.write("\n        <tr>\n            <td>");
      // 103, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 103, 48
      jamonWriter.write("</td>\n            <td>");
      // 104, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
      // 104, 60
      jamonWriter.write("</td>\n            <td>");
      // 105, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
      // 105, 58
      jamonWriter.write("</td>\n            <td>");
      // 106, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 106, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 108, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 140, 1
  private void __jamon_innerUnit__storeStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 144, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n\n        ");
    // 156, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 156, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 159, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 162, 13
      jamonWriter.write("<td>");
      // 162, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 162, 48
      jamonWriter.write("</td>\n            ");
      // 163, 13
      if (load != null )
      {
        // 163, 33
        jamonWriter.write("\n            <td>");
        // 164, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 164, 39
        jamonWriter.write("</td>\n            <td>");
        // 165, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 165, 43
        jamonWriter.write("</td>\n            <td>");
        // 166, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStoreUncompressedSizeMB()), jamonWriter);
        // 166, 56
        jamonWriter.write("m</td>\n            <td>");
        // 167, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefileSizeMB()), jamonWriter);
        // 167, 48
        jamonWriter.write("m</td>\n            <td>");
        // 168, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticIndexSizeKB()), jamonWriter);
        // 168, 55
        jamonWriter.write("k</td>\n            <td>");
        // 169, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticBloomSizeKB()), jamonWriter);
        // 169, 55
        jamonWriter.write("k</td>\n            <td>");
        // 170, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 170, 45
        jamonWriter.write("</td>\n            ");
      }
      // 171, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 173, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 237, 1
  private void __jamon_innerUnit__coprocessorStats(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 241, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Coprocessor</th>\n            <th>Execution Time Statistics</th>\n        </tr>\n\n        ");
    // 248, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 248, 46
      jamonWriter.write("\n        ");
      // 249, 9
          
            Region region = regionServer.getFromOnlineRegions(r.getEncodedName());
            MetricsRegionWrapper mWrap = region == null ? null: region.getMetrics().getRegionWrapper();
        
      // 254, 9
      if (mWrap != null )
      {
        // 254, 30
        jamonWriter.write("\n\n            ");
        // 256, 13
        for (Map.Entry<String, DescriptiveStatistics> entry: mWrap.getCoprocessorExecutionStatistics().entrySet() )
        {
          // 256, 122
          jamonWriter.write("\n            <tr>\n                ");
          // 258, 17
          
                    String coprocessorName = entry.getKey();
                    DescriptiveStatistics ds = entry.getValue();
                
          // 262, 17
          jamonWriter.write("<td>");
          // 262, 21
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
          // 262, 52
          jamonWriter.write("</td>\n                <td>");
          // 263, 21
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(coprocessorName), jamonWriter);
          // 263, 42
          jamonWriter.write("</td>\n                <td>\n                <table class=\"table-condensed\">\n                <tr>\n                    <td>Min Time </td>\n                    <td>");
          // 268, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMin()/1000/1000)), jamonWriter);
          // 268, 77
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>Avg Time </td>\n                    <td>");
          // 272, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMean()/1000/1000)), jamonWriter);
          // 272, 78
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>Max Time </td>\n                    <td>");
          // 276, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getMax()/1000/1000)), jamonWriter);
          // 276, 77
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>90th percentile </td>\n                    <td>");
          // 280, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(90d)/1000/1000)), jamonWriter);
          // 280, 87
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>95th percentile </td>\n                    <td>");
          // 284, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(95d)/1000/1000)), jamonWriter);
          // 284, 87
          jamonWriter.write("ms</td>\n                </tr>\n                <tr>\n                    <td>99th percentile </td>\n                    <td>");
          // 288, 25
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f%n", ds.getPercentile(99d)/1000/1000)), jamonWriter);
          // 288, 87
          jamonWriter.write("ms</td>\n                </tr>\n                </table>\n                </td>\n            </tr>\n            ");
        }
        // 293, 20
        jamonWriter.write("\n        ");
      }
      // 294, 15
      jamonWriter.write("\n        ");
    }
    // 295, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
