/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Understood but doing it anyway; HBASE-14730")
public class HFileWriterV2
extends AbstractHFileWriter {
    static final Log LOG = LogFactory.getLog(HFileWriterV2.class);
    public static final byte[] MAX_MEMSTORE_TS_KEY = Bytes.toBytes((String)"MAX_MEMSTORE_TS_KEY");
    public static final byte[] KEY_VALUE_VERSION = Bytes.toBytes((String)"KEY_VALUE_VERSION");
    public static final int KEY_VALUE_VER_WITH_MEMSTORE = 1;
    private List<InlineBlockWriter> inlineBlockWriters = new ArrayList<InlineBlockWriter>();
    protected HFileBlock.Writer fsBlockWriter;
    private HFileBlockIndex.BlockIndexWriter dataBlockIndexWriter;
    private HFileBlockIndex.BlockIndexWriter metaBlockIndexWriter;
    private long firstDataBlockOffset = -1L;
    protected long lastDataBlockOffset;
    private Cell lastCellOfPreviousBlock = null;
    private List<HFileBlock.BlockWritable> additionalLoadOnOpenData = new ArrayList<HFileBlock.BlockWritable>();
    protected long maxMemstoreTS = 0L;
    private static boolean warnCellWithTags = true;
    public static final String UNIFIED_ENCODED_BLOCKSIZE_RATIO = "hbase.writer.unified.encoded.blocksize.ratio";
    private final int encodedBlockSizeLimit;

    public HFileWriterV2(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, FSDataOutputStream ostream, KeyValue.KVComparator comparator, HFileContext context) throws IOException {
        super(cacheConf, ostream == null ? HFileWriterV2.createOutputStream(conf, fs, path, null) : ostream, path, comparator, context);
        float encodeBlockSizeRatio = conf.getFloat(UNIFIED_ENCODED_BLOCKSIZE_RATIO, 1.0f);
        this.encodedBlockSizeLimit = (int)((float)this.hFileContext.getBlocksize() * encodeBlockSizeRatio);
        this.finishInit(conf);
    }

    protected void finishInit(Configuration conf) {
        if (this.fsBlockWriter != null) {
            throw new IllegalStateException("finishInit called twice");
        }
        this.fsBlockWriter = new HFileBlock.Writer(this.blockEncoder, this.hFileContext);
        boolean cacheIndexesOnWrite = this.cacheConf.shouldCacheIndexesOnWrite();
        this.dataBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter(this.fsBlockWriter, cacheIndexesOnWrite ? this.cacheConf : null, cacheIndexesOnWrite ? this.name : null);
        this.dataBlockIndexWriter.setMaxChunkSize(HFileBlockIndex.getMaxChunkSize(conf));
        this.dataBlockIndexWriter.setMinIndexNumEntries(HFileBlockIndex.getMinIndexNumEntries(conf));
        this.inlineBlockWriters.add(this.dataBlockIndexWriter);
        this.metaBlockIndexWriter = new HFileBlockIndex.BlockIndexWriter();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Initialized with " + this.cacheConf));
        }
    }

    protected void checkBlockBoundary() throws IOException {
        if (this.fsBlockWriter.encodedBlockSizeWritten() >= this.encodedBlockSizeLimit || this.fsBlockWriter.blockSizeWritten() >= this.hFileContext.getBlocksize()) {
            this.finishBlock();
            this.writeInlineBlocks(false);
            this.newBlock();
        }
    }

    private void finishBlock() throws IOException {
        if (!this.fsBlockWriter.isWriting() || this.fsBlockWriter.blockSizeWritten() == 0) {
            return;
        }
        if (this.firstDataBlockOffset == -1L) {
            this.firstDataBlockOffset = this.outputStream.getPos();
        }
        this.lastDataBlockOffset = this.outputStream.getPos();
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        int onDiskSize = this.fsBlockWriter.getOnDiskSizeWithHeader();
        Cell indexEntry = CellComparator.getMidpoint((KeyValue.KVComparator)this.comparator, (Cell)this.lastCellOfPreviousBlock, (Cell)this.firstCellInBlock);
        this.dataBlockIndexWriter.addEntry(CellUtil.getCellKeySerializedAsKeyValueKey((Cell)indexEntry), this.lastDataBlockOffset, onDiskSize);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.doCacheOnWrite(this.lastDataBlockOffset);
        }
    }

    private void writeInlineBlocks(boolean closing) throws IOException {
        for (InlineBlockWriter ibw : this.inlineBlockWriters) {
            while (ibw.shouldWriteBlock(closing)) {
                long offset = this.outputStream.getPos();
                boolean cacheThisBlock = ibw.getCacheOnWrite();
                ibw.writeInlineBlock(this.fsBlockWriter.startWriting(ibw.getInlineBlockType()));
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                ibw.blockWritten(offset, this.fsBlockWriter.getOnDiskSizeWithHeader(), this.fsBlockWriter.getUncompressedSizeWithoutHeader());
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                if (!cacheThisBlock) continue;
                this.doCacheOnWrite(offset);
            }
        }
    }

    private void doCacheOnWrite(long offset) {
        HFileBlock cacheFormatBlock = this.fsBlockWriter.getBlockForCaching(this.cacheConf);
        this.cacheConf.getBlockCache().cacheBlock(new BlockCacheKey(this.name, offset, true, cacheFormatBlock.getBlockType()), cacheFormatBlock);
    }

    protected void newBlock() throws IOException {
        this.fsBlockWriter.startWriting(BlockType.DATA);
        this.firstCellInBlock = null;
        if (this.lastCell != null) {
            this.lastCellOfPreviousBlock = this.lastCell;
        }
    }

    @Override
    public void appendMetaBlock(String metaBlockName, Writable content) {
        byte[] cur;
        int i;
        byte[] key = Bytes.toBytes((String)metaBlockName);
        for (i = 0; i < this.metaNames.size() && Bytes.BYTES_RAWCOMPARATOR.compare(cur = (byte[])this.metaNames.get(i), 0, cur.length, key, 0, key.length) <= 0; ++i) {
        }
        this.metaNames.add(i, key);
        this.metaData.add(i, content);
    }

    @Override
    public void append(Cell cell) throws IOException {
        byte[] value = cell.getValueArray();
        int voffset = cell.getValueOffset();
        int vlength = cell.getValueLength();
        boolean dupKey = this.checkKey(cell);
        this.checkValue(value, voffset, vlength);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        if (!this.fsBlockWriter.isWriting()) {
            this.newBlock();
        }
        if (warnCellWithTags && this.getFileContext().isIncludesTags()) {
            LOG.warn((Object)"A minimum HFile version of 3 is required to support cell attributes/tags. Consider setting hfile.format.version accordingly.");
            warnCellWithTags = false;
        }
        this.fsBlockWriter.write(cell);
        this.totalKeyLength += (long)CellUtil.estimatedSerializedSizeOfKey((Cell)cell);
        this.totalValueLength += (long)vlength;
        if (this.firstCellInBlock == null) {
            this.firstCellInBlock = cell;
        }
        this.lastCell = cell;
        ++this.entryCount;
        this.maxMemstoreTS = Math.max(this.maxMemstoreTS, cell.getSequenceId());
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.blockEncoder.saveMetadata(this);
        this.finishBlock();
        this.writeInlineBlocks(true);
        FixedFileTrailer trailer = new FixedFileTrailer(this.getMajorVersion(), this.getMinorVersion());
        if (!this.metaNames.isEmpty()) {
            for (int i = 0; i < this.metaNames.size(); ++i) {
                long offset = this.outputStream.getPos();
                DataOutputStream dos = this.fsBlockWriter.startWriting(BlockType.META);
                ((Writable)this.metaData.get(i)).write((DataOutput)dos);
                this.fsBlockWriter.writeHeaderAndData(this.outputStream);
                this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
                this.metaBlockIndexWriter.addEntry((byte[])this.metaNames.get(i), offset, this.fsBlockWriter.getOnDiskSizeWithHeader());
            }
        }
        long rootIndexOffset = this.dataBlockIndexWriter.writeIndexBlocks(this.outputStream);
        trailer.setLoadOnOpenOffset(rootIndexOffset);
        this.metaBlockIndexWriter.writeSingleLevelIndex(this.fsBlockWriter.startWriting(BlockType.ROOT_INDEX), "meta");
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        if (this.hFileContext.isIncludesMvcc()) {
            this.appendFileInfo(MAX_MEMSTORE_TS_KEY, Bytes.toBytes((long)this.maxMemstoreTS));
            this.appendFileInfo(KEY_VALUE_VERSION, Bytes.toBytes((int)1));
        }
        this.writeFileInfo(trailer, this.fsBlockWriter.startWriting(BlockType.FILE_INFO));
        this.fsBlockWriter.writeHeaderAndData(this.outputStream);
        this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        for (HFileBlock.BlockWritable w : this.additionalLoadOnOpenData) {
            this.fsBlockWriter.writeBlock(w, this.outputStream);
            this.totalUncompressedBytes += (long)this.fsBlockWriter.getUncompressedSizeWithHeader();
        }
        trailer.setNumDataIndexLevels(this.dataBlockIndexWriter.getNumLevels());
        trailer.setUncompressedDataIndexSize(this.dataBlockIndexWriter.getTotalUncompressedSize());
        trailer.setFirstDataBlockOffset(this.firstDataBlockOffset);
        trailer.setLastDataBlockOffset(this.lastDataBlockOffset);
        trailer.setComparatorClass(this.comparator.getClass());
        trailer.setDataIndexCount(this.dataBlockIndexWriter.getNumRootEntries());
        this.finishClose(trailer);
        this.fsBlockWriter.release();
    }

    @Override
    public void addInlineBlockWriter(InlineBlockWriter ibw) {
        this.inlineBlockWriters.add(ibw);
    }

    @Override
    public void addGeneralBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.GENERAL_BLOOM_META);
    }

    @Override
    public void addDeleteFamilyBloomFilter(BloomFilterWriter bfw) {
        this.addBloomFilter(bfw, BlockType.DELETE_FAMILY_BLOOM_META);
    }

    private void addBloomFilter(final BloomFilterWriter bfw, final BlockType blockType) {
        if (bfw.getKeyCount() <= 0L) {
            return;
        }
        if (blockType != BlockType.GENERAL_BLOOM_META && blockType != BlockType.DELETE_FAMILY_BLOOM_META) {
            throw new RuntimeException("Block Type: " + blockType.toString() + "is not supported");
        }
        this.additionalLoadOnOpenData.add(new HFileBlock.BlockWritable(){

            @Override
            public BlockType getBlockType() {
                return blockType;
            }

            @Override
            public void writeToBlock(DataOutput out) throws IOException {
                bfw.getMetaWriter().write(out);
                Writable dataWriter = bfw.getDataWriter();
                if (dataWriter != null) {
                    dataWriter.write(out);
                }
            }
        });
    }

    protected int getMajorVersion() {
        return 2;
    }

    protected int getMinorVersion() {
        return 3;
    }

    @Override
    public HFileContext getFileContext() {
        return this.hFileContext;
    }

    static class WriterFactoryV2
    extends HFile.WriterFactory {
        WriterFactoryV2(Configuration conf, CacheConfig cacheConf) {
            super(conf, cacheConf);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, FSDataOutputStream ostream, KeyValue.KVComparator comparator, HFileContext context) throws IOException {
            context.setIncludesTags(false);
            return new HFileWriterV2(this.conf, this.cacheConf, fs, path, ostream, comparator, context);
        }
    }
}

