/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class NMapInputFormat
extends InputFormat<NullWritable, NullWritable> {
    private static final String NMAPS_KEY = "nmapinputformat.num.maps";

    public RecordReader<NullWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext tac) throws IOException, InterruptedException {
        return new SingleRecordReader<NullWritable, NullWritable>(NullWritable.get(), NullWritable.get());
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        int count = NMapInputFormat.getNumMapTasks(context.getConfiguration());
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(count);
        for (int i = 0; i < count; ++i) {
            splits.add(new NullInputSplit());
        }
        return splits;
    }

    public static void setNumMapTasks(Configuration conf, int numTasks) {
        conf.setInt(NMAPS_KEY, numTasks);
    }

    public static int getNumMapTasks(Configuration conf) {
        return conf.getInt(NMAPS_KEY, 1);
    }

    private static class SingleRecordReader<K, V>
    extends RecordReader<K, V> {
        private final K key;
        private final V value;
        boolean providedKey = false;

        SingleRecordReader(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public void close() {
        }

        public K getCurrentKey() {
            return this.key;
        }

        public V getCurrentValue() {
            return this.value;
        }

        public float getProgress() {
            return 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext tac) {
        }

        public boolean nextKeyValue() {
            if (this.providedKey) {
                return false;
            }
            this.providedKey = true;
            return true;
        }
    }

    private static class NullInputSplit
    extends InputSplit
    implements Writable {
        private NullInputSplit() {
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public void readFields(DataInput in) throws IOException {
        }

        public void write(DataOutput out) throws IOException {
        }
    }
}

