/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.ByteBloomFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompoundBloomFilter;
import org.apache.hadoop.hbase.util.CompoundBloomFilterBase;
import org.apache.hadoop.hbase.util.CompoundBloomFilterWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCompoundBloomFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestCompoundBloomFilter.class);
    private static final int NUM_TESTS = 9;
    private static final BloomType[] BLOOM_TYPES = new BloomType[]{BloomType.ROW, BloomType.ROW, BloomType.ROWCOL, BloomType.ROWCOL, BloomType.ROW, BloomType.ROWCOL, BloomType.ROWCOL, BloomType.ROWCOL, BloomType.ROW};
    private static final int[] NUM_KV;
    private static final int[] BLOCK_SIZES;
    private static final int[] BLOOM_BLOCK_SIZES;
    private static final double[] TARGET_ERROR_RATES;
    private static final double TOO_HIGH_ERROR_RATE;
    private static Configuration conf;
    private static CacheConfig cacheConf;
    private FileSystem fs;
    private BlockCache blockCache;
    private String testIdMsg;
    private static final int GENERATION_SEED = 2319;
    private static final int EVALUATION_SEED = 135;

    @Before
    public void setUp() throws IOException {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        this.fs = FileSystem.get((Configuration)conf);
        cacheConf = new CacheConfig(conf);
        this.blockCache = cacheConf.getBlockCache();
        Assert.assertNotNull((Object)this.blockCache);
    }

    private List<KeyValue> createSortedKeyValues(Random rand, int n) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>(n);
        for (int i = 0; i < n; ++i) {
            kvList.add(TestHFileWriterV2.randomKeyValue(rand));
        }
        Collections.sort(kvList, KeyValue.COMPARATOR);
        return kvList;
    }

    @Test
    public void testCompoundBloomFilter() throws IOException {
        conf.setBoolean("io.storefile.bloom.enabled", true);
        for (int t = 0; t < 9; ++t) {
            conf.setFloat("io.storefile.bloom.error.rate", (float)TARGET_ERROR_RATES[t]);
            this.testIdMsg = "in test #" + t + ":";
            Random generationRand = new Random(2319L);
            List<KeyValue> kvs = this.createSortedKeyValues(generationRand, NUM_KV[t]);
            BloomType bt = BLOOM_TYPES[t];
            Path sfPath = this.writeStoreFile(t, bt, kvs);
            this.readStoreFile(t, bt, kvs, sfPath);
        }
    }

    private void validateFalsePosRate(double falsePosRate, int nTrials, double zValueBoundary, CompoundBloomFilter cbf, String additionalMsg) {
        boolean isUpperBound;
        double p = BloomFilterFactory.getErrorRate((Configuration)conf);
        double zValue = (falsePosRate - p) / Math.sqrt(p * (1.0 - p) / (double)nTrials);
        String assortedStatsStr = " (targetErrorRate=" + p + ", falsePosRate=" + falsePosRate + ", nTrials=" + nTrials + ")";
        LOG.info((Object)("z-value is " + zValue + assortedStatsStr));
        boolean bl = isUpperBound = zValueBoundary > 0.0;
        if (isUpperBound && zValue > zValueBoundary || !isUpperBound && zValue < zValueBoundary) {
            String errorMsg = "False positive rate z-value " + zValue + " is " + (isUpperBound ? "higher" : "lower") + " than " + zValueBoundary + assortedStatsStr + ". Per-chunk stats:\n" + cbf.formatTestingStats();
            Assert.fail((String)(errorMsg + additionalMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStoreFile(int t, BloomType bt, List<KeyValue> kvs, Path sfPath) throws IOException {
        StoreFile sf = new StoreFile(this.fs, sfPath, conf, cacheConf, bt);
        StoreFile.Reader r = sf.createReader();
        boolean pread = true;
        StoreFileScanner scanner = r.getStoreFileScanner(true, true, false, 0L, 0L, false);
        int numChecked = 0;
        for (KeyValue kv : kvs) {
            byte[] row = kv.getRow();
            boolean present = this.isInBloom(scanner, row, kv.getQualifier());
            Assert.assertTrue((String)(this.testIdMsg + " Bloom filter false negative on row " + Bytes.toStringBinary((byte[])row) + " after " + numChecked + " successful checks"), (boolean)present);
            ++numChecked;
        }
        for (boolean fakeLookupEnabled : new boolean[]{true, false}) {
            if (fakeLookupEnabled) {
                ByteBloomFilter.setRandomGeneratorForTest((Random)new Random(283742987L));
            }
            try {
                String fakeLookupModeStr = ", fake lookup is " + (fakeLookupEnabled ? "enabled" : "disabled");
                CompoundBloomFilter cbf = (CompoundBloomFilter)r.getGeneralBloomFilter();
                cbf.enableTestingStats();
                int numFalsePos = 0;
                Random rand = new Random(135L);
                int nTrials = NUM_KV[t] * 10;
                for (int i = 0; i < nTrials; ++i) {
                    byte[] query = TestHFileWriterV2.randomRowOrQualifier(rand);
                    if (!this.isInBloom(scanner, query, bt, rand)) continue;
                    ++numFalsePos;
                }
                double falsePosRate = (double)numFalsePos * 1.0 / (double)nTrials;
                LOG.debug((Object)(String.format(this.testIdMsg + " False positives: %d out of %d (%f)", numFalsePos, nTrials, falsePosRate) + fakeLookupModeStr));
                Assert.assertTrue((String)("False positive is too high: " + falsePosRate + " (greater " + "than " + TOO_HIGH_ERROR_RATE + ")" + fakeLookupModeStr), (falsePosRate < TOO_HIGH_ERROR_RATE ? 1 : 0) != 0);
                double maxZValue = fakeLookupEnabled ? 1.96 : 2.5;
                this.validateFalsePosRate(falsePosRate, nTrials, maxZValue, cbf, fakeLookupModeStr);
                int nChunks = cbf.getNumChunks();
                if (nChunks > 1) {
                    numFalsePos = (int)((long)numFalsePos - cbf.getNumPositivesForTesting(nChunks - 1));
                    nTrials = (int)((long)nTrials - cbf.getNumQueriesForTesting(nChunks - 1));
                    falsePosRate = (double)numFalsePos * 1.0 / (double)nTrials;
                    LOG.info((Object)(this.testIdMsg + " False positive rate without last chunk is " + falsePosRate + fakeLookupModeStr));
                }
                this.validateFalsePosRate(falsePosRate, nTrials, -2.58, cbf, fakeLookupModeStr);
            }
            finally {
                ByteBloomFilter.setRandomGeneratorForTest(null);
            }
        }
        r.close(true);
    }

    private boolean isInBloom(StoreFileScanner scanner, byte[] row, BloomType bt, Random rand) {
        return this.isInBloom(scanner, row, TestHFileWriterV2.randomRowOrQualifier(rand));
    }

    private boolean isInBloom(StoreFileScanner scanner, byte[] row, byte[] qualifier) {
        Scan scan = new Scan(row, row);
        scan.addColumn(Bytes.toBytes((String)"_-myColumnFamily-_"), qualifier);
        Store store = (Store)Mockito.mock(Store.class);
        HColumnDescriptor hcd = (HColumnDescriptor)Mockito.mock(HColumnDescriptor.class);
        Mockito.when((Object)hcd.getName()).thenReturn((Object)Bytes.toBytes((String)"_-myColumnFamily-_"));
        Mockito.when((Object)store.getFamily()).thenReturn((Object)hcd);
        return scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
    }

    private Path writeStoreFile(int t, BloomType bt, List<KeyValue> kvs) throws IOException {
        conf.setInt("io.storefile.bloom.block.size", BLOOM_BLOCK_SIZES[t]);
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        cacheConf = new CacheConfig(conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(BLOCK_SIZES[t]).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(conf, cacheConf, this.fs).withOutputDir(TEST_UTIL.getDataTestDir()).withBloomType(bt).withFileContext(meta).build();
        Assert.assertTrue((boolean)w.hasGeneralBloom());
        Assert.assertTrue((boolean)(w.getGeneralBloomWriter() instanceof CompoundBloomFilterWriter));
        CompoundBloomFilterWriter cbbf = (CompoundBloomFilterWriter)w.getGeneralBloomWriter();
        int keyCount = 0;
        KeyValue prev = null;
        LOG.debug((Object)("Total keys/values to insert: " + kvs.size()));
        for (KeyValue kv : kvs) {
            w.append((Cell)kv);
            boolean newKey = true;
            if (prev != null) {
                boolean bl = !(bt != BloomType.ROW ? KeyValue.COMPARATOR.matchingRowColumn((Cell)kv, prev) : KeyValue.COMPARATOR.matchingRows((Cell)kv, prev)) ? true : (newKey = false);
            }
            if (newKey) {
                ++keyCount;
            }
            Assert.assertEquals((long)keyCount, (long)cbbf.getKeyCount());
            prev = kv;
        }
        w.close();
        return w.getPath();
    }

    @Test
    public void testCompoundBloomSizing() {
        int bloomBlockByteSize = 4096;
        int bloomBlockBitSize = bloomBlockByteSize * 8;
        double targetErrorRate = 0.01;
        long maxKeysPerChunk = ByteBloomFilter.idealMaxKeys((long)bloomBlockBitSize, (double)targetErrorRate);
        long bloomSize1 = bloomBlockByteSize * 8;
        long bloomSize2 = ByteBloomFilter.computeBitSize((long)maxKeysPerChunk, (double)targetErrorRate);
        double bloomSizeRatio = (double)bloomSize2 * 1.0 / (double)bloomSize1;
        Assert.assertTrue((Math.abs(bloomSizeRatio - 0.9999) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateKey() {
        CompoundBloomFilterBase cbfb = new CompoundBloomFilterBase();
        byte[] row = "myRow".getBytes();
        byte[] qualifier = "myQualifier".getBytes();
        byte[] rowKey = cbfb.createBloomKey(row, 0, row.length, row, 0, 0);
        byte[] rowColKey = cbfb.createBloomKey(row, 0, row.length, qualifier, 0, qualifier.length);
        KeyValue rowKV = KeyValue.createKeyValueFromKey((byte[])rowKey);
        KeyValue rowColKV = KeyValue.createKeyValueFromKey((byte[])rowColKey);
        Assert.assertEquals((long)rowKV.getTimestamp(), (long)rowColKV.getTimestamp());
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])rowKV.getRow()), (Object)Bytes.toStringBinary((byte[])rowColKV.getRow()));
        Assert.assertEquals((long)0L, (long)rowKV.getQualifier().length);
    }

    static {
        int N = 10000;
        NUM_KV = new int[]{21870, 10000, 10000, 10000, 10000, 1000, 10000, 7500, 7500};
        assert (NUM_KV.length == 9);
        int blkSize = 65536;
        BLOCK_SIZES = new int[]{512, 1000, 65536, 65536, 65536, 128, 300, 65536, 65536};
        assert (BLOCK_SIZES.length == 9);
        BLOOM_BLOCK_SIZES = new int[]{1000, 4096, 4096, 4096, 8192, 128, 1024, 600, 600};
        assert (BLOOM_BLOCK_SIZES.length == 9);
        TARGET_ERROR_RATES = new double[]{0.025, 0.01, 0.015, 0.01, 0.03, 0.01, 0.01, 0.07, 0.07};
        assert (TARGET_ERROR_RATES.length == 9);
        double m = 0.0;
        for (double errorRate : TARGET_ERROR_RATES) {
            m = Math.max(m, errorRate);
        }
        TOO_HIGH_ERROR_RATE = m + 0.03;
    }
}

