/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestWALReplay {
    private static final Log LOG = LogFactory.getLog(TestWALReplay.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final EnvironmentEdge ee = EnvironmentEdgeManager.getDelegate();
    private Path hbaseRootDir = null;
    private Path hbaseWALRootDir = null;
    private String logName;
    private Path oldLogDir;
    private Path logDir;
    private FileSystem fs;
    private Configuration conf;
    private ZooKeeperProtos.SplitLogTask.RecoveryMode mode;
    private WALFactory wals;
    @Rule
    public final TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(3);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        Path hbaseWALRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbaselog"));
        LOG.info((Object)("hbase.rootdir=" + hbaseRootDir));
        LOG.info((Object)("hbase.wal.dir=" + hbaseWALRootDir));
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
        FSUtils.setWALRootDir((Configuration)conf, (Path)hbaseWALRootDir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.hbaseWALRootDir = FSUtils.getWALRootDir((Configuration)this.conf);
        this.oldLogDir = new Path(this.hbaseWALRootDir, "oldWALs");
        this.logName = DefaultWALProvider.getWALDirectoryName((String)(this.currentTest.getMethodName() + "-manual"));
        this.logDir = new Path(this.hbaseWALRootDir, this.logName);
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseWALRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
        }
        this.mode = this.conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        this.wals = new WALFactory(this.conf, null, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        this.wals.close();
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseWALRootDir, true);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    @Test
    public void testReplayEditsAfterRegionMovedWithMultiCF() throws Exception {
        int destServerNum;
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterRegionMovedWithMultiCF");
        byte[] family1 = Bytes.toBytes((String)"cf1");
        byte[] family2 = Bytes.toBytes((String)"cf2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] value = Bytes.toBytes((String)"testV");
        byte[][] familys = new byte[][]{family1, family2};
        TEST_UTIL.createTable(tableName, (byte[][])familys);
        HTable htable = new HTable(TEST_UTIL.getConfiguration(), tableName);
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.add(family1, qualifier, value);
        htable.put(put);
        ResultScanner resultScanner = htable.getScanner(new Scan());
        int count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)1L, (long)count);
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getMiniHBaseCluster();
        List<HRegion> regions = hbaseCluster.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        Region destRegion = (Region)regions.get(0);
        int originServerNum = hbaseCluster.getServerWith(destRegion.getRegionInfo().getRegionName());
        Assert.assertTrue((String)"Please start more than 1 regionserver", (hbaseCluster.getRegionServerThreads().size() > 1 ? 1 : 0) != 0);
        for (destServerNum = 0; destServerNum == originServerNum; ++destServerNum) {
        }
        HRegionServer originServer = hbaseCluster.getRegionServer(originServerNum);
        HRegionServer destServer = hbaseCluster.getRegionServer(destServerNum);
        TEST_UTIL.moveRegionAndWait(destRegion.getRegionInfo(), destServer.getServerName());
        Delete del = new Delete(Bytes.toBytes((String)"r1"));
        htable.delete(del);
        resultScanner = htable.getScanner(new Scan());
        count = 0;
        while (resultScanner.next() != null) {
            ++count;
        }
        resultScanner.close();
        Assert.assertEquals((long)0L, (long)count);
        Region region = destServer.getOnlineRegion(destRegion.getRegionInfo().getRegionName());
        region.flush(true);
        for (Store store : region.getStores()) {
            store.triggerMajorCompaction();
        }
        region.compact(true);
        TEST_UTIL.moveRegionAndWait(destRegion.getRegionInfo(), originServer.getServerName());
        originServer.abort("testing");
        Result result = htable.get(new Get(Bytes.toBytes((String)"r1")));
        if (result != null) {
            Assert.assertTrue((String)("Row is deleted, but we get" + result.toString()), (result == null || result.isEmpty() ? 1 : 0) != 0);
        }
        resultScanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2727() throws Exception {
        TableName tableName = TableName.valueOf((String)"test2727");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getWALTableDir((Configuration)this.conf, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        byte[] rowName = tableName.getName();
        WAL wal1 = this.createWAL(this.conf);
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal1, htd, mvcc);
        }
        wal1.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal2, htd, mvcc);
        }
        wal2.shutdown();
        this.runWALSplit(this.conf);
        try (WAL wal3 = this.createWAL(this.conf);){
            HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal3);
            long seqid = region.getOpenSeqNum();
            Assert.assertTrue((seqid > mvcc.getWritePoint() ? 1 : 0) != 0);
            Assert.assertEquals((long)(seqid - 1L), (long)mvcc.getWritePoint());
            LOG.debug((Object)("region.getOpenSeqNum(): " + region.getOpenSeqNum() + ", wal3.id: " + mvcc.getReadPoint()));
            region.close();
        }
    }

    @Test
    public void testRegionMadeOfBulkLoadedFilesOnly() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testRegionMadeOfBulkLoadedFilesOnly");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = new Path(this.hbaseRootDir, tableName.getNameAsString());
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        WAL wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        byte[] family = ((HColumnDescriptor)htd.getFamilies().iterator().next()).getName();
        Path f = new Path(basedir, "hfile");
        HFileTestUtil.createHFile(this.conf, this.fs, f, family, family, Bytes.toBytes((String)""), Bytes.toBytes((String)"z"), 10);
        ArrayList<Pair> hfs = new ArrayList<Pair>(1);
        hfs.add(Pair.newPair((Object)family, (Object)f.toString()));
        region.bulkLoadHFiles(hfs, true, null);
        byte[] row = tableName.getName();
        region.put(new Put(row).add(family, family, family));
        wal.sync();
        int rowsInsertedCount = 11;
        Assert.assertEquals((long)11L, (long)this.getScannedCount(region.getScanner(new Scan())));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                WAL wal2 = TestWALReplay.this.createWAL(newConf);
                HRegion region2 = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALReplay.this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
                long seqid2 = region2.getOpenSeqNum();
                Assert.assertTrue((seqid2 > -1L ? 1 : 0) != 0);
                Assert.assertEquals((long)11L, (long)TestWALReplay.this.getScannedCount(region2.getScanner(new Scan())));
                region2.close();
                wal2.close();
                return null;
            }
        });
    }

    @Test
    public void testCompactedBulkLoadedFiles() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testCompactedBulkLoadedFiles");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = new Path(this.hbaseRootDir, tableName.getNameAsString());
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        WAL wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        byte[] row = tableName.getName();
        byte[] family = ((HColumnDescriptor)htd.getFamilies().iterator().next()).getName();
        region.put(new Put(row).add(family, family, family));
        wal.sync();
        ArrayList<Pair> hfs = new ArrayList<Pair>(1);
        for (int i = 0; i < 3; ++i) {
            Path f = new Path(basedir, "hfile" + i);
            HFileTestUtil.createHFile(this.conf, this.fs, f, family, family, Bytes.toBytes((String)(i + "00")), Bytes.toBytes((String)(i + "50")), 10);
            hfs.add(Pair.newPair((Object)family, (Object)f.toString()));
        }
        region.bulkLoadHFiles(hfs, true, null);
        int rowsInsertedCount = 31;
        Assert.assertEquals((long)31L, (long)this.getScannedCount(region.getScanner(new Scan())));
        region.compact(true);
        Assert.assertEquals((long)31L, (long)this.getScannedCount(region.getScanner(new Scan())));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                WAL wal2 = TestWALReplay.this.createWAL(newConf);
                HRegion region2 = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALReplay.this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
                long seqid2 = region2.getOpenSeqNum();
                Assert.assertTrue((seqid2 > -1L ? 1 : 0) != 0);
                Assert.assertEquals((long)31L, (long)TestWALReplay.this.getScannedCount(region2.getScanner(new Scan())));
                region2.close();
                wal2.close();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsWrittenViaHRegion() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region3);
        WAL wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        boolean first = true;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
            if (!first) continue;
            region.flush(true);
            first = false;
        }
        final Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region2, "y");
        }
        final Result result2 = region2.get(g);
        Assert.assertEquals((long)(2 * result.size()), (long)result2.size());
        wal2.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, tableName.getNameAsString());
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                WAL wal3 = TestWALReplay.this.createWAL(newConf);
                final AtomicInteger countOfRestoredEdits = new AtomicInteger(0);
                HRegion region3 = new HRegion(basedir, wal3, newFS, newConf, hri, htd, null){

                    protected boolean restoreEdit(Store s, Cell cell) {
                        boolean b = super.restoreEdit(s, cell);
                        countOfRestoredEdits.incrementAndGet();
                        return b;
                    }
                };
                long seqid3 = region3.initialize();
                Result result3 = region3.get(g);
                Assert.assertEquals((long)result2.size(), (long)result3.size());
                Assert.assertEquals((long)(htd.getFamilies().size() * 10), (long)countOfRestoredEdits.get());
                region3.close();
                wal3.close();
                return null;
            }
        });
    }

    @Test
    public void testReplayEditsAfterPartialFlush() throws IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenViaHRegion");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region3);
        WAL wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        long seqid = region.getOpenSeqNum();
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.flush(true);
        region.close(true);
        wal.shutdown();
        int cf_count = 0;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            if (++cf_count != 2) continue;
            region.getRegionFileSystem().deleteFamily(hcd.getNameAsString());
        }
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf);
        HRegion region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
        long seqid2 = region2.getOpenSeqNum();
        Assert.assertTrue((seqid + (long)result.size() < seqid2 ? 1 : 0) != 0);
        Result result1b = region2.get(g);
        Assert.assertEquals((long)result.size(), (long)result1b.size());
    }

    @Test
    public void testReplayEditsAfterAbortingFlush() throws IOException {
        TableName tableName = TableName.valueOf((String)"testReplayEditsAfterAbortingFlush");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region3 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        region3.close();
        region3.getWAL().close();
        WAL wal = this.createWAL(this.conf);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        Mockito.when((Object)rsServices.getServerName()).thenReturn((Object)ServerName.valueOf((String)"foo", (int)10, (long)10L));
        Configuration customConf = new Configuration(this.conf);
        customConf.set("hbase.hstore.defaultengine.storeflusher.class", CustomStoreFlusher.class.getName());
        HRegion region = HRegion.openHRegion((Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal, (Configuration)customConf, (RegionServerServices)rsServices, null);
        int writtenRowCount = 10;
        ArrayList families = new ArrayList(htd.getFamilies());
        for (int i = 0; i < writtenRowCount; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.add(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        RegionScanner scanner = region.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount(scanner));
        CustomStoreFlusher.throwExceptionWhenFlushing.set(true);
        try {
            region.flush(true);
            Assert.fail((String)"Injected exception hasn't been thrown");
        }
        catch (Throwable t) {
            LOG.info((Object)("Expected simulated exception when flushing region," + t.getMessage()));
            ((RegionServerServices)Mockito.doReturn((Object)true).when((Object)rsServices)).isAborted();
            region.setClosing(false);
        }
        int moreRow = 10;
        for (int i = writtenRowCount; i < writtenRowCount + moreRow; ++i) {
            Put put = new Put(Bytes.toBytes((String)(tableName + Integer.toString(i))));
            put.add(((HColumnDescriptor)families.get(i % families.size())).getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            region.put(put);
        }
        writtenRowCount += moreRow;
        CustomStoreFlusher.throwExceptionWhenFlushing.set(false);
        try {
            region.flush(true);
        }
        catch (IOException t) {
            LOG.info((Object)("Expected exception when flushing region because server is stopped," + t.getMessage()));
        }
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        WAL wal2 = this.createWAL(this.conf);
        ((RegionServerServices)Mockito.doReturn((Object)false).when((Object)rsServices)).isAborted();
        HRegion region2 = HRegion.openHRegion((Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2, (Configuration)this.conf, (RegionServerServices)rsServices, null);
        scanner = region2.getScanner(new Scan());
        Assert.assertEquals((long)writtenRowCount, (long)this.getScannedCount(scanner));
    }

    private int getScannedCount(RegionScanner scanner) throws IOException {
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        while (true) {
            boolean existMore = scanner.next(results);
            if (!results.isEmpty()) {
                ++scannedCount;
            }
            if (!existMore) break;
            results.clear();
        }
        return scannedCount;
    }

    @Test
    public void testReplayEditsWrittenIntoWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenIntoWAL");
        final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        final Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        final HTableDescriptor htd = this.createBasic3FamilyHTD(tableName);
        HRegion region2 = HRegion.createHRegion((HRegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (HTableDescriptor)htd);
        HRegion.closeHRegion((HRegion)region2);
        WAL wal = this.createWAL(this.conf);
        final byte[] rowName = tableName.getName();
        byte[] regionName = hri.getEncodedNameAsBytes();
        int countPerFamily = 1000;
        HashSet<byte[]> familyNames = new HashSet<byte[]>();
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, rowName, hcd.getName(), 1000, this.ee, wal, htd, mvcc);
            familyNames.add(hcd.getName());
        }
        wal.startCacheFlush(regionName, familyNames);
        wal.completeCacheFlush(regionName);
        WALEdit edit = new WALEdit();
        long now = this.ee.currentTime();
        edit.add((Cell)new KeyValue(rowName, Bytes.toBytes((String)"another family"), rowName, now, rowName));
        wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, now, mvcc), edit, true);
        edit = new WALEdit();
        now = this.ee.currentTime();
        edit.add((Cell)new KeyValue(rowName, Bytes.toBytes((String)"c"), null, now, KeyValue.Type.DeleteFamily));
        wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, now, mvcc), edit, true);
        wal.sync();
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                TestWALReplay.this.runWALSplit(newConf);
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                newConf.setInt("hbase.hregion.memstore.flush.size", 102400);
                final AtomicInteger flushcount = new AtomicInteger(0);
                try (WAL newWal = TestWALReplay.this.createWAL(newConf);){
                    HRegion region = new HRegion(basedir, newWal, newFS, newConf, hri, htd, null){

                        protected Region.FlushResult internalFlushcache(WAL wal, long myseqid, Collection<Store> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker) throws IOException {
                            LOG.info((Object)"InternalFlushCache Invoked");
                            Region.FlushResult fs = super.internalFlushcache(wal, myseqid, storesToFlush, (MonitoredTask)Mockito.mock(MonitoredTask.class), writeFlushWalMarker);
                            flushcount.incrementAndGet();
                            return fs;
                        }
                    };
                    long seqid = region.initialize();
                    long writePoint = mvcc.getWritePoint();
                    Assert.assertTrue((String)("Flushcount=" + flushcount.get()), (flushcount.get() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((seqid - 1L == writePoint ? 1 : 0) != 0);
                    Get get = new Get(rowName);
                    Result result = region.get(get);
                    Assert.assertEquals((long)(1000 * (htd.getFamilies().size() - 1)), (long)result.size());
                    region.close();
                }
                return null;
            }
        });
    }

    @Test
    public void testSequentialEditLogSeqNum() throws IOException {
        TableName tableName = TableName.valueOf((String)this.currentTest.getMethodName());
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        MockWAL wal = this.createMockWAL();
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        region.flush(true);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 5, this.ee, (Region)region, "x");
        }
        long lastestSeqNumber = region.getSequenceId();
        wal.doCompleteCacheFlush = true;
        wal.completeCacheFlush(hri.getEncodedNameAsBytes());
        wal.shutdown();
        FileStatus[] listStatus = wal.getFiles();
        Assert.assertNotNull((Object)listStatus);
        Assert.assertTrue((listStatus.length > 0 ? 1 : 0) != 0);
        WALSplitter.splitLogFile((Path)this.hbaseWALRootDir, (FileStatus)listStatus[0], (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (ZooKeeperProtos.SplitLogTask.RecoveryMode)this.mode, (WALFactory)this.wals);
        FileStatus[] listStatus1 = this.fs.listStatus(new Path(FSUtils.getWALTableDir((Configuration)this.conf, (TableName)tableName), new Path(hri.getEncodedName(), "recovered.edits")), new PathFilter(){

            public boolean accept(Path p) {
                return !WALSplitter.isSequenceIdFile((Path)p);
            }
        });
        int editCount = 0;
        for (FileStatus fileStatus : listStatus1) {
            editCount = Integer.parseInt(fileStatus.getPath().getName());
        }
        Assert.assertEquals((String)"The sequence number of the recoverd.edits and the current edit seq should be same", (long)lastestSeqNumber, (long)editCount);
    }

    @Test
    public void testDatalossWhenInputError() throws IOException, InstantiationException, IllegalAccessException {
        HRegion region2;
        TableName tableName = TableName.valueOf((String)"testDatalossWhenInputError");
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        byte[] rowName = tableName.getName();
        int countPerFamily = 10;
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        HRegion region1 = HBaseTestingUtility.createRegionAndWAL(hri, this.hbaseRootDir, this.hbaseWALRootDir, this.conf, htd);
        Path regionDir = region1.getWALRegionDir();
        HBaseTestingUtility.closeRegionAndWAL(region1);
        WAL wal = this.createWAL(this.conf);
        HRegion region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            TestWALReplay.addRegionEdits(rowName, hcd.getName(), 10, this.ee, (Region)region, "x");
        }
        Get g = new Get(rowName);
        Result result = region.get(g);
        Assert.assertEquals((long)(10 * htd.getFamilies().size()), (long)result.size());
        region.close(true);
        wal.shutdown();
        this.runWALSplit(this.conf);
        Path editFile = (Path)WALSplitter.getSplitEditFilesSorted((FileSystem)this.fs, (Path)regionDir).first();
        FSDataInputStream stream = this.fs.open(editFile);
        stream.seek((long)ProtobufLogReader.PB_WAL_MAGIC.length);
        Class logReaderClass = this.conf.getClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, DefaultWALProvider.Reader.class);
        DefaultWALProvider.Reader reader = (DefaultWALProvider.Reader)logReaderClass.newInstance();
        reader.init(this.fs, editFile, this.conf, stream);
        final long headerLength = stream.getPos();
        reader.close();
        FileSystem spyFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                FSDataInputStream stream = (FSDataInputStream)invocation.callRealMethod();
                Field field = FilterInputStream.class.getDeclaredField("in");
                field.setAccessible(true);
                final DFSInputStream in = (DFSInputStream)field.get(stream);
                DFSInputStream spyIn = (DFSInputStream)Mockito.spy((Object)in);
                ((DFSInputStream)Mockito.doAnswer((Answer)new Answer<Integer>(){
                    private long pos;

                    public Integer answer(InvocationOnMock invocation) throws Throwable {
                        if (this.pos >= headerLength) {
                            throw new IOException("read over limit");
                        }
                        int b = (Integer)invocation.callRealMethod();
                        if (b > 0) {
                            this.pos += (long)b;
                        }
                        return b;
                    }
                }).when((Object)spyIn)).read((byte[])Matchers.any(byte[].class), ((Integer)Matchers.any(Integer.TYPE)).intValue(), ((Integer)Matchers.any(Integer.TYPE)).intValue());
                ((DFSInputStream)Mockito.doAnswer((Answer)new Answer<Void>(){

                    public Void answer(InvocationOnMock invocation) throws Throwable {
                        invocation.callRealMethod();
                        in.close();
                        return null;
                    }
                }).when((Object)spyIn)).close();
                field.set(stream, spyIn);
                return stream;
            }
        }).when((Object)spyFs)).open((Path)Matchers.eq((Object)editFile));
        WAL wal2 = this.createWAL(this.conf);
        try {
            region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)spyFs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
            Assert.assertEquals((long)result.size(), (long)region2.get(g).size());
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"read over limit", (Object)e.getMessage());
        }
        region2 = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2);
        Assert.assertEquals((long)result.size(), (long)region2.get(g).size());
    }

    private void testNameConflictWhenSplit(boolean largeFirst) throws IOException {
        FileStatus second;
        FileStatus first;
        TableName tableName = TableName.valueOf((String)"testReplayEditsWrittenIntoWAL");
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(tableName);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        HTableDescriptor htd = this.createBasic1FamilyHTD(tableName);
        HRegion region = HBaseTestingUtility.createRegionAndWAL(hri, this.hbaseRootDir, this.hbaseWALRootDir, this.conf, htd);
        HBaseTestingUtility.closeRegionAndWAL(region);
        byte[] family = htd.getColumnFamilies()[0].getName();
        byte[] rowName = tableName.getName();
        FSWALEntry entry1 = this.createFSWALEntry(htd, hri, 1L, rowName, family, this.ee, mvcc, 1);
        FSWALEntry entry2 = this.createFSWALEntry(htd, hri, 2L, rowName, family, this.ee, mvcc, 2);
        Path largeFile = new Path(this.logDir, "wal-1");
        Path smallFile = new Path(this.logDir, "wal-2");
        this.writerWALFile(largeFile, Arrays.asList(entry1, entry2));
        this.writerWALFile(smallFile, Arrays.asList(entry2));
        if (largeFirst) {
            first = this.fs.getFileStatus(largeFile);
            second = this.fs.getFileStatus(smallFile);
        } else {
            first = this.fs.getFileStatus(smallFile);
            second = this.fs.getFileStatus(largeFile);
        }
        WALSplitter.splitLogFile((Path)this.hbaseWALRootDir, (FileStatus)first, (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (ZooKeeperProtos.SplitLogTask.RecoveryMode)ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING, (WALFactory)this.wals);
        WALSplitter.splitLogFile((Path)this.hbaseWALRootDir, (FileStatus)second, (FileSystem)this.fs, (Configuration)this.conf, null, null, null, (ZooKeeperProtos.SplitLogTask.RecoveryMode)ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING, (WALFactory)this.wals);
        WAL wal = this.createWAL(this.conf);
        region = HRegion.openHRegion((Configuration)this.conf, (FileSystem)this.fs, (Path)this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal);
        Assert.assertTrue((region.getOpenSeqNum() > mvcc.getWritePoint() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)region.get(new Get(rowName)).size());
    }

    @Test
    public void testNameConflictWhenSplit0() throws IOException {
        this.testNameConflictWhenSplit(true);
    }

    @Test
    public void testNameConflictWhenSplit1() throws IOException {
        this.testNameConflictWhenSplit(false);
    }

    private HTableDescriptor createBasic1FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        return htd;
    }

    private MockWAL createMockWAL() throws IOException {
        MockWAL wal = new MockWAL(this.fs, this.hbaseWALRootDir, this.logName, this.conf);
        HBaseTestingUtility.setMaxRecoveryErrorCount(wal.getOutputStream(), 1);
        return wal;
    }

    private WALKey createWALKey(TableName tableName, HRegionInfo hri, MultiVersionConcurrencyControl mvcc) {
        return new WALKey(hri.getEncodedNameAsBytes(), tableName, 999L, mvcc);
    }

    private WALEdit createWALEdit(byte[] rowName, byte[] family, EnvironmentEdge ee, int index) {
        byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(index));
        byte[] columnBytes = Bytes.toBytes((String)(Bytes.toString((byte[])family) + ":" + Integer.toString(index)));
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(rowName, family, qualifierBytes, ee.currentTime(), columnBytes));
        return edit;
    }

    private FSWALEntry createFSWALEntry(HTableDescriptor htd, HRegionInfo hri, long sequence, byte[] rowName, byte[] family, EnvironmentEdge ee, MultiVersionConcurrencyControl mvcc, int index) throws IOException {
        FSWALEntry entry = new FSWALEntry(sequence, this.createWALKey(htd.getTableName(), hri, mvcc), this.createWALEdit(rowName, family, ee, index), htd, hri, true);
        entry.stampRegionSequenceId(mvcc.begin());
        return entry;
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, WAL wal, HTableDescriptor htd, MultiVersionConcurrencyControl mvcc) throws IOException {
        for (int j = 0; j < count; ++j) {
            wal.append(htd, hri, this.createWALKey(tableName, hri, mvcc), this.createWALEdit(rowName, family, ee, j), true);
        }
        wal.sync();
    }

    static List<Put> addRegionEdits(byte[] rowName, byte[] family, int count, EnvironmentEdge ee, Region r, String qualifierPrefix) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int j = 0; j < count; ++j) {
            byte[] qualifier = Bytes.toBytes((String)(qualifierPrefix + Integer.toString(j)));
            Put p = new Put(rowName);
            p.add(family, qualifier, ee.currentTime(), rowName);
            r.put(p);
            puts.add(p);
        }
        return puts;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(TableName tableName) {
        return new HRegionInfo(tableName, null, null, false);
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = WALSplitter.split((Path)this.hbaseWALRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FSUtils.getWALFileSystem((Configuration)c), (Configuration)c, (WALFactory)this.wals);
        Assert.assertEquals((String)("splits=" + splits), (long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info((Object)("Split file=" + splits.get(0)));
        return (Path)splits.get(0);
    }

    private WAL createWAL(Configuration c) throws IOException {
        FSHLog wal = new FSHLog(FSUtils.getWALFileSystem((Configuration)c), this.hbaseWALRootDir, this.logName, c);
        HBaseTestingUtility.setMaxRecoveryErrorCount(wal.getOutputStream(), 1);
        return wal;
    }

    private HTableDescriptor createBasic3FamilyHTD(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }

    private void writerWALFile(Path file, List<FSWALEntry> entries) throws IOException {
        this.fs.mkdirs(file.getParent());
        ProtobufLogWriter writer = new ProtobufLogWriter();
        writer.init(this.fs, file, this.conf, true);
        for (FSWALEntry entry : entries) {
            writer.append((WAL.Entry)entry);
        }
        writer.sync();
        writer.close();
    }

    class TestFlusher
    implements FlushRequester {
        TestFlusher() {
        }

        public boolean requestFlush(Region region, boolean force) {
            try {
                region.flush(force);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException("Exception flushing", e);
            }
        }

        public boolean requestDelayedFlush(Region region, long when, boolean forceFlushAllStores) {
            return true;
        }

        public void registerFlushRequestListener(FlushRequestListener listener) {
        }

        public boolean unregisterFlushRequestListener(FlushRequestListener listener) {
            return false;
        }

        public void setGlobalMemstoreLimit(long globalMemStoreSize) {
        }
    }

    static class MockWAL
    extends FSHLog {
        boolean doCompleteCacheFlush = false;

        public MockWAL(FileSystem fs, Path walRootDir, String logName, Configuration conf) throws IOException {
            super(fs, walRootDir, logName, "oldWALs", conf, null, true, null, null);
        }

        public void completeCacheFlush(byte[] encodedRegionName) {
            if (!this.doCompleteCacheFlush) {
                return;
            }
            super.completeCacheFlush(encodedRegionName);
        }
    }

    public static class CustomStoreFlusher
    extends DefaultStoreFlusher {
        static final AtomicBoolean throwExceptionWhenFlushing = new AtomicBoolean(false);

        public CustomStoreFlusher(Configuration conf, Store store) {
            super(conf, store);
        }

        public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController) throws IOException {
            if (throwExceptionWhenFlushing.get()) {
                throw new IOException("Simulated exception by tests");
            }
            return super.flushSnapshot(snapshot, cacheFlushId, status, throughputController);
        }
    }
}

