/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FaultySequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.InstrumentedLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWALSplit {
    private static final Log LOG = LogFactory.getLog(TestWALSplit.class);
    private static Configuration conf;
    private FileSystem fs;
    protected static final HBaseTestingUtility TEST_UTIL;
    private Path HBASEDIR;
    private Path HBASELOGDIR;
    private Path WALDIR;
    private Path OLDLOGDIR;
    private Path CORRUPTDIR;
    private Path TABLEDIR;
    private String TMPDIRNAME;
    private static final int NUM_WRITERS = 10;
    private static final int ENTRIES = 10;
    private static final String FILENAME_BEING_SPLIT = "testfile";
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static final String WAL_FILE_PREFIX = "wal.dat.";
    private static List<String> REGIONS;
    private static final String HBASE_SKIP_ERRORS = "hbase.hlog.split.skip.errors";
    private static String ROBBER;
    private static String ZOMBIE;
    private static String[] GROUP;
    private ZooKeeperProtos.SplitLogTask.RecoveryMode mode;
    @Rule
    public TestName name = new TestName();
    private WALFactory wals = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.hlog.writer.impl", InstrumentedLogWriter.class, WALProvider.Writer.class);
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(2);
        ROBBER = User.getCurrent().getName() + "-robber";
        ZOMBIE = User.getCurrent().getName() + "-zombie";
        u2g_map.put(ROBBER, GROUP);
        u2g_map.put(ZOMBIE, GROUP);
        DFSTestUtil.updateConfWithFakeGroupMapping((Configuration)conf, u2g_map);
        conf.setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.startMiniDFSCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Before
    public void setUp() throws Exception {
        LOG.info((Object)"Cleaning up cluster for new test.");
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.HBASEDIR = TEST_UTIL.createRootDir();
        this.HBASELOGDIR = TEST_UTIL.createWALRootDir();
        this.OLDLOGDIR = new Path(this.HBASELOGDIR, "oldWALs");
        this.CORRUPTDIR = new Path(this.HBASELOGDIR, "corrupt");
        this.TABLEDIR = FSUtils.getTableDir((Path)this.HBASEDIR, (TableName)TABLE_NAME);
        this.TMPDIRNAME = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        REGIONS.clear();
        Collections.addAll(REGIONS, "bbb", "ccc");
        InstrumentedLogWriter.activateFailure = false;
        this.mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        this.wals = new WALFactory(conf, null, this.name.getMethodName());
        this.WALDIR = new Path(this.HBASELOGDIR, DefaultWALProvider.getWALDirectoryName((String)this.name.getMethodName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            this.wals.close();
        }
        catch (IOException exception) {
            LOG.info((Object)"Ignoring an error while closing down our WALFactory. Fine for some tests, but if you see a failure look here.");
            LOG.debug((Object)"exception details", (Throwable)exception);
        }
        finally {
            this.wals = null;
            this.fs.delete(this.HBASEDIR, true);
            this.fs.delete(this.HBASELOGDIR, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLogCannotBeWrittenOnceParsed() throws IOException, InterruptedException {
        AtomicLong counter = new AtomicLong(0L);
        AtomicBoolean stop = new AtomicBoolean(false);
        final String region = REGIONS.get(0);
        int numWriters = 3;
        ZombieLastLogWriterRegionServer zombie = new ZombieLastLogWriterRegionServer(counter, stop, region, 3);
        try {
            long startCount = counter.get();
            zombie.start();
            while (startCount == counter.get()) {
                Threads.sleep((long)1L);
            }
            Threads.sleep((long)1000L);
            final Configuration conf2 = HBaseConfiguration.create((Configuration)conf);
            User robber = User.createUserForTesting((Configuration)conf2, (String)ROBBER, (String[])GROUP);
            int count = (Integer)robber.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    StringBuilder ls = new StringBuilder("Contents of WALDIR (").append(TestWALSplit.this.WALDIR).append("):\n");
                    for (FileStatus status : TestWALSplit.this.fs.listStatus(TestWALSplit.this.WALDIR)) {
                        ls.append("\t").append(status.toString()).append("\n");
                    }
                    LOG.debug((Object)ls);
                    LOG.info((Object)"Splitting WALs out from under zombie. Expecting 3 files.");
                    WALSplitter.split((Path)TestWALSplit.this.HBASELOGDIR, (Path)TestWALSplit.this.WALDIR, (Path)TestWALSplit.this.OLDLOGDIR, (FileSystem)TestWALSplit.this.fs, (Configuration)conf2, (WALFactory)TestWALSplit.this.wals);
                    LOG.info((Object)"Finished splitting out from under zombie.");
                    Path[] logfiles = TestWALSplit.this.getLogForRegion(TABLE_NAME, region);
                    Assert.assertEquals((String)"wrong number of split files for region", (long)3L, (long)logfiles.length);
                    int count = 0;
                    for (Path logfile : logfiles) {
                        count += TestWALSplit.this.countWAL(logfile);
                    }
                    return count;
                }
            });
            LOG.info((Object)("zombie=" + counter.get() + ", robber=" + count));
            Assert.assertTrue((String)("The log file could have at most 1 extra log entry, but can't have less. Zombie could write " + counter.get() + " and logfile had only " + count), (counter.get() == (long)count || counter.get() + 1L == (long)count ? 1 : 0) != 0);
        }
        finally {
            stop.set(true);
            zombie.interrupt();
            Threads.threadDumpingIsAlive((Thread)zombie);
        }
    }

    @Test(timeout=300000L)
    public void testRecoveredEditsPathForMeta() throws IOException {
        byte[] encoded = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
        Path tdir = FSUtils.getTableDir((Path)this.HBASEDIR, (TableName)TableName.META_TABLE_NAME);
        Path regiondir = new Path(tdir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        this.fs.mkdirs(regiondir);
        long now = System.currentTimeMillis();
        WAL.Entry entry = new WAL.Entry(new WALKey(encoded, TableName.META_TABLE_NAME, 1L, now, HConstants.DEFAULT_CLUSTER_ID), new WALEdit());
        Path p = WALSplitter.getRegionSplitEditsPath((WAL.Entry)entry, (String)FILENAME_BEING_SPLIT, (String)this.TMPDIRNAME, (Configuration)conf);
        String parentOfParent = p.getParent().getParent().getName();
        Assert.assertEquals((Object)parentOfParent, (Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    @Test(timeout=300000L)
    public void testOldRecoveredEditsFileSidelined() throws IOException {
        byte[] encoded = HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes();
        Path tdir = FSUtils.getTableDir((Path)this.HBASEDIR, (TableName)TableName.META_TABLE_NAME);
        Path regiondir = new Path(tdir, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        this.fs.mkdirs(regiondir);
        long now = System.currentTimeMillis();
        WAL.Entry entry = new WAL.Entry(new WALKey(encoded, TableName.META_TABLE_NAME, 1L, now, HConstants.DEFAULT_CLUSTER_ID), new WALEdit());
        Path parent = WALSplitter.getRegionDirRecoveredEditsDir((Path)regiondir);
        Assert.assertEquals((Object)parent.getName(), (Object)"recovered.edits");
        this.fs.createNewFile(parent);
        Path p = WALSplitter.getRegionSplitEditsPath((WAL.Entry)entry, (String)FILENAME_BEING_SPLIT, (String)this.TMPDIRNAME, (Configuration)conf);
        String parentOfParent = p.getParent().getParent().getName();
        Assert.assertEquals((Object)parentOfParent, (Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        WALFactory.createRecoveredEditsWriter((FileSystem)this.fs, (Path)p, (Configuration)conf).close();
    }

    private void useDifferentDFSClient() throws IOException {
        this.fs.initialize(this.fs.getUri(), conf);
    }

    @Test(timeout=300000L)
    public void testSplitPreservesEdits() throws IOException {
        String REGION = "region__1";
        REGIONS.clear();
        REGIONS.add("region__1");
        this.generateWALs(1, 10, -1, 0);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path originalLog = this.fs.listStatus(this.OLDLOGDIR)[0].getPath();
        Path[] splitLog = this.getLogForRegion(TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        Assert.assertTrue((String)"edits differ after split", (boolean)this.logsAreEqual(originalLog, splitLog[0]));
    }

    @Test(timeout=300000L)
    public void testSplitRemovesRegionEventsEdits() throws IOException {
        String REGION = "region__1";
        REGIONS.clear();
        REGIONS.add("region__1");
        this.generateWALs(1, 10, -1, 100);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path originalLog = this.fs.listStatus(this.OLDLOGDIR)[0].getPath();
        Path[] splitLog = this.getLogForRegion(TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        Assert.assertFalse((String)"edits differ after split", (boolean)this.logsAreEqual(originalLog, splitLog[0]));
        Assert.assertEquals((long)10L, (long)this.countWAL(splitLog[0]));
    }

    @Test(timeout=300000L)
    public void testSplitLeavesCompactionEventsEdits() throws IOException {
        HRegionInfo hri = new HRegionInfo(TABLE_NAME);
        REGIONS.clear();
        REGIONS.add(hri.getEncodedName());
        Path regionDir = new Path(FSUtils.getTableDir((Path)this.HBASEDIR, (TableName)TABLE_NAME), hri.getEncodedName());
        LOG.info((Object)("Creating region directory: " + regionDir));
        Assert.assertTrue((boolean)this.fs.mkdirs(regionDir));
        WALProvider.Writer writer = this.generateWALs(1, 10, 0, 10);
        String[] compactInputs = new String[]{"file1", "file2", "file3"};
        String compactOutput = "file4";
        TestWALSplit.appendCompactionEvent(writer, hri, compactInputs, compactOutput);
        writer.close();
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path originalLog = this.fs.listStatus(this.OLDLOGDIR)[0].getPath();
        Assert.assertEquals((long)21L, (long)this.countWAL(originalLog));
        Path[] splitLog = this.getLogForRegion(TABLE_NAME, hri.getEncodedName());
        Assert.assertEquals((long)1L, (long)splitLog.length);
        Assert.assertFalse((String)"edits differ after split", (boolean)this.logsAreEqual(originalLog, splitLog[0]));
        Assert.assertEquals((long)11L, (long)this.countWAL(splitLog[0]));
    }

    private int splitAndCount(int expectedFiles, int expectedEntries) throws IOException {
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        int result = 0;
        for (String region : REGIONS) {
            Path[] logfiles = this.getLogForRegion(TABLE_NAME, region);
            Assert.assertEquals((long)expectedFiles, (long)logfiles.length);
            int count = 0;
            for (Path logfile : logfiles) {
                count += this.countWAL(logfile);
            }
            if (-1 != expectedEntries) {
                Assert.assertEquals((long)expectedEntries, (long)count);
            }
            result += count;
        }
        return result;
    }

    @Test(timeout=300000L)
    public void testEmptyLogFiles() throws IOException {
        this.testEmptyLogFiles(true);
    }

    @Test(timeout=300000L)
    public void testEmptyOpenLogFiles() throws IOException {
        this.testEmptyLogFiles(false);
    }

    private void testEmptyLogFiles(boolean close) throws IOException {
        this.fs.mkdirs(this.WALDIR);
        this.injectEmptyFile(".empty", close);
        this.generateWALs(Integer.MAX_VALUE);
        this.injectEmptyFile("empty", close);
        this.splitAndCount(10, 100);
    }

    @Test(timeout=300000L)
    public void testOpenZeroLengthReportedFileButWithDataGetsSplit() throws IOException {
        this.generateWALs(5);
        this.splitAndCount(10, 100);
    }

    @Test(timeout=300000L)
    public void testTralingGarbageCorruptionFileSkipErrorsPasses() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateWALs(Integer.MAX_VALUE);
        this.corruptWAL(new Path(this.WALDIR, "wal.dat.5"), Corruptions.APPEND_GARBAGE, true);
        this.splitAndCount(10, 100);
    }

    @Test(timeout=300000L)
    public void testFirstLineCorruptionLogFileSkipErrorsPasses() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateWALs(Integer.MAX_VALUE);
        this.corruptWAL(new Path(this.WALDIR, "wal.dat.5"), Corruptions.INSERT_GARBAGE_ON_FIRST_LINE, true);
        this.splitAndCount(9, 90);
    }

    @Test(timeout=300000L)
    public void testMiddleGarbageCorruptionSkipErrorsReadsHalfOfFile() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateWALs(Integer.MAX_VALUE);
        this.corruptWAL(new Path(this.WALDIR, "wal.dat.5"), Corruptions.INSERT_GARBAGE_IN_THE_MIDDLE, false);
        int goodEntries = 90;
        int firstHalfEntries = (int)Math.ceil(5.0) - 1;
        int allRegionsCount = this.splitAndCount(10, -1);
        Assert.assertTrue((String)"The file up to the corrupted area hasn't been parsed", (REGIONS.size() * (goodEntries + firstHalfEntries) <= allRegionsCount ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testCorruptedFileGetsArchivedIfSkipErrors() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, true);
        for (FaultySequenceFileLogReader.FailureType failureType : FaultySequenceFileLogReader.FailureType.values()) {
            Set<String> walDirContents = this.splitCorruptWALs(failureType);
            HashSet<String> archivedLogs = new HashSet<String>();
            StringBuilder archived = new StringBuilder("Archived logs in CORRUPTDIR:");
            for (FileStatus log : this.fs.listStatus(this.CORRUPTDIR)) {
                archived.append("\n\t").append(log.toString());
                archivedLogs.add(log.getPath().getName());
            }
            LOG.debug((Object)archived.toString());
            Assert.assertEquals((String)(failureType.name() + ": expected to find all of our wals corrupt."), walDirContents, archivedLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> splitCorruptWALs(FaultySequenceFileLogReader.FailureType failureType) throws IOException {
        Class backupClass = conf.getClass("hbase.regionserver.hlog.reader.impl", WAL.Reader.class);
        InstrumentedLogWriter.activateFailure = false;
        try {
            conf.setClass("hbase.regionserver.hlog.reader.impl", FaultySequenceFileLogReader.class, WAL.Reader.class);
            conf.set("faultysequencefilelogreader.failuretype", failureType.name());
            try {
                this.wals.shutdown();
            }
            catch (IOException exception) {
                LOG.debug((Object)"Ignoring problem closing WALFactory.", (Throwable)exception);
            }
            this.wals.close();
            try {
                for (FileStatus log : this.fs.listStatus(this.CORRUPTDIR)) {
                    this.fs.delete(log.getPath(), true);
                }
            }
            catch (FileNotFoundException exception) {
                LOG.debug((Object)"no previous CORRUPTDIR to clean.");
            }
            this.wals = new WALFactory(conf, null, this.name.getMethodName());
            this.generateWALs(-1);
            HashSet<String> walDirContents = new HashSet<String>();
            for (FileStatus status : this.fs.listStatus(this.WALDIR)) {
                walDirContents.add(status.getPath().getName());
            }
            this.useDifferentDFSClient();
            WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
            HashSet<String> hashSet = walDirContents;
            return hashSet;
        }
        finally {
            conf.setClass("hbase.regionserver.hlog.reader.impl", backupClass, WAL.Reader.class);
        }
    }

    @Test(timeout=300000L, expected=IOException.class)
    public void testTrailingGarbageCorruptionLogFileSkipErrorsFalseThrows() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.splitCorruptWALs(FaultySequenceFileLogReader.FailureType.BEGINNING);
    }

    @Test(timeout=300000L)
    public void testCorruptedLogFilesSkipErrorsFalseDoesNotTouchLogs() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, false);
        try {
            this.splitCorruptWALs(FaultySequenceFileLogReader.FailureType.BEGINNING);
        }
        catch (IOException e) {
            LOG.debug((Object)"split with 'skip errors' set to 'false' correctly threw");
        }
        Assert.assertEquals((String)"if skip.errors is false all files should remain in place", (long)10L, (long)this.fs.listStatus(this.WALDIR).length);
    }

    private void ignoreCorruption(Corruptions corruption, int entryCount, int expectedCount) throws IOException {
        WAL.Entry entry;
        conf.setBoolean(HBASE_SKIP_ERRORS, false);
        String REGION = "region__1";
        REGIONS.clear();
        REGIONS.add("region__1");
        Path c1 = new Path(this.WALDIR, "wal.dat.0");
        this.generateWALs(1, entryCount, -1, 0);
        this.corruptWAL(c1, corruption, true);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path[] splitLog = this.getLogForRegion(TABLE_NAME, "region__1");
        Assert.assertEquals((long)1L, (long)splitLog.length);
        int actualCount = 0;
        WAL.Reader in = this.wals.createReader(this.fs, splitLog[0]);
        while ((entry = in.next()) != null) {
            ++actualCount;
        }
        Assert.assertEquals((long)expectedCount, (long)actualCount);
        in.close();
        FileStatus[] archivedLogs = this.fs.listStatus(this.CORRUPTDIR);
        Assert.assertEquals((long)archivedLogs.length, (long)0L);
    }

    @Test(timeout=300000L)
    public void testEOFisIgnored() throws IOException {
        int entryCount = 10;
        this.ignoreCorruption(Corruptions.TRUNCATE, entryCount, entryCount - 1);
    }

    @Test(timeout=300000L)
    public void testCorruptWALTrailer() throws IOException {
        int entryCount = 10;
        this.ignoreCorruption(Corruptions.TRUNCATE_TRAILER, entryCount, entryCount);
    }

    @Test(timeout=300000L)
    public void testLogsGetArchivedAfterSplit() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateWALs(-1);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        FileStatus[] archivedLogs = this.fs.listStatus(this.OLDLOGDIR);
        Assert.assertEquals((String)"wrong number of files in the archive log", (long)10L, (long)archivedLogs.length);
    }

    @Test(timeout=300000L)
    public void testSplit() throws IOException {
        this.generateWALs(-1);
        this.splitAndCount(10, 100);
    }

    @Test(timeout=300000L)
    public void testLogDirectoryShouldBeDeletedAfterSuccessfulSplit() throws IOException {
        this.generateWALs(-1);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(this.WALDIR);
            if (statuses != null) {
                Assert.fail((String)("Files left in log dir: " + Joiner.on((String)",").join((Object[])FileUtil.stat2Paths((FileStatus[])statuses))));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L, expected=IOException.class)
    public void testSplitWillFailIfWritingToRegionFails() throws Exception {
        WALProvider.Writer writer = this.generateWALs(4);
        this.useDifferentDFSClient();
        String region = "break";
        Path regiondir = new Path(this.TABLEDIR, region);
        this.fs.mkdirs(regiondir);
        InstrumentedLogWriter.activateFailure = false;
        TestWALSplit.appendEntry(writer, TABLE_NAME, Bytes.toBytes((String)region), "r999".getBytes(), FAMILY, QUALIFIER, VALUE, 0L);
        writer.close();
        try {
            InstrumentedLogWriter.activateFailure = true;
            WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("This exception is instrumented and should only be thrown for testing"));
            throw e;
        }
        finally {
            InstrumentedLogWriter.activateFailure = false;
        }
    }

    @Test(timeout=300000L)
    public void testSplitDeletedRegion() throws IOException {
        REGIONS.clear();
        String region = "region_that_splits";
        REGIONS.add(region);
        this.generateWALs(1);
        this.useDifferentDFSClient();
        Path regiondir = new Path(this.TABLEDIR, region);
        this.fs.delete(regiondir, true);
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Assert.assertFalse((boolean)this.fs.exists(regiondir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testIOEOnOutputThread() throws Exception {
        conf.setBoolean(HBASE_SKIP_ERRORS, false);
        this.generateWALs(-1);
        this.useDifferentDFSClient();
        FileStatus[] logfiles = this.fs.listStatus(this.WALDIR);
        Assert.assertTrue((String)"There should be some log file", (logfiles != null && logfiles.length > 0 ? 1 : 0) != 0);
        int largestLogFile = 0;
        long largestSize = 0L;
        for (int i = 0; i < logfiles.length; ++i) {
            if (logfiles[i].getLen() <= largestSize) continue;
            largestLogFile = i;
            largestSize = logfiles[i].getLen();
        }
        Assert.assertTrue((String)"There should be some log greater than size 0.", (0L < largestSize ? 1 : 0) != 0);
        WALSplitter logSplitter = new WALSplitter(this.wals, conf, this.HBASEDIR, this.fs, null, null, this.mode){

            protected WALProvider.Writer createWriter(Path logfile) throws IOException {
                WALProvider.Writer mockWriter = (WALProvider.Writer)Mockito.mock(WALProvider.Writer.class);
                ((WALProvider.Writer)Mockito.doThrow((Throwable)new IOException("Injected")).when((Object)mockWriter)).append((WAL.Entry)Mockito.any());
                return mockWriter;
            }
        };
        final AtomicBoolean stop = new AtomicBoolean(false);
        final Thread someOldThread = new Thread("Some-old-thread"){

            @Override
            public void run() {
                while (!stop.get()) {
                    Threads.sleep((long)10L);
                }
            }
        };
        someOldThread.setDaemon(true);
        someOldThread.start();
        Thread t = new Thread("Background-thread-dumper"){

            @Override
            public void run() {
                try {
                    Threads.threadDumpingIsAlive((Thread)someOldThread);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            logSplitter.splitLogFile(logfiles[largestLogFile], null);
            Assert.fail((String)"Didn't throw!");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.toString().contains("Injected"));
        }
        finally {
            stop.set(true);
        }
    }

    private void retryOverHdfsProblem(FileSystem spiedFs) throws Exception {
        this.generateWALs(-1);
        this.useDifferentDFSClient();
        try {
            WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)spiedFs, (Configuration)conf, (WALFactory)this.wals);
            Assert.assertEquals((long)10L, (long)this.fs.listStatus(this.OLDLOGDIR).length);
            Assert.assertFalse((boolean)this.fs.exists(this.WALDIR));
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
    }

    @Test(timeout=300000L)
    public void testMovedWALDuringRecovery() throws Exception {
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doThrow((Throwable)new LeaseExpiredException("Injected: File does not exist")).when((Object)spiedFs)).append((Path)Mockito.any());
        this.retryOverHdfsProblem(spiedFs);
    }

    @Test(timeout=300000L)
    public void testRetryOpenDuringRecovery() throws Exception {
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){
            private final String[] errors;
            private int count;
            {
                this.errors = new String[]{"Cannot obtain block length", "Could not obtain the last block", "Blocklist for " + TestWALSplit.this.OLDLOGDIR + " has changed"};
                this.count = 0;
            }

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                if (this.count < 3) {
                    throw new IOException(this.errors[this.count++]);
                }
                return (FSDataInputStream)invocation.callRealMethod();
            }
        }).when((Object)spiedFs)).open((Path)Mockito.any(), Mockito.anyInt());
        this.retryOverHdfsProblem(spiedFs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTerminationAskedByReporter() throws IOException, WALSplitter.CorruptedLogFileException {
        this.generateWALs(1, 10, -1);
        FileStatus logfile = this.fs.listStatus(this.WALDIR)[0];
        this.useDifferentDFSClient();
        final AtomicInteger count = new AtomicInteger();
        CancelableProgressable localReporter = new CancelableProgressable(){

            public boolean progress() {
                count.getAndIncrement();
                return false;
            }
        };
        FileSystem spiedFs = (FileSystem)Mockito.spy((Object)this.fs);
        ((FileSystem)Mockito.doAnswer((Answer)new Answer<FSDataInputStream>(){

            public FSDataInputStream answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(1500L);
                return (FSDataInputStream)invocation.callRealMethod();
            }
        }).when((Object)spiedFs)).open((Path)Mockito.any(), Mockito.anyInt());
        try {
            conf.setInt("hbase.splitlog.report.period", 1000);
            boolean ret = WALSplitter.splitLogFile((Path)this.HBASEDIR, (FileStatus)logfile, (FileSystem)spiedFs, (Configuration)conf, (CancelableProgressable)localReporter, null, null, (ZooKeeperProtos.SplitLogTask.RecoveryMode)this.mode, (WALFactory)this.wals);
            Assert.assertFalse((String)"Log splitting should failed", (boolean)ret);
            Assert.assertTrue((count.get() > 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail((String)("There shouldn't be any exception but: " + e.toString()));
        }
        finally {
            conf.setInt("hbase.splitlog.report.period", 59000);
        }
    }

    @Test(timeout=300000L)
    public void testThreading() throws Exception {
        this.doTestThreading(20000, 0x8000000, 0);
    }

    @Test(timeout=300000L)
    public void testThreadingSlowWriterSmallBuffer() throws Exception {
        this.doTestThreading(200, 1024, 50);
    }

    private void doTestThreading(final int numFakeEdits, int bufferSize, final int writerSlowness) throws Exception {
        Configuration localConf = new Configuration(conf);
        localConf.setInt("hbase.regionserver.hlog.splitlog.buffersize", bufferSize);
        Path logPath = new Path(this.WALDIR, "wal.dat..fake");
        FSDataOutputStream out = this.fs.create(logPath);
        out.close();
        ImmutableList regions = ImmutableList.of((Object)"r0", (Object)"r1", (Object)"r2", (Object)"r3", (Object)"r4");
        this.makeRegionDirs((List<String>)regions);
        WALSplitter logSplitter = new WALSplitter(this.wals, localConf, this.HBASEDIR, this.fs, null, null, this.mode, (List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
                super(x0, x1, x2, x3, x4, x5, x6);
            }

            protected WALProvider.Writer createWriter(Path logfile) throws IOException {
                WALProvider.Writer mockWriter = (WALProvider.Writer)Mockito.mock(WALProvider.Writer.class);
                ((WALProvider.Writer)Mockito.doAnswer((Answer)new Answer<Void>(){
                    int expectedIndex = 0;

                    public Void answer(InvocationOnMock invocation) {
                        if (writerSlowness > 0) {
                            try {
                                Thread.sleep(writerSlowness);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        WAL.Entry entry = (WAL.Entry)invocation.getArguments()[0];
                        WALEdit edit = entry.getEdit();
                        ArrayList cells = edit.getCells();
                        Assert.assertEquals((long)1L, (long)cells.size());
                        Cell cell = (Cell)cells.get(0);
                        Assert.assertEquals((long)this.expectedIndex, (long)Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
                        ++this.expectedIndex;
                        return null;
                    }
                }).when((Object)mockWriter)).append((WAL.Entry)Mockito.any());
                return mockWriter;
            }

            protected WAL.Reader getReader(Path curLogFile, CancelableProgressable reporter) throws IOException {
                WAL.Reader mockReader = (WAL.Reader)Mockito.mock(WAL.Reader.class);
                ((WAL.Reader)Mockito.doAnswer((Answer)new Answer<WAL.Entry>(){
                    int index = 0;

                    public WAL.Entry answer(InvocationOnMock invocation) throws Throwable {
                        if (this.index >= numFakeEdits) {
                            return null;
                        }
                        int regionIdx = this.index % val$regions.size();
                        byte[] region = new byte[]{114, (byte)(48 + regionIdx)};
                        WAL.Entry ret = TestWALSplit.createTestEntry(TABLE_NAME, region, Bytes.toBytes((int)(this.index / val$regions.size())), FAMILY, QUALIFIER, VALUE, this.index);
                        ++this.index;
                        return ret;
                    }
                }).when((Object)mockReader)).next();
                return mockReader;
            }
        };
        logSplitter.splitLogFile(this.fs.getFileStatus(logPath), null);
        Map outputCounts = logSplitter.outputSink.getOutputCounts();
        for (Map.Entry entry : outputCounts.entrySet()) {
            LOG.info((Object)("Got " + entry.getValue() + " output edits for region " + Bytes.toString((byte[])((byte[])entry.getKey()))));
            Assert.assertEquals((long)((Long)entry.getValue()), (long)(numFakeEdits / regions.size()));
        }
        Assert.assertEquals((String)"Should have as many outputs as regions", (long)regions.size(), (long)outputCounts.size());
    }

    @Test(timeout=300000L)
    public void testSplitLogFileDeletedRegionDir() throws IOException {
        LOG.info((Object)"testSplitLogFileDeletedRegionDir");
        String REGION = "region__1";
        REGIONS.clear();
        REGIONS.add("region__1");
        this.generateWALs(1, 10, -1);
        this.useDifferentDFSClient();
        Path regiondir = new Path(this.TABLEDIR, "region__1");
        LOG.info((Object)("Region directory is" + regiondir));
        this.fs.delete(regiondir, true);
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Assert.assertFalse((boolean)this.fs.exists(regiondir));
    }

    @Test(timeout=300000L)
    public void testSplitLogFileEmpty() throws IOException {
        LOG.info((Object)"testSplitLogFileEmpty");
        this.fs.mkdirs(this.WALDIR);
        this.injectEmptyFile(".empty", true);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path tdir = FSUtils.getTableDir((Path)this.HBASEDIR, (TableName)TABLE_NAME);
        Assert.assertFalse((boolean)this.fs.exists(tdir));
        Assert.assertEquals((long)0L, (long)this.countWAL(this.fs.listStatus(this.OLDLOGDIR)[0].getPath()));
    }

    @Test(timeout=300000L)
    public void testSplitLogFileMultipleRegions() throws IOException {
        LOG.info((Object)"testSplitLogFileMultipleRegions");
        this.generateWALs(1, 10, -1);
        this.splitAndCount(1, 10);
    }

    @Test(timeout=300000L)
    public void testSplitLogFileFirstLineCorruptionLog() throws IOException {
        conf.setBoolean(HBASE_SKIP_ERRORS, true);
        this.generateWALs(1, 10, -1);
        FileStatus logfile = this.fs.listStatus(this.WALDIR)[0];
        this.corruptWAL(logfile.getPath(), Corruptions.INSERT_GARBAGE_ON_FIRST_LINE, true);
        this.useDifferentDFSClient();
        WALSplitter.split((Path)this.HBASELOGDIR, (Path)this.WALDIR, (Path)this.OLDLOGDIR, (FileSystem)this.fs, (Configuration)conf, (WALFactory)this.wals);
        Path corruptDir = new Path(FSUtils.getWALRootDir((Configuration)conf), "corrupt");
        Assert.assertEquals((long)1L, (long)this.fs.listStatus(corruptDir).length);
    }

    @Test(timeout=300000L)
    public void testConcurrentSplitLogAndReplayRecoverEdit() throws IOException {
        LOG.info((Object)"testConcurrentSplitLogAndReplayRecoverEdit");
        String regionName = "r0";
        final Path regiondir = new Path(this.TABLEDIR, regionName);
        REGIONS.clear();
        REGIONS.add(regionName);
        this.generateWALs(-1);
        this.wals.getWAL(Bytes.toBytes((String)regionName), null);
        FileStatus[] logfiles = this.fs.listStatus(this.WALDIR);
        Assert.assertTrue((String)"There should be some log file", (logfiles != null && logfiles.length > 0 ? 1 : 0) != 0);
        WALSplitter logSplitter = new WALSplitter(this.wals, conf, this.HBASEDIR, this.fs, null, null, this.mode){

            protected WALProvider.Writer createWriter(Path logfile) throws IOException {
                WALProvider.Writer writer = TestWALSplit.this.wals.createRecoveredEditsWriter(this.walFS, logfile);
                NavigableSet files = WALSplitter.getSplitEditFilesSorted((FileSystem)TestWALSplit.this.fs, (Path)regiondir);
                if (files != null && !files.isEmpty()) {
                    for (Path file : files) {
                        if (!this.walFS.delete(file, false)) {
                            LOG.error((Object)("Failed delete of " + file));
                            continue;
                        }
                        LOG.debug((Object)("Deleted recovered.edits file=" + file));
                    }
                }
                return writer;
            }
        };
        try {
            logSplitter.splitLogFile(logfiles[0], null);
        }
        catch (IOException e) {
            LOG.info((Object)e);
            Assert.fail((String)"Throws IOException when spliting log, it is most likely because writing file does not exist which is caused by concurrent replayRecoveredEditsIfAny()");
        }
        if (this.fs.exists(this.CORRUPTDIR) && this.fs.listStatus(this.CORRUPTDIR).length > 0) {
            Assert.fail((String)"There are some corrupt logs, it is most likely caused by concurrent replayRecoveredEditsIfAny()");
        }
    }

    private WALProvider.Writer generateWALs(int leaveOpen) throws IOException {
        return this.generateWALs(10, 10, leaveOpen, 0);
    }

    private WALProvider.Writer generateWALs(int writers, int entries, int leaveOpen) throws IOException {
        return this.generateWALs(writers, entries, leaveOpen, 7);
    }

    private void makeRegionDirs(List<String> regions) throws IOException {
        for (String region : regions) {
            LOG.debug((Object)("Creating dir for region " + region));
            this.fs.mkdirs(new Path(this.TABLEDIR, region));
        }
    }

    private WALProvider.Writer generateWALs(int writers, int entries, int leaveOpen, int regionEvents) throws IOException {
        this.makeRegionDirs(REGIONS);
        this.fs.mkdirs(this.WALDIR);
        WALProvider.Writer[] ws = new WALProvider.Writer[writers];
        int seq = 0;
        int numRegionEventsAdded = 0;
        for (int i = 0; i < writers; ++i) {
            ws[i] = this.wals.createWALWriter(this.fs, new Path(this.WALDIR, WAL_FILE_PREFIX + i));
            for (int j = 0; j < entries; ++j) {
                int prefix = 0;
                for (String region : REGIONS) {
                    String row_key = region + prefix++ + i + j;
                    TestWALSplit.appendEntry(ws[i], TABLE_NAME, region.getBytes(), row_key.getBytes(), FAMILY, QUALIFIER, VALUE, seq++);
                    if (numRegionEventsAdded >= regionEvents) continue;
                    ++numRegionEventsAdded;
                    TestWALSplit.appendRegionEvent(ws[i], region);
                }
            }
            if (i == leaveOpen) continue;
            ws[i].close();
            LOG.info((Object)("Closing writer " + i));
        }
        if (leaveOpen < 0 || leaveOpen >= writers) {
            return null;
        }
        return ws[leaveOpen];
    }

    private Path[] getLogForRegion(TableName table, String region) throws IOException {
        Path tdir = FSUtils.getWALTableDir((Configuration)conf, (TableName)table);
        Path editsdir = WALSplitter.getRegionDirRecoveredEditsDir((Path)HRegion.getRegionDir((Path)tdir, (String)Bytes.toString((byte[])region.getBytes())));
        FileStatus[] files = this.fs.listStatus(editsdir, new PathFilter(){

            public boolean accept(Path p) {
                return !WALSplitter.isSequenceIdFile((Path)p);
            }
        });
        Path[] paths = new Path[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = files[i].getPath();
        }
        return paths;
    }

    private void corruptWAL(Path path, Corruptions corruption, boolean close) throws IOException {
        int fileSize = (int)this.fs.listStatus(path)[0].getLen();
        FSDataInputStream in = this.fs.open(path);
        byte[] corrupted_bytes = new byte[fileSize];
        in.readFully(0L, corrupted_bytes, 0, fileSize);
        in.close();
        switch (corruption) {
            case APPEND_GARBAGE: {
                this.fs.delete(path, false);
                FSDataOutputStream out = this.fs.create(path);
                out.write(corrupted_bytes);
                out.write("-----".getBytes());
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_ON_FIRST_LINE: {
                this.fs.delete(path, false);
                FSDataOutputStream out = this.fs.create(path);
                out.write(0);
                out.write(corrupted_bytes);
                this.closeOrFlush(close, out);
                break;
            }
            case INSERT_GARBAGE_IN_THE_MIDDLE: {
                this.fs.delete(path, false);
                FSDataOutputStream out = this.fs.create(path);
                int middle = (int)Math.floor(corrupted_bytes.length / 2);
                out.write(corrupted_bytes, 0, middle);
                out.write(0);
                out.write(corrupted_bytes, middle, corrupted_bytes.length - middle);
                this.closeOrFlush(close, out);
                break;
            }
            case TRUNCATE: {
                this.fs.delete(path, false);
                FSDataOutputStream out = this.fs.create(path);
                out.write(corrupted_bytes, 0, fileSize - (32 + ProtobufLogReader.PB_WAL_COMPLETE_MAGIC.length + 4));
                this.closeOrFlush(close, out);
                break;
            }
            case TRUNCATE_TRAILER: {
                this.fs.delete(path, false);
                FSDataOutputStream out = this.fs.create(path);
                out.write(corrupted_bytes, 0, fileSize - 4);
                this.closeOrFlush(close, out);
            }
        }
    }

    private void closeOrFlush(boolean close, FSDataOutputStream out) throws IOException {
        if (close) {
            out.close();
        } else {
            Method syncMethod = null;
            try {
                syncMethod = out.getClass().getMethod("hflush", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    syncMethod = out.getClass().getMethod("sync", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    throw new IOException("This version of Hadoop supports neither Syncable.sync() nor Syncable.hflush().");
                }
            }
            try {
                syncMethod.invoke((Object)out, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private int countWAL(Path log) throws IOException {
        int count = 0;
        WAL.Reader in = this.wals.createReader(this.fs, log);
        while (in.next() != null) {
            ++count;
        }
        in.close();
        return count;
    }

    private static void appendCompactionEvent(WALProvider.Writer w, HRegionInfo hri, String[] inputs, String output) throws IOException {
        WALProtos.CompactionDescriptor.Builder desc = WALProtos.CompactionDescriptor.newBuilder();
        desc.setTableName(ByteString.copyFrom((byte[])hri.getTable().toBytes())).setEncodedRegionName(ByteString.copyFrom((byte[])hri.getEncodedNameAsBytes())).setRegionName(ByteString.copyFrom((byte[])hri.getRegionName())).setFamilyName(ByteString.copyFrom((byte[])FAMILY)).setStoreHomeDir(hri.getEncodedName() + "/" + Bytes.toString((byte[])FAMILY)).addAllCompactionInput(Arrays.asList(inputs)).addCompactionOutput(output);
        WALEdit edit = WALEdit.createCompaction((HRegionInfo)hri, (WALProtos.CompactionDescriptor)desc.build());
        WALKey key = new WALKey(hri.getEncodedNameAsBytes(), TABLE_NAME, 1L, EnvironmentEdgeManager.currentTime(), HConstants.DEFAULT_CLUSTER_ID);
        w.append(new WAL.Entry(key, edit));
        w.sync();
    }

    private static void appendRegionEvent(WALProvider.Writer w, String region) throws IOException {
        WALProtos.RegionEventDescriptor regionOpenDesc = ProtobufUtil.toRegionEventDescriptor((WALProtos.RegionEventDescriptor.EventType)WALProtos.RegionEventDescriptor.EventType.REGION_OPEN, (byte[])TABLE_NAME.toBytes(), (byte[])region.getBytes(), (byte[])String.valueOf(region.hashCode()).getBytes(), (long)1L, (ServerName)ServerName.parseServerName((String)"ServerName:9099"), (Map)ImmutableMap.of());
        long time = EnvironmentEdgeManager.currentTime();
        KeyValue kv = new KeyValue(region.getBytes(), WALEdit.METAFAMILY, WALEdit.REGION_EVENT, time, regionOpenDesc.toByteArray());
        WALKey walKey = new WALKey(region.getBytes(), TABLE_NAME, 1L, time, HConstants.DEFAULT_CLUSTER_ID);
        w.append(new WAL.Entry(walKey, new WALEdit().add((Cell)kv)));
        w.sync();
    }

    public static long appendEntry(WALProvider.Writer writer, TableName table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) throws IOException {
        LOG.info((Object)(Thread.currentThread().getName() + " append"));
        writer.append(TestWALSplit.createTestEntry(table, region, row, family, qualifier, value, seq));
        LOG.info((Object)(Thread.currentThread().getName() + " sync"));
        writer.sync();
        return seq;
    }

    private static WAL.Entry createTestEntry(TableName table, byte[] region, byte[] row, byte[] family, byte[] qualifier, byte[] value, long seq) {
        long time = System.nanoTime();
        KeyValue cell = new KeyValue(row, family, qualifier, time, KeyValue.Type.Put, value);
        WALEdit edit = new WALEdit();
        edit.add((Cell)cell);
        return new WAL.Entry(new WALKey(region, table, ++seq, time, HConstants.DEFAULT_CLUSTER_ID), edit);
    }

    private void injectEmptyFile(String suffix, boolean closeFile) throws IOException {
        WALProvider.Writer writer = WALFactory.createWALWriter((FileSystem)this.fs, (Path)new Path(this.WALDIR, WAL_FILE_PREFIX + suffix), (Configuration)conf);
        if (closeFile) {
            writer.close();
        }
    }

    private boolean logsAreEqual(Path p1, Path p2) throws IOException {
        WAL.Entry entry1;
        WAL.Reader in1 = this.wals.createReader(this.fs, p1);
        WAL.Reader in2 = this.wals.createReader(this.fs, p2);
        while ((entry1 = in1.next()) != null) {
            WAL.Entry entry2 = in2.next();
            if (entry1.getKey().compareTo(entry2.getKey()) == 0 && entry1.getEdit().toString().equals(entry2.getEdit().toString())) continue;
            return false;
        }
        in1.close();
        in2.close();
        return true;
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        TABLE_NAME = TableName.valueOf((String)"t1");
        FAMILY = "f1".getBytes();
        QUALIFIER = "q1".getBytes();
        VALUE = "v1".getBytes();
        REGIONS = new ArrayList<String>();
        GROUP = new String[]{"supergroup"};
    }

    class ZombieLastLogWriterRegionServer
    extends Thread {
        final AtomicLong editsCount;
        final AtomicBoolean stop;
        final int numOfWriters;
        final String region;
        final User user;

        public ZombieLastLogWriterRegionServer(AtomicLong counter, AtomicBoolean stop, String region, int writers) throws IOException, InterruptedException {
            super("ZombieLastLogWriterRegionServer");
            this.setDaemon(true);
            this.stop = stop;
            this.editsCount = counter;
            this.region = region;
            this.user = User.createUserForTesting((Configuration)conf, (String)ZOMBIE, (String[])GROUP);
            this.numOfWriters = writers;
        }

        @Override
        public void run() {
            try {
                this.doWriting();
            }
            catch (IOException e) {
                LOG.warn((Object)(this.getName() + " Writer exiting " + e));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(this.getName() + " Writer exiting " + e));
            }
        }

        private void doWriting() throws IOException, InterruptedException {
            this.user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int walToKeepOpen = ZombieLastLogWriterRegionServer.this.numOfWriters - 1;
                    WALProvider.Writer writer = null;
                    try {
                        writer = TestWALSplit.this.generateWALs(ZombieLastLogWriterRegionServer.this.numOfWriters, 10, walToKeepOpen);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException("Failed", e1);
                    }
                    ZombieLastLogWriterRegionServer.this.editsCount.addAndGet(ZombieLastLogWriterRegionServer.this.numOfWriters * 10);
                    ZombieLastLogWriterRegionServer.this.loop(writer);
                    try {
                        writer.close();
                        Assert.fail((String)"Writing closing after parsing should give an error.");
                    }
                    catch (IOException exception) {
                        LOG.debug((Object)"ignoring error when closing final writer.", (Throwable)exception);
                    }
                    return null;
                }
            });
        }

        private void loop(WALProvider.Writer writer) {
            byte[] regionBytes = Bytes.toBytes((String)this.region);
            while (!this.stop.get()) {
                try {
                    long seq = TestWALSplit.appendEntry(writer, TABLE_NAME, regionBytes, ("r" + this.editsCount.get()).getBytes(), regionBytes, QUALIFIER, VALUE, 0L);
                    long count = this.editsCount.incrementAndGet();
                    LOG.info((Object)(this.getName() + " sync count=" + count + ", seq=" + seq));
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException ex) {
                    LOG.error((Object)(this.getName() + " ex " + ex.toString()));
                    if (ex instanceof RemoteException) {
                        LOG.error((Object)("Juliet: got RemoteException " + ex.getMessage() + " while writing " + (this.editsCount.get() + 1L)));
                        break;
                    }
                    LOG.error((Object)(this.getName() + " failed to write....at " + this.editsCount.get()));
                    Assert.fail((String)("Failed to write " + this.editsCount.get()));
                    break;
                }
                catch (Throwable t) {
                    LOG.error((Object)(this.getName() + " HOW? " + t));
                    LOG.debug((Object)"exception details", t);
                    break;
                }
            }
            LOG.info((Object)(this.getName() + " Writer exiting"));
        }
    }

    static enum Corruptions {
        INSERT_GARBAGE_ON_FIRST_LINE,
        INSERT_GARBAGE_IN_THE_MIDDLE,
        APPEND_GARBAGE,
        TRUNCATE,
        TRUNCATE_TRAILER;

    }
}

