/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationManager {
    private final Configuration conf;
    private final ZooKeeperWatcher zkw;
    private final ReplicationQueuesClient replicationQueuesClient;
    private final ReplicationPeers replicationPeers;

    public ReplicationManager(Configuration conf, ZooKeeperWatcher zkw, Abortable abortable) throws IOException {
        this.conf = conf;
        this.zkw = zkw;
        try {
            this.replicationQueuesClient = ReplicationFactory.getReplicationQueuesClient((ReplicationQueuesClientArguments)new ReplicationQueuesClientArguments(conf, abortable, zkw));
            this.replicationQueuesClient.init();
            this.replicationPeers = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)zkw, (Configuration)conf, (ReplicationQueuesClient)this.replicationQueuesClient, (Abortable)abortable);
            this.replicationPeers.init();
        }
        catch (Exception e) {
            throw new IOException("Failed to construct ReplicationManager", e);
        }
    }

    public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        this.checkNamespacesAndTableCfsConfigConflict(peerConfig.getNamespaces(), peerConfig.getTableCFsMap());
        this.checkConfiguredWALEntryFilters(peerConfig);
        this.replicationPeers.registerPeer(peerId, peerConfig);
        this.replicationPeers.peerConnected(peerId);
    }

    public void removeReplicationPeer(String peerId) throws ReplicationException {
        this.replicationPeers.peerDisconnected(peerId);
        this.replicationPeers.unregisterPeer(peerId);
    }

    public void enableReplicationPeer(String peerId) throws ReplicationException {
        this.replicationPeers.enablePeer(peerId);
    }

    public void disableReplicationPeer(String peerId) throws ReplicationException {
        this.replicationPeers.disablePeer(peerId);
    }

    public ReplicationPeerConfig getPeerConfig(String peerId) throws ReplicationException, ReplicationPeerNotFoundException {
        ReplicationPeerConfig peerConfig = this.replicationPeers.getReplicationPeerConfig(peerId);
        if (peerConfig == null) {
            throw new ReplicationPeerNotFoundException(peerId);
        }
        return peerConfig;
    }

    public void updatePeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        this.checkNamespacesAndTableCfsConfigConflict(peerConfig.getNamespaces(), peerConfig.getTableCFsMap());
        this.checkConfiguredWALEntryFilters(peerConfig);
        this.replicationPeers.updatePeerConfig(peerId, peerConfig);
    }

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) throws ReplicationException {
        ArrayList<ReplicationPeerDescription> peers = new ArrayList<ReplicationPeerDescription>();
        List peerIds = this.replicationPeers.getAllPeerIds();
        for (String peerId : peerIds) {
            if (pattern != null && (pattern == null || !pattern.matcher(peerId).matches())) continue;
            peers.add(new ReplicationPeerDescription(peerId, this.replicationPeers.getStatusOfPeerFromBackingStore(peerId), this.replicationPeers.getReplicationPeerConfig(peerId)));
        }
        return peers;
    }

    private void checkNamespacesAndTableCfsConfigConflict(Set<String> namespaces, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException {
        if (namespaces == null || namespaces.isEmpty()) {
            return;
        }
        if (tableCfs == null || tableCfs.isEmpty()) {
            return;
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            if (!namespaces.contains(table.getNamespaceAsString())) continue;
            throw new ReplicationException("Table-cfs config conflict with namespaces config in peer");
        }
    }

    private void checkConfiguredWALEntryFilters(ReplicationPeerConfig peerConfig) throws IOException {
        String filterCSV = (String)peerConfig.getConfiguration().get("hbase.replication.source.custom.walentryfilters");
        if (filterCSV != null && !filterCSV.isEmpty()) {
            String[] filters;
            for (String filter : filters = filterCSV.split(",")) {
                try {
                    Class<?> clazz = Class.forName(filter);
                    Object obj = clazz.newInstance();
                }
                catch (Exception e) {
                    throw new DoNotRetryIOException("Configured WALEntryFilter " + filter + " could not be created. Failing add/update peer operation.", (Throwable)e);
                }
            }
        }
    }
}

