/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreSnapshot {
    private final long id;
    private final int cellsCount;
    private final long dataSize;
    private final long heapSize;
    private final TimeRangeTracker timeRangeTracker;
    private final List<KeyValueScanner> scanners;
    private final boolean tagsPresent;

    public MemStoreSnapshot(long id, ImmutableSegment snapshot) {
        this.id = id;
        this.cellsCount = snapshot.getCellsCount();
        this.dataSize = snapshot.keySize();
        this.heapSize = snapshot.heapSize();
        this.timeRangeTracker = snapshot.getTimeRangeTracker();
        this.scanners = snapshot.getScanners(Long.MAX_VALUE, Long.MAX_VALUE);
        this.tagsPresent = snapshot.isTagsPresent();
    }

    public long getId() {
        return this.id;
    }

    public int getCellsCount() {
        return this.cellsCount;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public List<KeyValueScanner> getScanners() {
        return this.scanners;
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }
}

