/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Predicate;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.WALEdit;

public class BulkLoadCellFilter {
    private static final Log LOG = LogFactory.getLog(BulkLoadCellFilter.class);
    private final ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);

    public Cell filterCell(Cell cell, Predicate<byte[]> famPredicate) {
        WALProtos.BulkLoadDescriptor bld = null;
        try {
            bld = WALEdit.getBulkLoadDescriptor(cell);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get bulk load events information from the WAL file.", (Throwable)e);
            return cell;
        }
        List storesList = bld.getStoresList();
        ArrayList copiedStoresList = new ArrayList(storesList);
        Iterator copiedStoresListIterator = copiedStoresList.iterator();
        boolean anyStoreRemoved = false;
        while (copiedStoresListIterator.hasNext()) {
            WALProtos.StoreDescriptor sd = (WALProtos.StoreDescriptor)copiedStoresListIterator.next();
            byte[] fam = sd.getFamilyName().toByteArray();
            if (!famPredicate.apply((Object)fam)) continue;
            copiedStoresListIterator.remove();
            anyStoreRemoved = true;
        }
        if (!anyStoreRemoved) {
            return cell;
        }
        if (copiedStoresList.isEmpty()) {
            return null;
        }
        WALProtos.BulkLoadDescriptor.Builder newDesc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(bld.getTableName()).setEncodedRegionName(bld.getEncodedRegionName()).setBulkloadSeqNum(bld.getBulkloadSeqNum());
        newDesc.addAllStores(copiedStoresList);
        WALProtos.BulkLoadDescriptor newBulkLoadDescriptor = newDesc.build();
        return this.cellBuilder.clear().setRow(CellUtil.cloneRow((Cell)cell)).setFamily(WALEdit.METAFAMILY).setQualifier(WALEdit.BULK_LOAD).setTimestamp(cell.getTimestamp()).setType(cell.getTypeByte()).setValue(newBulkLoadDescriptor.toByteArray()).build();
    }
}

