/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RecoveredReplicationSourceWALReader
extends ReplicationSourceWALReader {
    private static final Log LOG = LogFactory.getLog(RecoveredReplicationSourceWALReader.class);

    public RecoveredReplicationSourceWALReader(FileSystem fs, Configuration conf, PriorityBlockingQueue<Path> logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source) {
        super(fs, conf, logQueue, startPosition, filter, source);
    }

    @Override
    protected void handleEmptyWALEntryBatch(ReplicationSourceWALReader.WALEntryBatch batch, Path currentPath) throws InterruptedException {
        LOG.trace((Object)"Didn't read any new entries from WAL");
        this.setReaderRunning(false);
        this.entryBatchQueue.put(batch != null ? batch : new ReplicationSourceWALReader.WALEntryBatch(this.replicationBatchCountCapacity, currentPath));
    }
}

